/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.time.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.time.util.Constants;
import io.ballerina.stdlib.time.util.ModuleUtils;
import io.ballerina.stdlib.time.util.Utils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.regex.Pattern;

public class Civil {
    private final ZonedDateTime zonedDateTime;
    private boolean isSecondExists = false;
    private boolean isLocalTimeZoneExists = false;
    private final BMap<BString, Object> civilMap = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"Civil");

    public Civil(ZonedDateTime zonedDateTime) {
        this.zonedDateTime = zonedDateTime;
    }

    public Civil(String zonedDateTimeString, Constants.CivilInputStringTypes inputStringTypes) {
        if (Constants.CivilInputStringTypes.EMAIL_STRING.toString().equals(inputStringTypes.toString())) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("EEE, d MMM yyyy HH:mm:ss Z[ ][(z)]");
            this.zonedDateTime = ZonedDateTime.parse(zonedDateTimeString, dateTimeFormatter);
            this.isSecondExists = true;
            this.isLocalTimeZoneExists = true;
        } else {
            this.zonedDateTime = ZonedDateTime.parse(zonedDateTimeString);
            this.isSecondExists = this.isSecondExists(zonedDateTimeString);
            this.isLocalTimeZoneExists = this.isLocalTimeZoneExists(zonedDateTimeString);
        }
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    public BMap<BString, Object> build() {
        this.setCommonCivilFields();
        BigDecimal second = new BigDecimal(this.zonedDateTime.getSecond());
        second = second.add(new BigDecimal(this.zonedDateTime.getNano()).divide(Constants.ANALOG_GIGA, MathContext.DECIMAL128));
        this.civilMap.put((Object)Constants.TIME_OF_DAY_RECORD_SECOND_BSTRING, (Object)ValueCreator.createDecimalValue((BigDecimal)second));
        return this.civilMap;
    }

    public BMap<BString, Object> buildWithZone() {
        this.setCommonCivilFields();
        BigDecimal second = new BigDecimal(this.zonedDateTime.getSecond());
        second = second.add(new BigDecimal(this.zonedDateTime.getNano()).divide(Constants.ANALOG_GIGA, MathContext.DECIMAL128));
        if (this.isSecondExists) {
            this.civilMap.put((Object)Constants.TIME_OF_DAY_RECORD_SECOND_BSTRING, (Object)ValueCreator.createDecimalValue((BigDecimal)second));
        }
        if (this.isLocalTimeZoneExists) {
            this.civilMap.put((Object)Constants.CIVIL_RECORD_UTC_OFFSET_BSTRING, this.createZoneOffsetFromZonedDateTime(this.zonedDateTime));
        }
        return this.civilMap;
    }

    private void setCommonCivilFields() {
        this.civilMap.put((Object)Constants.DATE_RECORD_YEAR_BSTRING, (Object)this.zonedDateTime.getYear());
        this.civilMap.put((Object)Constants.DATE_RECORD_MONTH_BSTRING, (Object)this.zonedDateTime.getMonthValue());
        this.civilMap.put((Object)Constants.DATE_RECORD_DAY_BSTRING, (Object)this.zonedDateTime.getDayOfMonth());
        this.civilMap.put((Object)Constants.TIME_OF_DAY_RECORD_HOUR_BSTRING, (Object)this.zonedDateTime.getHour());
        this.civilMap.put((Object)Constants.TIME_OF_DAY_RECORD_MINUTE_BSTRING, (Object)this.zonedDateTime.getMinute());
        this.civilMap.put((Object)Constants.CIVIL_RECORD_TIME_ABBREV_BSTRING, (Object)StringUtils.fromString((String)this.zonedDateTime.getZone().toString()));
        this.civilMap.put((Object)Constants.CIVIL_RECORD_DAY_OF_WEEK_BSTRING, (Object)(this.zonedDateTime.getDayOfWeek().getValue() % 7));
    }

    private boolean isLocalTimeZoneExists(String time) {
        Pattern pattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}(:\\d{2}\\.\\d+)?(Z$)");
        return !pattern.matcher(time).find();
    }

    private boolean isSecondExists(String time) {
        Pattern pattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?");
        return pattern.matcher(time).find();
    }

    public BMap<BString, Object> createZoneOffsetFromZonedDateTime(ZonedDateTime zonedDateTime) {
        Map<String, Integer> zoneInfo = Utils.zoneOffsetMapFromString(zonedDateTime.getOffset().toString());
        return Utils.createZoneOffsetFromZoneInfoMap(zoneInfo);
    }
}

