/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.command;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.ProjectLoader;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.List;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.utils.BindgenUtils;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import picocli.CommandLine;

@CommandLine.Command(name="bindgen", description={"Generate the Ballerina bindings for Java APIs"})
public class BindgenCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream outError;
    private final boolean exitWhenFinish;
    private Path targetOutputPath = Path.of(System.getProperty("user.dir"), new String[0]);
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"-cp", "--classpath"}, description={"One or more comma-delimited classpaths for obtaining the jar files required for\ngenerating the Ballerina bindings."})
    private String classPath;
    @CommandLine.Option(names={"-mvn", "--maven"}, description={"A maven dependency with colon delimited groupId, artifactId and version."})
    private String mavenDependency;
    @CommandLine.Option(names={"-o", "--output"}, description={"Generate all bindings inside the specified directory. This option could be used to generate mappings inside a single module."})
    private String outputPath;
    @CommandLine.Option(names={"--public"}, description={"Set the visibility modifier of Ballerina bindings to public."})
    private boolean publicFlag;
    @CommandLine.Option(names={"--with-optional-types"}, description={"Generate bindings with optional(i.e. nillable) types for parameter and return types."})
    private boolean optionalTypesFlag;
    @CommandLine.Option(names={"--with-optional-types-param"}, description={"Generate bindings with optional(i.e. nillable) types for parameter types."})
    private boolean optionalTypesParamFlag;
    @CommandLine.Option(names={"--with-optional-types-return"}, description={"Generate bindings with optional(i.e. nillable) types for return types."})
    private boolean optionalTypesReturnFlag;
    @CommandLine.Parameters
    private List<String> classNames;
    private static final String BINDGEN_CMD = "bal bindgen [(-cp|--classpath) <classpath>...]\n                  [(-mvn|--maven) <groupId>:<artifactId>:<version>]\n                  [(-o|--output) <output-path>]\n                  [--public]\n                  (<class-name>...)";

    public BindgenCommand() {
        this(System.out, System.err);
    }

    public BindgenCommand(PrintStream out, PrintStream err) {
        this(out, err, true);
    }

    public BindgenCommand(PrintStream out, PrintStream err, boolean exitWhenFinish) {
        this.outStream = out;
        this.outError = err;
        this.exitWhenFinish = exitWhenFinish;
        BindgenUtils.setOutStream(out);
        BindgenUtils.setErrStream(err);
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)this.getName());
            this.outStream.println(commandUsageInfo);
            this.exitWithCode(0, this.exitWhenFinish);
            return;
        }
        if (this.classNames == null) {
            this.setOutError("one or more class names are required");
            this.exitWithCode(1, this.exitWhenFinish);
            return;
        }
        BindingsGenerator bindingsGenerator = new BindingsGenerator(this.outStream, this.outError);
        if (this.outputPath != null) {
            this.targetOutputPath = Path.of(this.outputPath, new String[0]).isAbsolute() ? Path.of(this.outputPath, new String[0]).normalize() : Path.of(this.targetOutputPath.toString(), this.outputPath).normalize();
            bindingsGenerator.setOutputPath(this.targetOutputPath.toString());
        } else {
            bindingsGenerator.setModulesFlag(true);
            bindingsGenerator.setPublic();
        }
        if (this.publicFlag) {
            bindingsGenerator.setPublic();
        }
        if (this.optionalTypesFlag && (this.optionalTypesParamFlag || this.optionalTypesReturnFlag)) {
            this.setOutError("cannot use '--with-optional-types' option with '--with-optional-types-param' or '--with-optional-types-return' options at the same time");
            this.exitWithCode(1, this.exitWhenFinish);
            return;
        }
        if (this.optionalTypesFlag) {
            bindingsGenerator.setOptionalTypesFlag();
        }
        if (this.optionalTypesParamFlag) {
            bindingsGenerator.setOptionalParamTypesFlag();
        }
        if (this.optionalTypesReturnFlag) {
            bindingsGenerator.setOptionalReturnTypesFlag();
        }
        Project project = null;
        if (!ProjectDirs.isProject((Path)this.targetOutputPath)) {
            Path projectDir = ProjectDirs.findProjectRoot((Path)this.targetOutputPath);
            if (projectDir != null) {
                try {
                    project = ProjectLoader.loadProject((Path)projectDir);
                }
                catch (ProjectException e) {
                    this.setOutError("unable to load the Ballerina package [" + String.valueOf(projectDir) + "]: " + e.getMessage());
                    this.exitWithCode(1, this.exitWhenFinish);
                    return;
                }
                this.outStream.println("\nBallerina package detected at: " + projectDir.toString());
                bindingsGenerator.setProject(project);
            }
        } else {
            try {
                project = ProjectLoader.loadProject((Path)this.targetOutputPath);
            }
            catch (ProjectException e) {
                this.setOutError("unable to load the Ballerina package [" + String.valueOf(this.targetOutputPath) + "]: " + e.getMessage());
                this.exitWithCode(1, this.exitWhenFinish);
                return;
            }
            this.outStream.println("\nBallerina package detected at: " + this.targetOutputPath.toString());
            bindingsGenerator.setProject(project);
        }
        if (this.outputPath == null && project == null) {
            this.setOutError("unable to detect a Ballerina package: bindings should either be generated inside a valid Ballerina package or the `[(-o|--output) <output-path>]` option should be used to generate the bindings inside a specific directory");
            this.exitWithCode(1, this.exitWhenFinish);
            return;
        }
        String splitCommaRegex = "\\s*,\\s*";
        if (this.classPath != null) {
            String[] dependencyList = this.classPath.split(splitCommaRegex);
            bindingsGenerator.setDependentJars(dependencyList);
        }
        String splitColonRegex = "\\s*:\\s*";
        if (this.mavenDependency != null) {
            String[] mvnDependency = this.mavenDependency.split(splitColonRegex);
            if (mvnDependency.length != 3) {
                this.setOutError("invalid maven dependency provided");
                this.exitWithCode(1, this.exitWhenFinish);
                return;
            }
            bindingsGenerator.setMvnGroupId(mvnDependency[0]);
            bindingsGenerator.setMvnArtifactId(mvnDependency[1]);
            bindingsGenerator.setMvnVersion(mvnDependency[2]);
        }
        bindingsGenerator.setClassNames(this.classNames);
        try {
            bindingsGenerator.generateJavaBindings();
            this.exitWithCode(0, this.exitWhenFinish);
        }
        catch (BindgenException e) {
            this.outError.println("\nFailed to generate the Ballerina bindings.\n" + e.getMessage());
            this.exitWithCode(1, this.exitWhenFinish);
        }
    }

    private void setOutError(String errorValue) {
        this.outError.println("\nerror: " + errorValue + "\n");
        this.outStream.println(BINDGEN_CMD);
        this.outStream.println("\nUse 'bal bindgen --help' for more information on the command.");
    }

    public void exitWithCode(int exit, boolean exitWhenFinish) {
        if (exitWhenFinish) {
            Runtime.getRuntime().exit(exit);
        }
    }

    public String getName() {
        return "bindgen";
    }

    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo((String)BINDGEN_CMD));
    }

    public void printUsage(StringBuilder out) {
        out.append("  $ bal bindgen java.utils.ArrayDeque\n");
        out.append("  $ bal bindgen -cp ./libs/snakeyaml-2.0.jar,./libs/pdfbox-1.8.10.jar -o ./modules/sample\n");
        out.append("  org.yaml.snakeyaml.Yaml org.apache.pdfbox.pdmodel.PDDocument java.io.File\n");
        out.append("  $ bal bindgen -mvn org.yaml:snakeyaml:2.0 org.yaml.snakeyaml.Yaml\n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

