/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.command;

import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.Project;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.ManifestBuilder;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.model.JClass;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.utils.BindgenEnv;
import org.ballerinalang.bindgen.utils.BindgenMvnResolver;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class BindingsGenerator {
    private final BindgenEnv env;
    private Path modulePath;
    private Path dependenciesPath;
    private Path utilsDirPath;
    private String mvnGroupId;
    private String mvnArtifactId;
    private String mvnVersion;
    private final PrintStream errStream;
    private final PrintStream outStream;
    private Set<String> classNames = new HashSet<String>();
    private final Path userDir = Path.of(System.getProperty("user.dir"), new String[0]);

    BindingsGenerator(PrintStream out, PrintStream err) {
        this.outStream = out;
        this.errStream = err;
        this.env = new BindgenEnv();
    }

    void generateJavaBindings() throws BindgenException {
        ClassLoader classLoader;
        this.outStream.println("\nResolving maven dependencies...");
        JvmTarget parentJvmTarget = this.getParentDependencyJvmTarget();
        this.resolvePlatformLibraries(parentJvmTarget);
        if (this.mvnGroupId != null && this.mvnArtifactId != null && this.mvnVersion != null) {
            new BindgenMvnResolver(this.outStream, this.env).mavenResolver(this.mvnGroupId, this.mvnArtifactId, this.mvnVersion, this.env.getProjectRoot(), true, parentJvmTarget);
        }
        if ((classLoader = this.setClassLoader()) != null) {
            this.setDirectoryPaths();
            this.outStream.println("\nGenerating bindings for: ");
            this.generateBindings(this.classNames, classLoader, this.modulePath);
            if (!this.env.getSuperClasses().isEmpty()) {
                this.env.setAllJavaClasses(this.env.getSuperClasses());
                this.env.getSuperClasses().removeAll(this.classNames);
                this.generateBindings(new HashSet<String>(this.env.getSuperClasses()), classLoader, this.modulePath);
            }
            if (!this.env.getClassListForLooping().isEmpty()) {
                this.outStream.println("\nGenerating dependency bindings for: ");
                this.env.setDirectJavaClass(false);
            }
            while (!this.env.getClassListForLooping().isEmpty()) {
                HashSet<String> newSet = new HashSet<String>(this.env.getClassListForLooping());
                newSet.removeAll(this.classNames);
                newSet.removeAll(this.env.getSuperClasses());
                this.env.setAllJavaClasses((Set<String>)newSet);
                this.env.clearClassListForLooping();
                this.generateBindings((Set<String>)newSet, classLoader, this.dependenciesPath);
            }
            this.generateUtilFiles();
            if (this.env.getFailedClassGens() != null) {
                this.handleFailedClassGens();
            }
            if (this.env.getFailedMethodGens() != null) {
                for (String entry : this.env.getFailedMethodGens()) {
                    this.errStream.println(entry);
                }
            }
            try {
                ((URLClassLoader)classLoader).close();
            }
            catch (IOException e) {
                this.outStream.println("\nError while exiting the classloader:\n" + e.getMessage());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private void resolvePlatformLibraries(JvmTarget parentJvmTarget) throws BindgenException {
        if (this.env.getProjectRoot() != null) {
            TomlDocument tomlDocument = this.env.getTomlDocument();
            if (tomlDocument == null) {
                return;
            }
            PackageManifest packageManifest = ManifestBuilder.from((TomlDocument)tomlDocument, null, null, (Path)this.env.getProjectRoot()).packageManifest();
            if (packageManifest == null) {
                return;
            }
            for (JvmTarget jvmTarget : JvmTarget.values()) {
                PackageManifest.Platform platform = packageManifest.platform(jvmTarget.code());
                if (platform == null || platform.dependencies() == null) continue;
                for (Map library : platform.dependencies()) {
                    if (library.get("path") != null) {
                        this.handlePathDependency(library.get("path").toString());
                        continue;
                    }
                    if (library.get("groupId") == null || library.get("artifactId") == null || library.get("version") == null) continue;
                    this.resolveMvnDependency(library.get("groupId").toString(), library.get("artifactId").toString(), library.get("version").toString(), parentJvmTarget);
                }
            }
        }
    }

    private JvmTarget getParentDependencyJvmTarget() {
        JvmTarget jvmTarget = JvmTarget.JAVA_21;
        TomlDocument tomlDocument = this.env.getTomlDocument();
        if (tomlDocument == null) {
            return jvmTarget;
        }
        PackageManifest packageManifest = ManifestBuilder.from((TomlDocument)tomlDocument, null, null, (Path)this.env.getProjectRoot()).packageManifest();
        if (packageManifest == null) {
            return jvmTarget;
        }
        for (JvmTarget target : JvmTarget.values()) {
            PackageManifest.Platform platform = packageManifest.platform(target.code());
            if (platform == null || platform.dependencies() == null) continue;
            for (Map library : platform.dependencies()) {
                if (library.get("groupId") == null || !library.get("groupId").equals(this.mvnGroupId) || library.get("artifactId") == null || !library.get("artifactId").equals(this.mvnArtifactId) || library.get("version") == null || !library.get("version").equals(this.mvnVersion)) continue;
                return target;
            }
        }
        return jvmTarget;
    }

    private void handlePathDependency(String libPath) {
        Path libraryPath = Path.of(libPath, new String[0]).isAbsolute() ? Path.of(libPath, new String[0]) : Path.of(this.env.getProjectRoot().toString(), libPath);
        this.env.addClasspath(libraryPath.toString());
    }

    private void resolveMvnDependency(String mvnGroupId, String mvnArtifactId, String mvnVersion, JvmTarget parentJvmTarget) throws BindgenException {
        new BindgenMvnResolver(this.outStream, this.env).mavenResolver(mvnGroupId, mvnArtifactId, mvnVersion, this.env.getProjectRoot(), false, parentJvmTarget);
    }

    private ClassLoader setClassLoader() throws BindgenException {
        ClassLoader classLoader;
        if (!this.env.getClassPaths().isEmpty()) {
            classLoader = BindgenUtils.getClassLoader(this.env.getClassPaths(), this.getClass().getClassLoader());
        } else {
            this.outStream.println("\nNo classpaths were detected.");
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    private void setDirectoryPaths() throws BindgenException {
        String userPath = this.userDir.toString();
        String outputPath = this.env.getOutputPath();
        if (this.env.getModulesFlag()) {
            userPath = Path.of(userPath, "modules").toString();
        } else if (outputPath != null) {
            if (!Path.of(outputPath, new String[0]).toFile().exists()) {
                throw new BindgenException("error: output path provided could not be found: " + outputPath);
            }
            userPath = outputPath;
        }
        this.dependenciesPath = this.modulePath = Path.of(userPath, new String[0]);
        this.utilsDirPath = this.modulePath;
    }

    private void handleFailedClassGens() {
        this.errStream.print("\n");
        for (Map.Entry<String, String> entry : this.env.getFailedClassGens().entrySet()) {
            if (!this.classNames.contains(entry.getKey())) continue;
            this.errStream.println("error: unable to generate the '" + entry.getKey() + "' binding class: " + entry.getValue());
        }
    }

    private void generateUtilFiles() throws BindgenException {
        String utilsDirStrPath = this.utilsDirPath.toString();
        BindgenUtils.createDirectory(utilsDirStrPath);
        for (JError jError : this.env.getExceptionList()) {
            String fileName = jError.getShortExceptionName() + ".bal";
            if (this.env.getModulesFlag()) {
                utilsDirStrPath = Path.of(this.modulePath.toString(), jError.getPackageName()).toString();
                BindgenUtils.createDirectory(utilsDirStrPath);
            }
            BindgenUtils.outputSyntaxTreeFile(jError, this.env, Path.of(utilsDirStrPath, fileName).toString(), (Boolean)false);
        }
    }

    void setOutputPath(String output) {
        this.env.setOutputPath(output);
    }

    void setDependentJars(String[] jarPaths) {
        for (String path : jarPaths) {
            this.env.addClasspath(path);
        }
    }

    void setClassNames(List<String> classNames) {
        this.classNames = new HashSet<String>(classNames);
    }

    private void generateBindings(Set<String> classList, ClassLoader classLoader, Path modulePath) throws BindgenException {
        BindgenUtils.createDirectory(modulePath.toString());
        for (String c : classList) {
            try {
                Path filePath;
                Class<?> classInstance;
                if (classLoader == null || (classInstance = classLoader.loadClass(c)) == null || !BindgenUtils.isPublicClass(classInstance)) continue;
                JClass jClass = new JClass(classInstance, this.env);
                if (this.env.getModulesFlag()) {
                    String outputFile = Path.of(modulePath.toString(), jClass.getPackageName()).toString();
                    BindgenUtils.createDirectory(outputFile);
                    filePath = Path.of(outputFile, jClass.getShortClassName() + ".bal");
                } else {
                    filePath = Path.of(modulePath.toString(), jClass.getShortClassName() + ".bal");
                }
                if (Files.exists(filePath, new LinkOption[0]) && !this.env.isDirectJavaClass()) continue;
                BindgenUtils.outputSyntaxTreeFile(jClass, this.env, filePath.toString(), (Boolean)false);
                this.outStream.println("\t" + c);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                this.env.setFailedClassGens(c, e.toString());
            }
        }
    }

    void setMvnGroupId(String mvnGroupId) {
        this.mvnGroupId = mvnGroupId;
    }

    void setMvnArtifactId(String mvnArtifactId) {
        this.mvnArtifactId = mvnArtifactId;
    }

    void setMvnVersion(String mvnVersion) {
        this.mvnVersion = mvnVersion;
    }

    void setPublic() {
        this.env.setPublicFlag(true);
    }

    void setModulesFlag(boolean modulesFlag) {
        this.env.setPublicFlag(true);
        this.env.setModulesFlag(modulesFlag);
    }

    void setProject(Project project) {
        this.env.setProject(project);
    }

    public void setOptionalTypesFlag() {
        this.env.setOptionalTypesFlag(true);
    }

    public void setOptionalParamTypesFlag() {
        this.env.setOptionalParamTypesFlag(true);
    }

    public void setOptionalReturnTypesFlag() {
        this.env.setOptionalReturnTypesFlag(true);
    }
}

