/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.utils;

import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.model.JClass;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.utils.BindgenEnv;
import org.ballerinalang.bindgen.utils.BindgenTreeModifier;

public class BindgenFileGenerator {
    private JClass jClass;
    private Class<?> currentClass;
    private SyntaxTree syntaxTree;
    private final BindgenEnv env;
    private final Path classTemplatePath = Path.of("templates", "class.bal");
    private final Path emptyClassTemplatePath = Path.of("templates", "empty_class.bal");
    private final Path errorTemplatePath = Path.of("templates", "error.bal");
    private final Path toStringFunctionTemplatePath = Path.of("templates", "tostring_function.bal");
    private static final CharSequence UNIX_FS = "/";

    public BindgenFileGenerator(BindgenEnv env) {
        this.env = env;
    }

    public SyntaxTree generate(JError jError) throws BindgenException {
        this.currentClass = jError.getCurrentClass();
        return this.generateFromTemplate(this.errorTemplatePath, jError.getShortExceptionName());
    }

    public SyntaxTree generate(JClass jClass) throws BindgenException {
        this.jClass = jClass;
        this.currentClass = jClass.getCurrentClass();
        this.setClassNameAlias();
        if (!this.env.isDirectJavaClass()) {
            return this.generateFromTemplate(this.emptyClassTemplatePath);
        }
        this.syntaxTree = this.generateFromTemplate(this.classTemplatePath);
        return this.generateSyntaxTree();
    }

    private SyntaxTree generateSyntaxTree() throws BindgenException {
        if (this.syntaxTree.containsModulePart()) {
            return new BindgenTreeModifier(this.jClass, this.env).transform((ModulePartNode)this.syntaxTree.rootNode()).syntaxTree();
        }
        throw new BindgenException("error: unable to generate the binding class '" + this.jClass.getCurrentClass().getName() + "'");
    }

    private SyntaxTree generateFromTemplate(Path filePath) throws BindgenException {
        return this.generateFromTemplate(filePath, this.env.getAlias(this.currentClass.getName()));
    }

    private SyntaxTree generateFromTemplate(Path filePath, String alias) throws BindgenException {
        String toStringFunction = this.readTemplateFile(this.toStringFunctionTemplatePath);
        toStringFunction = this.replacePlaceholders(toStringFunction, alias, "");
        toStringFunction = this.applyOptionalTypeModifications(toStringFunction);
        String content = this.readTemplateFile(filePath);
        content = this.replacePlaceholders(content, alias, toStringFunction);
        return SyntaxTree.from((TextDocument)TextDocuments.from((String)content));
    }

    private String replacePlaceholders(String content, String alias, String toStringFunction) {
        return content.replace("FULL_CLASS_NAME", this.currentClass.getName()).replace("CLASS_TYPE", this.currentClass.isInterface() ? "interface" : "class").replace("INS_CLASS_NAME", this.currentClass.getName().replace("$", "\\$")).replace("SIMPLE_CLASS_NAME_CAPS", alias.toUpperCase(Locale.getDefault())).replace("SIMPLE_CLASS_NAME", alias).replace("ACCESS_MODIFIER", this.env.hasPublicFlag() ? "public " : "").replace("TO_STRING_FUNCTION", toStringFunction);
    }

    private String applyOptionalTypeModifications(String toStringFunction) {
        if (this.env.isOptionalTypes() || this.env.isOptionalReturnTypes()) {
            toStringFunction = toStringFunction.replace("returns string", "returns string?").replace("java:toString(self.jObj) ?: \"\"", "java:toString(self.jObj)");
        }
        return toStringFunction;
    }

    private void setClassNameAlias() {
        if (this.env.getAlias(this.currentClass.getName()) != null) {
            return;
        }
        String className = this.currentClass.getName();
        String simpleClassName = this.currentClass.getSimpleName();
        if (this.env.getAliasClassName(simpleClassName) == null && this.env.getAliasClassName(simpleClassName + "1") == null) {
            this.env.setAlias(simpleClassName, className);
        } else {
            int i = 1;
            while (true) {
                String alias = simpleClassName + i;
                if (i == 1 && this.env.getAliasClassName(alias) == null) {
                    String previousClassName = this.env.removeAlias(simpleClassName);
                    this.env.setAlias(alias, previousClassName);
                } else if (this.env.getAliasClassName(alias) == null) {
                    this.env.setAlias(alias, className);
                    break;
                }
                ++i;
            }
        }
    }

    private String readTemplateFile(Path filePath) throws BindgenException {
        try {
            String unixPath = filePath.toString().replace(File.separator, UNIX_FS);
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(unixPath);
            return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new BindgenException("error: unable to read the internal template file: " + e.getMessage(), e);
        }
    }
}

