/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp.nativelistener;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.tcp.Constants;
import io.ballerina.stdlib.tcp.TcpFactory;
import io.ballerina.stdlib.tcp.TcpListener;
import io.ballerina.stdlib.tcp.TcpService;
import io.ballerina.stdlib.tcp.Utils;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Listener {
    private static final Logger log = LoggerFactory.getLogger(Listener.class);

    public static Object externInit(BObject listener, int localPort, BMap<BString, Object> config) {
        listener.addNativeData("listenerConfig", config);
        listener.addNativeData("localPort", (Object)localPort);
        return null;
    }

    public static Object externAttach(Environment env, BObject listener, BObject service, Object serviceName) {
        listener.addNativeData("Service", (Object)new TcpService(env.getRuntime(), service));
        return null;
    }

    public static Object externStart(Environment env, BObject listener) {
        CompletableFuture balFuture = new CompletableFuture();
        return env.yieldAndRun(() -> {
            InetSocketAddress localAddress;
            BMap config = (BMap)listener.getNativeData("listenerConfig");
            BString localHost = config.getStringValue(StringUtils.fromString((String)"localHost"));
            int localPort = (Integer)listener.getNativeData("localPort");
            if (localHost == null) {
                localAddress = new InetSocketAddress(localPort);
            } else {
                String hostname = localHost.getValue();
                localAddress = new InetSocketAddress(hostname, localPort);
            }
            BMap secureSocket = config.getMapValue(Constants.SECURE_SOCKET);
            TcpService tcpService = (TcpService)listener.getNativeData("Service");
            TcpListener tcpListener = TcpFactory.getInstance().createTcpListener(localAddress, balFuture, tcpService, (BMap<BString, Object>)secureSocket);
            listener.addNativeData("listener", (Object)tcpListener);
            return Utils.getResult(balFuture);
        });
    }

    public static Object externDetach(BObject listener) {
        TcpService service = (TcpService)listener.getNativeData("Service");
        if (service == null) {
            log.info("service is not attached to the listener");
            return null;
        }
        listener.addNativeData("Service", null);
        return null;
    }

    public static Object externGracefulStop(Environment env, BObject listener) {
        CompletableFuture balFuture = new CompletableFuture();
        return env.yieldAndRun(() -> {
            TcpListener tcpListener = (TcpListener)listener.getNativeData("listener");
            if (tcpListener != null) {
                tcpListener.close(balFuture);
            } else {
                balFuture.complete(Utils.createTcpError("Unable to initialize the tcp listener."));
            }
            return Utils.getResult(balFuture);
        });
    }

    private Listener() {
    }
}

