/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.cache.nativeimpl;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.cache.nativeimpl.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.Map;

public class Cache {
    private static ConcurrentLinkedHashMap<BString, BMap<BString, Object>> cacheMap;
    private static final String MAX_CAPACITY = "maxCapacity";
    private static final String EVICTION_FACTOR = "evictionFactor";
    private static final String EXPIRE_TIME = "expTime";
    private static final String CACHE = "CACHE";

    private Cache() {
    }

    public static void externInit(BObject cache) {
        int capacity = (int)cache.getIntValue(StringUtils.fromString((String)MAX_CAPACITY));
        cacheMap = new ConcurrentLinkedHashMap(capacity);
        cache.addNativeData(CACHE, cacheMap);
    }

    public static void externPut(BObject cache, BString key, BMap<BString, Object> value) {
        int capacity = (int)cache.getIntValue(StringUtils.fromString((String)MAX_CAPACITY));
        float evictionFactor = (float)cache.getFloatValue(StringUtils.fromString((String)EVICTION_FACTOR));
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        if (cacheMap.size() >= capacity) {
            int evictionKeysCount = (int)Math.ceil((float)capacity * evictionFactor);
            cacheMap.setCapacity(capacity - evictionKeysCount);
            cacheMap.setCapacity(capacity);
        }
        cacheMap.put(key, value);
    }

    public static BMap<BString, Object> externGet(BObject cache, BString key, BDecimal currentTime) {
        Long time;
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        BMap<BString, Object> value = cacheMap.get(key);
        if (value != null && value.get((Object)StringUtils.fromString((String)EXPIRE_TIME)) != null && (time = Long.valueOf(((BDecimal)value.get((Object)StringUtils.fromString((String)EXPIRE_TIME))).decimalValue().longValue())) != -1L && time <= currentTime.decimalValue().longValue()) {
            cacheMap.remove(key);
            return null;
        }
        return value;
    }

    public static void externRemove(BObject cache, BString key) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        cacheMap.remove(key);
    }

    public static void externRemoveAll(BObject cache) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        cacheMap.clear();
    }

    public static boolean externHasKey(BObject cache, BString key) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        return cacheMap.containsKey(key);
    }

    public static BArray externKeys(BObject cache) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        return ValueCreator.createArrayValue((BString[])cacheMap.keySet().toArray(new BString[0]));
    }

    public static int externSize(BObject cache) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        return cacheMap.size();
    }

    public static void externCleanUp(BObject cache, BDecimal currentTime) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        for (Map.Entry<BString, BMap<BString, Object>> entry : cacheMap.entrySet()) {
            BMap<BString, Object> value = entry.getValue();
            Long time = ((BDecimal)value.get((Object)StringUtils.fromString((String)EXPIRE_TIME))).decimalValue().longValue();
            if (time == -1L || time > currentTime.decimalValue().longValue()) continue;
            cacheMap.remove(entry.getKey());
        }
    }
}

