/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import io.ballerina.runtime.transactions.TransactionResourceManager;
import io.ballerina.stdlib.sql.Constants;
import io.ballerina.stdlib.sql.datasource.SQLDatasource;
import io.ballerina.stdlib.sql.exception.ApplicationError;
import io.ballerina.stdlib.sql.parameterprocessor.AbstractResultParameterProcessor;
import io.ballerina.stdlib.sql.parameterprocessor.AbstractStatementParameterProcessor;
import io.ballerina.stdlib.sql.utils.ColumnDefinition;
import io.ballerina.stdlib.sql.utils.ErrorGenerator;
import io.ballerina.stdlib.sql.utils.ModuleUtils;
import io.ballerina.stdlib.sql.utils.Utils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CallProcessor {
    private CallProcessor() {
    }

    public static Object nativeCall(Environment env, BObject client, BObject paramSQLString, BArray recordTypes, AbstractStatementParameterProcessor statementParameterProcessor, AbstractResultParameterProcessor resultParameterProcessor) {
        TransactionResourceManager trxResourceManager = TransactionResourceManager.getInstance();
        boolean withinTrxBlock = Utils.isWithinTrxBlock(trxResourceManager);
        boolean trxManagerEnabled = trxResourceManager.getTransactionManagerEnabled();
        TransactionLocalContext currentTrxContext = trxResourceManager.getCurrentTransactionContext();
        return env.yieldAndRun(() -> CallProcessor.nativeCallExecutable(client, paramSQLString, recordTypes, statementParameterProcessor, resultParameterProcessor, withinTrxBlock, currentTrxContext, trxManagerEnabled));
    }

    private static Object nativeCallExecutable(BObject client, BObject paramSQLString, BArray recordTypes, AbstractStatementParameterProcessor statementParameterProcessor, AbstractResultParameterProcessor resultParameterProcessor, boolean isWithinTrxBlock, TransactionLocalContext currentTrxContext, boolean trxManagerEnabled) {
        Object dbClient = client.getNativeData("Client");
        if (dbClient != null) {
            SQLDatasource sqlDatasource = (SQLDatasource)dbClient;
            if (!((Boolean)client.getNativeData("clientActive")).booleanValue()) {
                return ErrorGenerator.getSQLApplicationError("SQL Client is already closed, hence further operations are not allowed");
            }
            Connection connection = null;
            CallableStatement statement = null;
            ResultSet resultSet = null;
            String sqlQuery = null;
            try {
                sqlQuery = Utils.getSqlQuery(paramSQLString);
                connection = SQLDatasource.getConnection(isWithinTrxBlock, client, sqlDatasource, currentTrxContext, trxManagerEnabled);
                statement = connection.prepareCall(sqlQuery);
                HashMap<Integer, Integer> outputParamTypes = new HashMap<Integer, Integer>();
                CallProcessor.setCallParameters(connection, statement, paramSQLString, outputParamTypes, statementParameterProcessor);
                boolean resultType = statement.execute();
                BObject iteratorObject = resultParameterProcessor.getBalStreamResultIterator();
                BObject procedureCallResult = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"ProcedureCallResult", (Object[])new Object[]{iteratorObject});
                Object[] recordDescriptions = recordTypes.getValues();
                int resultSetCount = 0;
                if (resultType) {
                    List<ColumnDefinition> columnDefinitions;
                    RecordType streamConstraint;
                    resultSet = statement.getResultSet();
                    if (recordTypes.size() == 0) {
                        streamConstraint = Utils.getDefaultStreamConstraint();
                        columnDefinitions = Utils.getColumnDefinitions(resultSet, (StructureType)streamConstraint);
                    } else {
                        streamConstraint = (StructureType)TypeUtils.getReferredType((Type)((BTypedesc)recordDescriptions[0]).getDescribingType());
                        columnDefinitions = Utils.getColumnDefinitions(resultSet, (StructureType)streamConstraint);
                        ++resultSetCount;
                    }
                    BStream streamValue = ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)streamConstraint, (Type)PredefinedTypes.TYPE_NULL), (BObject)resultParameterProcessor.createRecordIterator(resultSet, null, null, columnDefinitions, (StructureType)streamConstraint));
                    procedureCallResult.set(Constants.QUERY_RESULT_FIELD, (Object)streamValue);
                } else {
                    Utils.updateProcedureCallExecutionResult(statement, procedureCallResult);
                }
                CallProcessor.populateOutParametersMetaData(statement, paramSQLString, outputParamTypes, resultParameterProcessor, procedureCallResult);
                procedureCallResult.addNativeData("Statement", (Object)statement);
                procedureCallResult.addNativeData("Connection", (Object)connection);
                procedureCallResult.addNativeData("TypeDescription", (Object)recordDescriptions);
                procedureCallResult.addNativeData("ResultSetTotal", (Object)recordTypes.size());
                procedureCallResult.addNativeData("ResultSetCount", (Object)resultSetCount);
                return procedureCallResult;
            }
            catch (SQLException e) {
                Utils.closeResources(isWithinTrxBlock, resultSet, statement, connection);
                return ErrorGenerator.getSQLDatabaseError(e, String.format("Error while executing SQL query: %s. ", sqlQuery));
            }
            catch (ApplicationError e) {
                Utils.closeResources(isWithinTrxBlock, resultSet, statement, connection);
                return ErrorGenerator.getSQLApplicationError(e);
            }
            catch (Throwable th) {
                Utils.closeResources(isWithinTrxBlock, resultSet, statement, connection);
                return ErrorGenerator.getSQLError(th, String.format("Error while executing SQL query: %s. ", sqlQuery));
            }
        }
        return ErrorGenerator.getSQLApplicationError("Client is not properly initialized!");
    }

    private static void setCallParameters(Connection connection, CallableStatement statement, BObject paramString, HashMap<Integer, Integer> outputParamTypes, AbstractStatementParameterProcessor statementParameterProcessor) throws SQLException, ApplicationError {
        BArray arrayValue = paramString.getArrayValue(Constants.ParameterizedQueryFields.INSERTIONS);
        for (int i = 0; i < arrayValue.size(); ++i) {
            Object object = arrayValue.get((long)i);
            int index = i + 1;
            if (object instanceof BObject) {
                BObject objectValue = (BObject)object;
                String objectType = TypeUtils.getType((Object)objectValue).getName();
                String parameterType = objectType.equals("InOutParameter") ? "InOutParameter" : (objectType.endsWith("OutParameter") ? "OutParameter" : "InParameter");
                switch (parameterType) {
                    case "InOutParameter": {
                        Object innerObject = objectValue.get(Constants.ParameterObject.IN_VALUE_FIELD);
                        int sqlType = statementParameterProcessor.setSQLValueParam(connection, statement, index, innerObject, true);
                        outputParamTypes.put(index, sqlType);
                        statement.registerOutParameter(index, sqlType);
                        break;
                    }
                    case "OutParameter": {
                        int sqlType = CallProcessor.getOutParameterType(objectValue, statementParameterProcessor);
                        outputParamTypes.put(index, sqlType);
                        statement.registerOutParameter(index, sqlType);
                        break;
                    }
                    default: {
                        statementParameterProcessor.setSQLValueParam(connection, statement, index, object, false);
                        break;
                    }
                }
                continue;
            }
            statementParameterProcessor.setSQLValueParam(connection, statement, index, object, false);
        }
    }

    private static void populateOutParametersMetaData(CallableStatement statement, BObject paramSQLString, HashMap<Integer, Integer> outputParamTypes, AbstractResultParameterProcessor resultParameterProcessor, BObject procedureCallResult) throws SQLException, ApplicationError {
        if (outputParamTypes.size() == 0) {
            return;
        }
        BArray arrayValue = paramSQLString.getArrayValue(Constants.ParameterizedQueryFields.INSERTIONS);
        for (Map.Entry<Integer, Integer> entry : outputParamTypes.entrySet()) {
            int paramIndex = entry.getKey();
            int sqlType = entry.getValue();
            BObject parameter = (BObject)arrayValue.get((long)(paramIndex - 1));
            parameter.addNativeData("parameterIndex", (Object)paramIndex);
            parameter.addNativeData("sqlType", (Object)sqlType);
            parameter.addNativeData("ResultParameterProcessor", (Object)resultParameterProcessor);
            parameter.addNativeData("Statement", (Object)statement);
            parameter.addNativeData("ProcedureCallResult", (Object)procedureCallResult);
        }
    }

    private static int getOutParameterType(BObject typedValue, AbstractStatementParameterProcessor statementParameterProcessor) throws ApplicationError, SQLException {
        String sqlType;
        return switch (sqlType = TypeUtils.getType((Object)typedValue).getName()) {
            case "VarcharOutParameter", "TextOutParameter" -> 12;
            case "CharOutParameter" -> 1;
            case "NCharOutParameter" -> -15;
            case "NVarcharOutParameter" -> -9;
            case "BitOutParameter" -> -7;
            case "BooleanOutParameter" -> 16;
            case "IntegerOutParameter" -> 4;
            case "BigIntOutParameter" -> -5;
            case "SmallIntOutParameter" -> 5;
            case "FloatOutParameter" -> 6;
            case "RealOutParameter" -> 7;
            case "DoubleOutParameter" -> 8;
            case "NumericOutParameter" -> 2;
            case "DecimalOutParameter" -> 3;
            case "BinaryOutParameter" -> -2;
            case "VarBinaryOutParameter" -> -3;
            case "BlobOutParameter" -> {
                if (typedValue instanceof BArray) {
                    yield -3;
                }
                yield -4;
            }
            case "ClobOutParameter", "NClobOutParameter" -> {
                if (typedValue instanceof BString) {
                    yield 2005;
                }
                yield -1;
            }
            case "DateOutParameter" -> 91;
            case "TimeOutParameter" -> 92;
            case "TimeWithTimezoneOutParameter" -> 2013;
            case "TimestampOutParameter", "DateTimeOutParameter" -> 93;
            case "TimestampWithTimezoneOutParameter" -> 2014;
            case "ArrayOutParameter", "SmallIntArrayOutParameter", "BigIntArrayOutParameter", "BinaryArrayOutParameter", "BitArrayOutParameter", "BooleanArrayOutParameter", "CharArrayOutParameter", "DateArrayOutParameter", "DateTimeArrayOutParameter", "DecimalArrayOutParameter", "DoubleArrayOutParameter", "FloatArrayOutParameter", "IntegerArrayOutParameter", "NumericArrayOutParameter", "NVarcharArrayOutParameter", "TimeWithTimezoneArrayOutParameter", "TimestampWithTimezoneArrayOutParameter", "TimestampArrayOutParameter", "RealArrayOutParameter", "VarBinaryArrayOutParameter", "VarcharArrayOutParameter", "TimeArrayOutParameter" -> 2003;
            case "RefOutParameter" -> 2006;
            case "CursorOutParameter" -> 2012;
            case "StructOutParameter" -> 2002;
            case "RowOutParameter" -> -8;
            case "XMLOutParameter" -> 2009;
            default -> statementParameterProcessor.getCustomOutParameterType(typedValue);
        };
    }
}

