/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import io.ballerina.runtime.transactions.TransactionResourceManager;
import io.ballerina.stdlib.sql.datasource.SQLDatasource;
import io.ballerina.stdlib.sql.exception.ApplicationError;
import io.ballerina.stdlib.sql.exception.DataError;
import io.ballerina.stdlib.sql.exception.TypeMismatchError;
import io.ballerina.stdlib.sql.parameterprocessor.AbstractResultParameterProcessor;
import io.ballerina.stdlib.sql.parameterprocessor.AbstractStatementParameterProcessor;
import io.ballerina.stdlib.sql.utils.ColumnDefinition;
import io.ballerina.stdlib.sql.utils.ErrorGenerator;
import io.ballerina.stdlib.sql.utils.PrimitiveTypeColumnDefinition;
import io.ballerina.stdlib.sql.utils.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class QueryProcessor {
    private QueryProcessor() {
    }

    public static BStream nativeQuery(Environment env, BObject client, BObject paramSQLString, Object recordType, AbstractStatementParameterProcessor statementParameterProcessor, AbstractResultParameterProcessor resultParameterProcessor) {
        TransactionResourceManager trxResourceManager = TransactionResourceManager.getInstance();
        boolean withinTrxBlock = Utils.isWithinTrxBlock(trxResourceManager);
        boolean trxManagerEnabled = trxResourceManager.getTransactionManagerEnabled();
        TransactionLocalContext currentTrxContext = trxResourceManager.getCurrentTransactionContext();
        return (BStream)env.yieldAndRun(() -> QueryProcessor.nativeQueryExecutable(client, paramSQLString, recordType, statementParameterProcessor, resultParameterProcessor, withinTrxBlock, currentTrxContext, trxManagerEnabled));
    }

    private static BStream nativeQueryExecutable(BObject client, BObject paramSQLString, Object recordType, AbstractStatementParameterProcessor statementParameterProcessor, AbstractResultParameterProcessor resultParameterProcessor, boolean isWithInTrxBlock, TransactionLocalContext currentTrxContext, boolean trxManagerEnabled) {
        Object dbClient = client.getNativeData("Client");
        if (dbClient != null) {
            SQLDatasource sqlDatasource = (SQLDatasource)dbClient;
            if (!((Boolean)client.getNativeData("clientActive")).booleanValue()) {
                BError errorValue = ErrorGenerator.getSQLApplicationError("SQL Client is already closed, hence further operations are not allowed");
                return Utils.getErrorStream(recordType, errorValue);
            }
            Connection connection = null;
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            String sqlQuery = null;
            try {
                sqlQuery = Utils.getSqlQuery(paramSQLString);
                connection = SQLDatasource.getConnection(isWithInTrxBlock, client, sqlDatasource, currentTrxContext, trxManagerEnabled);
                statement = connection.prepareStatement(sqlQuery);
                statementParameterProcessor.setParams(connection, statement, paramSQLString);
                resultSet = statement.executeQuery();
                RecordType streamConstraint = (RecordType)TypeUtils.getReferredType((Type)((BTypedesc)recordType).getDescribingType());
                List<ColumnDefinition> columnDefinitions = Utils.getColumnDefinitions(resultSet, (StructureType)streamConstraint);
                return ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)streamConstraint, (Type)PredefinedTypes.TYPE_NULL), (BObject)resultParameterProcessor.createRecordIterator(resultSet, statement, connection, columnDefinitions, (StructureType)streamConstraint));
            }
            catch (SQLException e) {
                Utils.closeResources(isWithInTrxBlock, resultSet, statement, connection);
                BError errorValue = ErrorGenerator.getSQLDatabaseError(e, String.format("Error while executing SQL query: %s. ", sqlQuery));
                return Utils.getErrorStream(recordType, errorValue);
            }
            catch (ApplicationError applicationError) {
                Utils.closeResources(isWithInTrxBlock, resultSet, statement, connection);
                BError errorValue = ErrorGenerator.getSQLApplicationError(applicationError);
                return Utils.getErrorStream(recordType, errorValue);
            }
            catch (Throwable e) {
                Utils.closeResources(isWithInTrxBlock, resultSet, statement, connection);
                String message = e.getMessage();
                if (message == null) {
                    message = e.getClass().getName();
                }
                BError errorValue = ErrorGenerator.getSQLApplicationError(String.format("Error while executing SQL query: %s. %s", sqlQuery, message));
                return Utils.getErrorStream(recordType, errorValue);
            }
        }
        BError errorValue = ErrorGenerator.getSQLApplicationError("Client is not properly initialized!");
        return Utils.getErrorStream(recordType, errorValue);
    }

    public static Object nativeQueryRow(Environment env, BObject client, BObject paramSQLString, BTypedesc bTypedesc, AbstractStatementParameterProcessor statementParameterProcessor, AbstractResultParameterProcessor resultParameterProcessor) {
        TransactionResourceManager trxResourceManager = TransactionResourceManager.getInstance();
        boolean withinTrxBlock = Utils.isWithinTrxBlock(trxResourceManager);
        boolean trxManagerEnabled = trxResourceManager.getTransactionManagerEnabled();
        TransactionLocalContext currentTrxContext = trxResourceManager.getCurrentTransactionContext();
        return env.yieldAndRun(() -> QueryProcessor.nativeQueryRowExecutable(client, paramSQLString, bTypedesc, statementParameterProcessor, resultParameterProcessor, withinTrxBlock, currentTrxContext, trxManagerEnabled));
    }

    /*
     * Exception decompiling
     */
    private static Object nativeQueryRowExecutable(BObject client, BObject paramSQLString, BTypedesc ballerinaType, AbstractStatementParameterProcessor statementParameterProcessor, AbstractResultParameterProcessor resultParameterProcessor, boolean isWithInTrxBlock, TransactionLocalContext currentTrxContext, boolean trxManagerEnabled) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object getUnionTypeBValue(UnionType describingType, ResultSet resultSet, AbstractResultParameterProcessor resultParameterProcessor) throws SQLException, TypeMismatchError {
        for (Type type : describingType.getMemberTypes()) {
            try {
                Type referredType = TypeUtils.getReferredType((Type)type);
                if (referredType.getTag() == 33) {
                    return QueryProcessor.getUnionTypeBValue(describingType, resultSet, resultParameterProcessor);
                }
                return QueryProcessor.getRecordOrPrimitiveTypeBValue(referredType, resultSet, resultParameterProcessor);
            }
            catch (ApplicationError applicationError) {
            }
        }
        throw new TypeMismatchError(String.format("The result generated from the query cannot be mapped to type %s.", describingType));
    }

    private static Object getRecordOrPrimitiveTypeBValue(Type type, ResultSet resultSet, AbstractResultParameterProcessor resultParameterProcessor) throws SQLException, ApplicationError {
        if (type.getTag() == 24 && !Utils.isSupportedRecordType(type)) {
            RecordType recordConstraint = (RecordType)type;
            List<ColumnDefinition> columnDefinitions = Utils.getColumnDefinitions(resultSet, (StructureType)recordConstraint);
            return QueryProcessor.createRecord(resultSet, columnDefinitions, recordConstraint, resultParameterProcessor);
        }
        if (resultSet.getMetaData().getColumnCount() > 1) {
            throw new TypeMismatchError(String.format("Expected type to be '%s' but found 'record{}'.", type));
        }
        PrimitiveTypeColumnDefinition definition = Utils.getColumnDefinition(resultSet, 1, type);
        return QueryProcessor.createValue(resultSet, 1, definition, resultParameterProcessor);
    }

    public static BMap<BString, Object> createRecord(ResultSet resultSet, List<ColumnDefinition> columnDefinitions, RecordType recordConstraint, AbstractResultParameterProcessor resultParameterProcessor) throws SQLException, DataError {
        return Utils.createBallerinaRecord(recordConstraint, resultParameterProcessor, resultSet, columnDefinitions);
    }

    public static Object createValue(ResultSet resultSet, int columnIndex, PrimitiveTypeColumnDefinition columnDefinition, AbstractResultParameterProcessor resultParameterProcessor) throws SQLException, DataError {
        return Utils.getResult(resultSet, columnIndex, columnDefinition, resultParameterProcessor);
    }
}

