/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.parameterprocessor;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.sql.exception.ConversionError;
import io.ballerina.stdlib.sql.exception.DataError;
import io.ballerina.stdlib.sql.utils.ColumnDefinition;
import io.ballerina.stdlib.sql.utils.ModuleUtils;
import io.ballerina.stdlib.sql.utils.PrimitiveTypeColumnDefinition;
import io.ballerina.stdlib.sql.utils.Utils;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;

public abstract class AbstractResultParameterProcessor {
    protected abstract BArray createAndPopulateCustomValueArray(Object var1, Type var2, Array var3) throws DataError, SQLException;

    protected abstract BArray createAndPopulateCustomBBRefValueArray(Object var1, Type var2, Array var3) throws DataError, SQLException;

    protected abstract void createUserDefinedTypeSubtype(Field var1, StructureType var2) throws DataError, SQLException;

    public abstract BArray convertArray(Array var1, int var2, Type var3) throws DataError, SQLException;

    public abstract BString convertChar(String var1, int var2, Type var3) throws DataError, SQLException;

    protected abstract Object convertChar(String var1, int var2, Type var3, String var4) throws DataError, SQLException;

    public abstract Object convertByteArray(byte[] var1, int var2, Type var3, String var4) throws DataError, SQLException;

    public abstract Object convertInteger(long var1, int var3, Type var4, boolean var5) throws DataError, SQLException;

    public abstract Object convertDouble(double var1, int var3, Type var4, boolean var5) throws DataError, SQLException;

    public abstract Object convertDecimal(BigDecimal var1, int var2, Type var3, boolean var4) throws DataError, SQLException;

    public abstract Object convertBlob(Blob var1, int var2, Type var3) throws DataError, SQLException;

    public abstract Object convertDate(java.util.Date var1, int var2, Type var3) throws DataError, SQLException;

    public abstract Object convertTime(java.util.Date var1, int var2, Type var3) throws DataError, SQLException;

    public abstract Object convertTimeWithTimezone(OffsetTime var1, int var2, Type var3) throws DataError, SQLException;

    public abstract Object convertTimeStamp(java.util.Date var1, int var2, Type var3) throws DataError, SQLException;

    public abstract Object convertTimestampWithTimezone(OffsetDateTime var1, int var2, Type var3) throws DataError, SQLException;

    public abstract Object convertBoolean(boolean var1, int var2, Type var3, boolean var4) throws DataError, SQLException;

    public abstract Object convertBinary(Object var1, int var2, Type var3) throws DataError, SQLException;

    public abstract Object convertStruct(Struct var1, int var2, Type var3) throws DataError, SQLException;

    public abstract BStream convertCursorValue(ResultSet var1, RecordType var2);

    public abstract Object convertXml(SQLXML var1, int var2, Type var3) throws DataError, SQLException;

    public abstract Object convertCustomOutParameter(Object var1, String var2, int var3, Type var4) throws DataError, SQLException;

    public abstract Object convertCustomInOutParameter(Object var1, Object var2, int var3, Type var4) throws DataError, SQLException;

    public abstract Object processChar(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processVarchar(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processLongVarchar(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processNChar(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processNVarchar(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processLongNVarchar(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processBinary(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processVarBinary(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processLongVarBinary(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processBlob(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processClob(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processNClob(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processDate(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processTime(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processTimeWithTimeZone(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processTimestamp(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processTimestampWithTimeZone(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processArray(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processRowID(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processTinyInt(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processSmallInt(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processInteger(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processBigInt(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processReal(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processFloat(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processDouble(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processNumeric(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processDecimal(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processBit(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processBoolean(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processRef(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processStruct(CallableStatement var1, int var2) throws SQLException;

    public abstract Object processXML(CallableStatement var1, int var2) throws DataError, SQLException;

    public abstract Object processCustomOutParameters(CallableStatement var1, int var2, int var3) throws DataError, SQLException;

    public abstract Object processCustomTypeFromResultSet(ResultSet var1, int var2, PrimitiveTypeColumnDefinition var3) throws DataError, SQLException;

    public Object processArrayResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        Array array = resultSet.getArray(columnIndex);
        return this.convertArray(array, sqlType, ballerinaType);
    }

    public Object processCharResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        String string = resultSet.getString(columnIndex);
        return this.convertChar(string, sqlType, ballerinaType);
    }

    public Object processCharResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType, String sqlTypeName) throws DataError, SQLException {
        String string = resultSet.getString(columnIndex);
        return this.convertChar(string, sqlType, ballerinaType, sqlTypeName);
    }

    public Object processByteArrayResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType, String sqlTypeName) throws DataError, SQLException {
        byte[] bytes = resultSet.getBytes(columnIndex);
        return this.convertByteArray(bytes, sqlType, ballerinaType, sqlTypeName);
    }

    public Object processBlobResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        Blob blob = resultSet.getBlob(columnIndex);
        return this.convertBlob(blob, sqlType, ballerinaType);
    }

    public Object processClobResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        String clobValue = Utils.getString(resultSet.getClob(columnIndex), columnIndex);
        return this.convertChar(clobValue, sqlType, ballerinaType);
    }

    public Object processNClobResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        String nClobValue = Utils.getString(resultSet.getNClob(columnIndex), columnIndex);
        return this.convertChar(nClobValue, sqlType, ballerinaType);
    }

    public Object processDateResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        Date date = resultSet.getDate(columnIndex);
        return this.convertDate(date, sqlType, ballerinaType);
    }

    public Object processTimeResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        Time time = resultSet.getTime(columnIndex);
        return this.convertTime(time, sqlType, ballerinaType);
    }

    public Object processTimeWithTimezoneResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        OffsetTime offsetTime = resultSet.getObject(columnIndex, OffsetTime.class);
        return this.convertTimeWithTimezone(offsetTime, sqlType, ballerinaType);
    }

    public Object processTimestampResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        Timestamp timestamp = resultSet.getTimestamp(columnIndex);
        return this.convertTimeStamp(timestamp, sqlType, ballerinaType);
    }

    public Object processTimestampWithTimezoneResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        OffsetDateTime offsetDateTime = resultSet.getObject(columnIndex, OffsetDateTime.class);
        return this.convertTimestampWithTimezone(offsetDateTime, sqlType, ballerinaType);
    }

    public Object processRowIdResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType, String sqlTypeName) throws DataError, SQLException {
        RowId rowId = resultSet.getRowId(columnIndex);
        return this.convertByteArray(rowId.getBytes(), sqlType, ballerinaType, sqlTypeName);
    }

    public Object processIntResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        long iValue = resultSet.getInt(columnIndex);
        return this.convertInteger(iValue, sqlType, ballerinaType, resultSet.wasNull());
    }

    public Object processLongResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        long iValue = resultSet.getLong(columnIndex);
        return this.convertInteger(iValue, sqlType, ballerinaType, resultSet.wasNull());
    }

    public Object processFloatResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        double fValue = resultSet.getFloat(columnIndex);
        return this.convertDouble(fValue, sqlType, ballerinaType, resultSet.wasNull());
    }

    public Object processDoubleResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        double dValue = resultSet.getDouble(columnIndex);
        return this.convertDouble(dValue, sqlType, ballerinaType, resultSet.wasNull());
    }

    public Object processDecimalResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        BigDecimal decimalValue = resultSet.getBigDecimal(columnIndex);
        return this.convertDecimal(decimalValue, sqlType, ballerinaType, resultSet.wasNull());
    }

    public Object processBooleanResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        boolean boolValue = resultSet.getBoolean(columnIndex);
        return this.convertBoolean(boolValue, sqlType, ballerinaType, resultSet.wasNull());
    }

    public Object processStructResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        Struct structData = (Struct)resultSet.getObject(columnIndex);
        return this.convertStruct(structData, sqlType, ballerinaType);
    }

    public Object processXmlResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        SQLXML sqlxml = resultSet.getSQLXML(columnIndex);
        return this.convertXml(sqlxml, sqlType, ballerinaType);
    }

    public Object processJsonResult(ResultSet resultSet, int columnIndex, int sqlType, Type ballerinaType) throws DataError, SQLException {
        String jsonString = this.convertChar(resultSet.getString(columnIndex), sqlType, ballerinaType).getValue();
        StringReader reader = new StringReader(jsonString);
        try {
            return JsonUtils.parse((Reader)reader, (JsonUtils.NonStringValueProcessingMode)JsonUtils.NonStringValueProcessingMode.FROM_JSON_STRING);
        }
        catch (BError e) {
            throw new ConversionError(columnIndex, jsonString, "JSON", e.getMessage());
        }
    }

    public Object convertArrayOutParameter(String objectTypeName, Object[] dataArray, Type ballerinaType) throws DataError, SQLException {
        switch (objectTypeName) {
            case "CharArrayOutParameter": 
            case "VarcharArrayOutParameter": 
            case "NVarcharArrayOutParameter": {
                return Utils.toStringArray(dataArray, objectTypeName, ballerinaType);
            }
            case "BitArrayOutParameter": {
                return Utils.toBitArray(dataArray, objectTypeName, ballerinaType);
            }
            case "BooleanArrayOutParameter": {
                return Utils.toBooleanArray(dataArray, objectTypeName, ballerinaType);
            }
            case "IntegerArrayOutParameter": 
            case "SmallIntArrayOutParameter": 
            case "BigIntArrayOutParameter": {
                return Utils.toIntArray(dataArray, objectTypeName, ballerinaType);
            }
            case "RealArrayOutParameter": 
            case "DoubleArrayOutParameter": {
                return Utils.toRealArray(dataArray, objectTypeName, ballerinaType);
            }
            case "DateArrayOutParameter": {
                return Utils.toDateArray(dataArray, objectTypeName, ballerinaType);
            }
            case "TimeArrayOutParameter": {
                return Utils.toTimeArray(dataArray, objectTypeName, ballerinaType);
            }
            case "TimeWithTimezoneArrayOutParameter": {
                return Utils.toTimeWithTimezoneArray(dataArray, objectTypeName, ballerinaType);
            }
            case "DateTimeArrayOutParameter": {
                return Utils.toDateTimeArray(dataArray, objectTypeName, ballerinaType);
            }
            case "TimestampWithTimezoneArrayOutParameter": {
                return Utils.toTimestampWithTimezoneArray(dataArray, objectTypeName, ballerinaType);
            }
            case "FloatArrayOutParameter": {
                return Utils.toFloatArray(dataArray, objectTypeName, ballerinaType);
            }
            case "DecimalArrayOutParameter": 
            case "NumericArrayOutParameter": {
                return Utils.toNumericArray(dataArray, objectTypeName, ballerinaType);
            }
            case "TimestampArrayOutParameter": {
                return Utils.toTimestampArray(dataArray, objectTypeName, ballerinaType);
            }
            case "VarBinaryArrayOutParameter": 
            case "BinaryArrayOutParameter": {
                return Utils.toBinaryArray(dataArray, objectTypeName, ballerinaType);
            }
        }
        return this.processCustomArrayOutParameter(dataArray, ballerinaType);
    }

    public Object convertArrayInOutParameter(Object[] dataArray, Type ballerinaType) throws DataError, SQLException {
        String name = ballerinaType.toString();
        String className = dataArray[0].getClass().getCanonicalName();
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("byte[][]") && className.equalsIgnoreCase("byte[]")) {
            return Utils.createByteArray(dataArray);
        }
        if (name.equalsIgnoreCase("boolean[]")) {
            if (className.equalsIgnoreCase("java.lang.Integer")) {
                return Utils.booleanToIntArray(dataArray);
            }
            return Utils.createBooleanArray(dataArray);
        }
        if (name.equalsIgnoreCase("int[]")) {
            if (className.equalsIgnoreCase("java.lang.Long")) {
                return Utils.createLongArray(dataArray);
            }
            if (className.equalsIgnoreCase("java.math.BigDecimal")) {
                return Utils.decimalToIntArray(dataArray);
            }
            return Utils.createIntegerArray(dataArray);
        }
        if (name.equalsIgnoreCase("float[]")) {
            if (className.equalsIgnoreCase("java.math.BigDecimal")) {
                return Utils.floatToFloatArray(dataArray);
            }
            if (className.equalsIgnoreCase("java.lang.Double")) {
                return Utils.createDoubleArray(dataArray);
            }
            return Utils.createFloatArray(dataArray);
        }
        if (name.equalsIgnoreCase("decimal[]")) {
            if (className.equalsIgnoreCase("java.math.BigDecimal")) {
                return Utils.createBigDecimalArray(dataArray);
            }
            return Utils.createDoubleArray(dataArray);
        }
        if (name.equalsIgnoreCase("time:Civil[]")) {
            return Utils.createTimestampArray(dataArray);
        }
        if (name.equalsIgnoreCase("time:Utc[]")) {
            return Utils.createTimestampArray(dataArray);
        }
        if (name.equalsIgnoreCase("time:TimeOfDay[]")) {
            return Utils.createTimeArray(dataArray);
        }
        if (name.equalsIgnoreCase("time:Date[]")) {
            return Utils.createDateArray(dataArray);
        }
        return this.processCustomArrayInOutParameter(dataArray, ballerinaType);
    }

    public abstract Object processCustomArrayInOutParameter(Object[] var1, Type var2) throws DataError, SQLException;

    public abstract Object processCustomArrayOutParameter(Object[] var1, Type var2) throws DataError, SQLException;

    public BObject createRecordIterator(ResultSet resultSet, Statement statement, Connection connection, List<ColumnDefinition> columnDefinitions, StructureType streamConstraint) {
        BObject resultIterator = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"ResultIterator", (Object[])new Object[]{null, this.getBalStreamResultIterator()});
        resultIterator.addNativeData("ResultSet", (Object)resultSet);
        resultIterator.addNativeData("Statement", (Object)statement);
        resultIterator.addNativeData("Connection", (Object)connection);
        resultIterator.addNativeData("ColumnDefinition", columnDefinitions);
        resultIterator.addNativeData("recordType", (Object)streamConstraint);
        return resultIterator;
    }

    public abstract BObject getBalStreamResultIterator();
}

