/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.parameterprocessor;

import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.stdlib.sql.Constants;
import io.ballerina.stdlib.sql.exception.DataError;
import io.ballerina.stdlib.sql.exception.UnsupportedTypeError;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class AbstractStatementParameterProcessor {
    public abstract int getCustomOutParameterType(BObject var1) throws DataError, SQLException;

    protected abstract int getCustomSQLType(BObject var1) throws DataError, SQLException;

    protected abstract void setCustomSqlTypedParam(Connection var1, PreparedStatement var2, int var3, BObject var4) throws DataError, SQLException;

    protected abstract void setVarchar(PreparedStatement var1, int var2, Object var3) throws DataError, SQLException;

    protected abstract void setVarcharArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setText(PreparedStatement var1, int var2, Object var3) throws DataError, SQLException;

    protected abstract void setChar(PreparedStatement var1, int var2, Object var3) throws DataError, SQLException;

    protected abstract void setCharArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setNChar(PreparedStatement var1, int var2, Object var3) throws DataError, SQLException;

    protected abstract void setNVarchar(PreparedStatement var1, int var2, Object var3) throws DataError, SQLException;

    protected abstract void setNVarcharArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setBit(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setBitArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setBoolean(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setBooleanArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setInteger(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setIntegerArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setBigInt(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setBigIntArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setSmallInt(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setSmallIntArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setFloat(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setFloatArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setReal(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setRealArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setDouble(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setDoubleArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setNumeric(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setNumericArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setDecimal(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setDecimalArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setBinary(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setBinaryArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setVarBinary(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setVarBinaryArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setBlob(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setClob(Connection var1, PreparedStatement var2, String var3, int var4, Object var5) throws DataError, SQLException;

    protected abstract void setNClob(Connection var1, PreparedStatement var2, String var3, int var4, Object var5) throws DataError, SQLException;

    protected abstract void setRow(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setStruct(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setRef(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setDateTime(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setDateTimeArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setTimestamp(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setTimestampArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setDate(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setDateArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setTime(PreparedStatement var1, String var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setTimeArray(Connection var1, PreparedStatement var2, int var3, Object var4) throws DataError, SQLException;

    protected abstract void setXml(Connection var1, PreparedStatement var2, int var3, BXml var4) throws DataError, SQLException;

    protected abstract int setCustomBOpenRecord(Connection var1, PreparedStatement var2, int var3, Object var4, boolean var5) throws DataError, SQLException;

    public void setParams(Connection connection, PreparedStatement preparedStatement, BObject paramString) throws DataError, SQLException {
        BArray arrayValue = paramString.getArrayValue(Constants.ParameterizedQueryFields.INSERTIONS);
        for (int i = 0; i < arrayValue.size(); ++i) {
            Object object = arrayValue.get((long)i);
            int index = i + 1;
            this.setSQLValueParam(connection, preparedStatement, index, object, false);
        }
    }

    public int setSQLValueParam(Connection connection, PreparedStatement preparedStatement, int index, Object object, boolean returnType) throws DataError, SQLException {
        try {
            if (object == null) {
                preparedStatement.setNull(index, 0);
                return 0;
            }
            if (object instanceof BString) {
                preparedStatement.setString(index, object.toString());
                return 12;
            }
            if (object instanceof Long) {
                preparedStatement.setLong(index, (Long)object);
                return -5;
            }
            if (object instanceof Double) {
                preparedStatement.setDouble(index, (Double)object);
                return 8;
            }
            if (object instanceof BDecimal) {
                preparedStatement.setBigDecimal(index, ((BDecimal)object).decimalValue());
                return 2;
            }
            if (object instanceof Boolean) {
                preparedStatement.setBoolean(index, (Boolean)object);
                return 16;
            }
            if (object instanceof BArray) {
                BArray objectArray = (BArray)object;
                if (objectArray.getType().toString().equals("[int,decimal] & readonly")) {
                    this.setTimestamp(preparedStatement, objectArray.getType().getName(), index, objectArray);
                    return 93;
                }
                String type = objectArray.getElementType().toString();
                if (objectArray.getElementType().getTag() == 2) {
                    preparedStatement.setBytes(index, objectArray.getBytes());
                } else if (objectArray.getElementType().getTag() == 32 || type.equals("byte[]?") || type.equals("byte[]")) {
                    this.setBinaryArray(connection, preparedStatement, index, objectArray);
                } else if (type.equals("string") || type.equals("string?")) {
                    this.setVarcharArray(connection, preparedStatement, index, objectArray);
                } else if (type.equals("int") || type.equals("int?")) {
                    this.setIntegerArray(connection, preparedStatement, index, objectArray);
                } else if (type.equals("boolean") || type.equals("boolean?")) {
                    this.setBooleanArray(connection, preparedStatement, index, objectArray);
                } else if (type.equals("float") || type.equals("float?")) {
                    this.setFloatArray(connection, preparedStatement, index, objectArray);
                } else if (type.equals("decimal") || type.equals("decimal?")) {
                    this.setDecimalArray(connection, preparedStatement, index, objectArray);
                } else {
                    throw new UnsupportedTypeError(type + "array type", index);
                }
                return 2003;
            }
            if (object instanceof BObject) {
                BObject objectValue = (BObject)object;
                this.setSqlTypedParam(connection, preparedStatement, index, objectValue);
                if (returnType) {
                    return this.getSQLType(objectValue);
                }
                return 0;
            }
            if (object instanceof BXml) {
                this.setXml(connection, preparedStatement, index, (BXml)object);
                return 2009;
            }
            if (object instanceof BMap) {
                return this.setBMapParams(connection, preparedStatement, index, (BMap)object, returnType);
            }
            throw new UnsupportedTypeError(object.getClass().getName(), index);
        }
        catch (SQLException e) {
            String msg = e.getMessage();
            if (msg != null) {
                if (msg.contains("data exception") || msg.contains("incompatible data type")) {
                    throw new DataError(String.format("Error while constructing SQL query. %s: %s", e.getMessage(), object));
                }
                throw e;
            }
            throw e;
        }
    }

    private void setSqlTypedParam(Connection connection, PreparedStatement preparedStatement, int index, BObject typedValue) throws DataError, SQLException {
        String sqlType = TypeUtils.getType((Object)typedValue).getName();
        Object value = typedValue.get(Constants.TypedValueFields.VALUE);
        switch (sqlType) {
            case "VarcharValue": {
                this.setVarchar(preparedStatement, index, value);
                break;
            }
            case "VarcharArrayValue": {
                this.setVarcharArray(connection, preparedStatement, index, value);
                break;
            }
            case "CharValue": {
                this.setChar(preparedStatement, index, value);
                break;
            }
            case "CharArrayValue": {
                this.setCharArray(connection, preparedStatement, index, value);
                break;
            }
            case "TextValue": {
                this.setText(preparedStatement, index, value);
                break;
            }
            case "NCharValue": {
                this.setNChar(preparedStatement, index, value);
                break;
            }
            case "NVarcharArrayValue": {
                this.setNVarcharArray(connection, preparedStatement, index, value);
                break;
            }
            case "NVarcharValue": {
                this.setNVarchar(preparedStatement, index, value);
                break;
            }
            case "BitValue": {
                this.setBit(preparedStatement, sqlType, index, value);
                break;
            }
            case "BitArrayValue": {
                this.setBitArray(connection, preparedStatement, index, value);
                break;
            }
            case "BooleanValue": {
                this.setBoolean(preparedStatement, sqlType, index, value);
                break;
            }
            case "BooleanArrayValue": {
                this.setBooleanArray(connection, preparedStatement, index, value);
                break;
            }
            case "IntegerValue": {
                this.setInteger(preparedStatement, sqlType, index, value);
                break;
            }
            case "IntegerArrayValue": {
                this.setIntegerArray(connection, preparedStatement, index, value);
                break;
            }
            case "BigIntValue": {
                this.setBigInt(preparedStatement, sqlType, index, value);
                break;
            }
            case "BigIntArrayValue": {
                this.setBigIntArray(connection, preparedStatement, index, value);
                break;
            }
            case "SmallIntValue": {
                this.setSmallInt(preparedStatement, sqlType, index, value);
                break;
            }
            case "SmallIntArrayValue": {
                this.setSmallIntArray(connection, preparedStatement, index, value);
                break;
            }
            case "FloatValue": {
                this.setFloat(preparedStatement, sqlType, index, value);
                break;
            }
            case "FloatArrayValue": {
                this.setFloatArray(connection, preparedStatement, index, value);
                break;
            }
            case "RealValue": {
                this.setReal(preparedStatement, sqlType, index, value);
                break;
            }
            case "RealArrayValue": {
                this.setRealArray(connection, preparedStatement, index, value);
                break;
            }
            case "DoubleValue": {
                this.setDouble(preparedStatement, sqlType, index, value);
                break;
            }
            case "DoubleArrayValue": {
                this.setDoubleArray(connection, preparedStatement, index, value);
                break;
            }
            case "NumericValue": {
                this.setNumeric(preparedStatement, sqlType, index, value);
                break;
            }
            case "NumericArrayValue": {
                this.setNumericArray(connection, preparedStatement, index, value);
                break;
            }
            case "DecimalValue": {
                this.setDecimal(preparedStatement, sqlType, index, value);
                break;
            }
            case "DecimalArrayValue": {
                this.setDecimalArray(connection, preparedStatement, index, value);
                break;
            }
            case "BinaryValue": {
                this.setBinary(preparedStatement, sqlType, index, value);
                break;
            }
            case "BinaryArrayValue": {
                this.setBinaryArray(connection, preparedStatement, index, value);
                break;
            }
            case "VarBinaryValue": {
                this.setVarBinary(preparedStatement, sqlType, index, value);
                break;
            }
            case "VarBinaryArrayValue": {
                this.setVarBinaryArray(connection, preparedStatement, index, value);
                break;
            }
            case "BlobValue": {
                this.setBlob(preparedStatement, sqlType, index, value);
                break;
            }
            case "ClobValue": {
                this.setClob(connection, preparedStatement, sqlType, index, value);
                break;
            }
            case "NClobValue": {
                this.setNClob(connection, preparedStatement, sqlType, index, value);
                break;
            }
            case "DateValue": {
                this.setDate(preparedStatement, sqlType, index, value);
                break;
            }
            case "DateArrayValue": {
                this.setDateArray(connection, preparedStatement, index, value);
                break;
            }
            case "TimeValue": {
                this.setTime(preparedStatement, sqlType, index, value);
                break;
            }
            case "TimeArrayValue": {
                this.setTimeArray(connection, preparedStatement, index, value);
                break;
            }
            case "TimestampValue": {
                this.setTimestamp(preparedStatement, sqlType, index, value);
                break;
            }
            case "TimestampArrayValue": {
                this.setTimestampArray(connection, preparedStatement, index, value);
                break;
            }
            case "DateTimeValue": {
                this.setDateTime(preparedStatement, sqlType, index, value);
                break;
            }
            case "DateTimeArrayValue": {
                this.setDateTimeArray(connection, preparedStatement, index, value);
                break;
            }
            case "ArrayValue": {
                this.setArray(connection, preparedStatement, index, value);
                break;
            }
            case "RefValue": {
                this.setRef(connection, preparedStatement, index, value);
                break;
            }
            case "StructValue": {
                this.setStruct(connection, preparedStatement, index, value);
                break;
            }
            case "RowValue": {
                this.setRow(preparedStatement, sqlType, index, value);
                break;
            }
            default: {
                this.setCustomSqlTypedParam(connection, preparedStatement, index, typedValue);
            }
        }
    }

    private int getSQLType(BObject typedValue) throws DataError, SQLException {
        String sqlType;
        return switch (sqlType = TypeUtils.getType((Object)typedValue).getName()) {
            case "VarcharValue", "TextValue" -> 12;
            case "CharValue" -> 1;
            case "NCharValue" -> -15;
            case "NVarcharValue" -> -9;
            case "BitValue" -> -7;
            case "BooleanValue" -> 16;
            case "IntegerValue" -> 4;
            case "BigIntValue" -> -5;
            case "SmallIntValue" -> 5;
            case "FloatValue" -> 6;
            case "RealValue" -> 7;
            case "DoubleValue" -> 8;
            case "NumericValue" -> 2;
            case "DecimalValue" -> 3;
            case "BinaryValue" -> -2;
            case "VarBinaryValue" -> -3;
            case "BlobValue" -> {
                if (typedValue instanceof BArray) {
                    yield -3;
                }
                yield -4;
            }
            case "ClobValue", "NClobValue" -> {
                if (typedValue instanceof BString) {
                    yield 2005;
                }
                yield -1;
            }
            case "DateValue" -> 91;
            case "TimeValue" -> 92;
            case "TimestampValue", "DateTimeValue" -> 93;
            case "ArrayValue", "SmallIntArrayValue", "IntegerArrayValue", "RealArrayValue", "BigIntArrayValue", "DoubleArrayValue", "FloatArrayValue", "BinaryArrayValue", "BooleanArrayValue", "DecimalArrayValue", "NumericArrayValue", "NVarcharArrayValue", "VarBinaryArrayValue", "VarcharArrayValue", "DateArrayValue", "DateTimeArrayValue", "TimeArrayValue", "TimestampArrayValue", "byte[]", "CharArrayValue", "time:TimeOfDay", "time:Civil", "BitArrayValue" -> 2003;
            case "RefValue" -> 2006;
            case "StructValue" -> 2002;
            case "RowValue" -> -8;
            default -> this.getCustomSQLType(typedValue);
        };
    }

    private int setBMapParams(Connection connection, PreparedStatement preparedStatement, int index, BMap value, boolean returnType) throws DataError, SQLException {
        String sqlType;
        return switch (sqlType = value.getType().getName()) {
            case "Civil" -> {
                this.setTimestamp(preparedStatement, sqlType, index, value);
                yield 93;
            }
            case "Date" -> {
                this.setDate(preparedStatement, sqlType, index, value);
                yield 91;
            }
            case "TimeOfDay" -> {
                this.setTime(preparedStatement, sqlType, index, value);
                yield 92;
            }
            default -> this.setCustomBOpenRecord(connection, preparedStatement, index, value, returnType);
        };
    }
}

