/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.parameterprocessor;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.stdlib.sql.exception.ApplicationError;
import io.ballerina.stdlib.sql.exception.DataError;
import io.ballerina.stdlib.sql.exception.FieldMismatchError;
import io.ballerina.stdlib.sql.exception.TypeMismatchError;
import io.ballerina.stdlib.sql.exception.UnsupportedTypeError;
import io.ballerina.stdlib.sql.parameterprocessor.AbstractResultParameterProcessor;
import io.ballerina.stdlib.sql.utils.ColumnDefinition;
import io.ballerina.stdlib.sql.utils.ErrorGenerator;
import io.ballerina.stdlib.sql.utils.ModuleUtils;
import io.ballerina.stdlib.sql.utils.PrimitiveTypeColumnDefinition;
import io.ballerina.stdlib.sql.utils.Utils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;

public class DefaultResultParameterProcessor
extends AbstractResultParameterProcessor {
    private static final Object lock = new Object();
    private static volatile DefaultResultParameterProcessor instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultResultParameterProcessor getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new DefaultResultParameterProcessor();
                }
            }
        }
        return instance;
    }

    protected BArray createAndPopulateBBRefValueArray(Object firstNonNullElement, Object[] dataArray, Type type, Array array) throws DataError, SQLException {
        BArray refValueArray;
        int length = dataArray.length;
        if (firstNonNullElement instanceof String) {
            BArray refValueArray2 = this.createEmptyBBRefValueArray((Type)PredefinedTypes.TYPE_STRING);
            for (Object data : dataArray) {
                if (data == null) {
                    refValueArray2.append(null);
                    continue;
                }
                refValueArray2.append((Object)StringUtils.fromString((String)String.valueOf(data)));
            }
            return refValueArray2;
        }
        if (firstNonNullElement instanceof Boolean) {
            refValueArray = this.createEmptyBBRefValueArray((Type)PredefinedTypes.TYPE_BOOLEAN);
        } else if (firstNonNullElement instanceof Short) {
            refValueArray = this.createEmptyBBRefValueArray((Type)PredefinedTypes.TYPE_INT);
        } else if (firstNonNullElement instanceof Integer) {
            refValueArray = this.createEmptyBBRefValueArray((Type)PredefinedTypes.TYPE_INT);
        } else if (firstNonNullElement instanceof Long) {
            refValueArray = this.createEmptyBBRefValueArray((Type)PredefinedTypes.TYPE_INT);
        } else if (firstNonNullElement instanceof Float) {
            refValueArray = this.createEmptyBBRefValueArray((Type)PredefinedTypes.TYPE_FLOAT);
        } else if (firstNonNullElement instanceof Double) {
            refValueArray = this.createEmptyBBRefValueArray((Type)PredefinedTypes.TYPE_FLOAT);
        } else {
            if (firstNonNullElement instanceof BigDecimal) {
                BArray refValueArray3 = this.createEmptyBBRefValueArray((Type)PredefinedTypes.TYPE_DECIMAL);
                for (int i = 0; i < length; ++i) {
                    refValueArray3.add((long)i, dataArray[i] != null ? ValueCreator.createDecimalValue((BigDecimal)((BigDecimal)dataArray[i])) : null);
                }
                return refValueArray3;
            }
            if (firstNonNullElement instanceof java.util.Date) {
                if (firstNonNullElement instanceof Date) {
                    BArray refValueArray4 = this.createEmptyBBRefValueArray((Type)Utils.DATE_RECORD_TYPE);
                    for (int i = 0; i < length; ++i) {
                        if (dataArray[i] == null) {
                            refValueArray4.add((long)i, dataArray[i]);
                            continue;
                        }
                        BMap<BString, Object> dateMap = Utils.createDateRecord((Date)dataArray[i]);
                        refValueArray4.add((long)i, dateMap);
                    }
                    return refValueArray4;
                }
                if (firstNonNullElement instanceof Time) {
                    BArray refValueArray5 = this.createEmptyBBRefValueArray((Type)Utils.TIME_RECORD_TYPE);
                    for (int i = 0; i < length; ++i) {
                        if (dataArray[i] == null) {
                            refValueArray5.add((long)i, dataArray[i]);
                            continue;
                        }
                        BMap<BString, Object> timeMap = Utils.createTimeRecord((Time)dataArray[i]);
                        refValueArray5.add((long)i, timeMap);
                    }
                    return refValueArray5;
                }
                if (firstNonNullElement instanceof Timestamp) {
                    BArray refValueArray6 = this.createEmptyBBRefValueArray((Type)Utils.CIVIL_RECORD_TYPE);
                    for (int i = 0; i < length; ++i) {
                        if (dataArray[i] == null) {
                            refValueArray6.add((long)i, dataArray[i]);
                            continue;
                        }
                        BMap<BString, Object> civilMap = Utils.createTimestampRecord((Timestamp)dataArray[i]);
                        refValueArray6.add((long)i, civilMap);
                    }
                    return refValueArray6;
                }
                throw new UnsupportedTypeError(firstNonNullElement.getClass().getName(), 0);
            }
            if (firstNonNullElement instanceof OffsetTime) {
                BArray refValueArray7 = this.createEmptyBBRefValueArray((Type)Utils.TIME_RECORD_TYPE);
                for (int i = 0; i < length; ++i) {
                    if (dataArray[i] == null) {
                        refValueArray7.add((long)i, dataArray[i]);
                        continue;
                    }
                    BMap<BString, Object> timeMap = Utils.createTimeWithTimezoneRecord((OffsetTime)dataArray[i]);
                    refValueArray7.add((long)i, timeMap);
                }
                return refValueArray7;
            }
            if (firstNonNullElement instanceof OffsetDateTime) {
                BArray refValueArray8 = this.createEmptyBBRefValueArray((Type)Utils.CIVIL_RECORD_TYPE);
                for (int i = 0; i < length; ++i) {
                    if (dataArray[i] == null) {
                        refValueArray8.add((long)i, dataArray[i]);
                        continue;
                    }
                    BMap<BString, Object> civilMap = Utils.createTimestampWithTimezoneRecord((OffsetDateTime)dataArray[i]);
                    refValueArray8.add((long)i, civilMap);
                }
                return refValueArray8;
            }
            if (firstNonNullElement instanceof byte[]) {
                BArray refValueArray9 = this.createEmptyBBRefValueArray((Type)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_BYTE));
                for (int i = 0; i < dataArray.length; ++i) {
                    if (dataArray[i] == null) {
                        refValueArray9.add((long)i, dataArray[i]);
                        continue;
                    }
                    refValueArray9.add((long)i, (Object)ValueCreator.createArrayValue((byte[])((byte[])dataArray[i])));
                }
                return refValueArray9;
            }
            if (firstNonNullElement == null) {
                BArray refValueArray10 = this.createEmptyBBRefValueArray(((ArrayType)type).getElementType());
                for (int i = 0; i < length; ++i) {
                    refValueArray10.add((long)i, firstNonNullElement);
                }
                return refValueArray10;
            }
            return this.createAndPopulateCustomBBRefValueArray(firstNonNullElement, type, array);
        }
        for (int i = 0; i < length; ++i) {
            refValueArray.add((long)i, dataArray[i]);
        }
        return refValueArray;
    }

    public BArray createEmptyBBRefValueArray(Type type) {
        ArrayList<Object> memberTypes = new ArrayList<Object>(2);
        memberTypes.add(type);
        memberTypes.add(PredefinedTypes.TYPE_NULL);
        UnionType unionType = TypeCreator.createUnionType(memberTypes);
        return ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)unionType));
    }

    @Override
    protected BArray createAndPopulateCustomBBRefValueArray(Object firstNonNullElement, Type type, Array array) throws DataError, SQLException {
        return null;
    }

    protected BArray createAndPopulatePrimitiveValueArray(Object firstNonNullElement, Object[] dataArray, Type type, Array array) throws DataError, SQLException {
        String elementType;
        switch (elementType = firstNonNullElement.getClass().getCanonicalName()) {
            case "java.lang.String": {
                return Utils.createStringArray(dataArray);
            }
            case "java.lang.Boolean": {
                return Utils.createBooleanArray(dataArray);
            }
            case "java.lang.Short": {
                return Utils.createShortArray(dataArray);
            }
            case "java.lang.Integer": {
                return Utils.createIntegerArray(dataArray);
            }
            case "java.lang.Long": {
                return Utils.createLongArray(dataArray);
            }
            case "java.lang.Float": {
                return Utils.createFloatArray(dataArray);
            }
            case "java.lang.Double": {
                return Utils.createDoubleArray(dataArray);
            }
            case "java.math.BigDecimal": {
                return Utils.createBigDecimalArray(dataArray);
            }
            case "byte[]": {
                return Utils.createByteArray(dataArray);
            }
            case "java.sql.Date": {
                return Utils.createDateArray(dataArray);
            }
            case "java.sql.Timestamp": {
                return Utils.createTimestampArray(dataArray);
            }
            case "java.sql.Time": {
                return Utils.createTimeArray(dataArray);
            }
            case "java.time.OffsetTime": {
                return Utils.createOffsetArray(dataArray);
            }
            case "java.time.OffsetDateTime": {
                return Utils.createOffsetTimeArray(dataArray);
            }
        }
        return this.createAndPopulateCustomValueArray(firstNonNullElement, type, array);
    }

    @Override
    protected BArray createAndPopulateCustomValueArray(Object firstNonNullElement, Type type, Array array) throws DataError, SQLException {
        return null;
    }

    protected BMap<BString, Object> createUserDefinedType(Struct structValue, StructureType structType) throws DataError, SQLException {
        if (structValue == null) {
            return null;
        }
        Field[] internalStructFields = structType.getFields().values().toArray(new Field[0]);
        BMap struct = ValueCreator.createRecordValue((RecordType)((RecordType)structType));
        Object[] dataArray = structValue.getAttributes();
        if (dataArray != null) {
            if (dataArray.length != internalStructFields.length) {
                throw new FieldMismatchError(structType.getName(), internalStructFields.length, dataArray.length);
            }
            int index = 0;
            for (Field internalField : internalStructFields) {
                int type = TypeUtils.getReferredType((Type)internalField.getFieldType()).getTag();
                BString fieldName = StringUtils.fromString((String)internalField.getFieldName());
                Object value = dataArray[index];
                switch (type) {
                    case 1: {
                        if (value instanceof BigDecimal) {
                            struct.put((Object)fieldName, (Object)((BigDecimal)value).intValue());
                            break;
                        }
                        struct.put((Object)fieldName, value);
                        break;
                    }
                    case 3: {
                        if (value instanceof BigDecimal) {
                            struct.put((Object)fieldName, (Object)((BigDecimal)value).doubleValue());
                            break;
                        }
                        struct.put((Object)fieldName, value);
                        break;
                    }
                    case 4: {
                        if (value instanceof BigDecimal) {
                            struct.put((Object)fieldName, value);
                            break;
                        }
                        struct.put((Object)fieldName, (Object)ValueCreator.createDecimalValue((BigDecimal)((BigDecimal)value)));
                        break;
                    }
                    case 5: {
                        struct.put((Object)fieldName, value);
                        break;
                    }
                    case 6: {
                        struct.put((Object)fieldName, (Object)((Integer)value == 1 ? 1 : 0));
                        break;
                    }
                    case 24: 
                    case 47: {
                        struct.put((Object)fieldName, this.createUserDefinedType((Struct)value, (StructureType)TypeUtils.getReferredType((Type)internalField.getFieldType())));
                        break;
                    }
                    default: {
                        this.createUserDefinedTypeSubtype(internalField, structType);
                    }
                }
                ++index;
            }
        }
        return struct;
    }

    @Override
    public BStream convertCursorValue(ResultSet resultSet, RecordType streamConstraint) {
        if (resultSet == null) {
            return null;
        }
        try {
            List<ColumnDefinition> columnDefinitions = Utils.getColumnDefinitions(resultSet, (StructureType)streamConstraint);
            BObject resultIterator = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"ResultIterator", (Object[])new Object[]{null, this.getBalStreamResultIterator()});
            resultIterator.addNativeData("ResultSet", (Object)resultSet);
            resultIterator.addNativeData("ColumnDefinition", columnDefinitions);
            resultIterator.addNativeData("recordType", (Object)streamConstraint);
            return ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)streamConstraint, (Type)PredefinedTypes.TYPE_NULL), (BObject)resultIterator);
        }
        catch (ApplicationError applicationError) {
            BError errorValue = ErrorGenerator.getSQLApplicationError(applicationError);
            return Utils.getErrorStream(streamConstraint, errorValue);
        }
        catch (SQLException sqlException) {
            BError errorValue = ErrorGenerator.getSQLDatabaseError(sqlException, "Error while retrieving column definition from result set.");
            return Utils.getErrorStream(streamConstraint, errorValue);
        }
    }

    @Override
    protected void createUserDefinedTypeSubtype(Field internalField, StructureType structType) throws DataError {
        throw new TypeMismatchError("Error while retrieving data for unsupported type " + internalField.getFieldType().getName() + " to create " + structType.getName() + " record.");
    }

    protected static boolean containsNullObject(Object[] objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    protected static Object firstNonNullObject(Object[] objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public BArray convertArray(Array array, int sqlType, Type type) throws SQLException, DataError {
        if (array != null) {
            Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL Array");
            Object[] dataArray = (Object[])array.getArray();
            if (dataArray == null || dataArray.length == 0) {
                return null;
            }
            Object firstNonNullElement = DefaultResultParameterProcessor.firstNonNullObject(dataArray);
            boolean containsNull = DefaultResultParameterProcessor.containsNullObject(dataArray);
            if (containsNull) {
                return this.createAndPopulateBBRefValueArray(firstNonNullElement, dataArray, type, array);
            }
            return this.createAndPopulatePrimitiveValueArray(firstNonNullElement, dataArray, type, array);
        }
        return null;
    }

    @Override
    public BString convertChar(String value, int sqlType, Type type) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL String");
        return StringUtils.fromString((String)value);
    }

    @Override
    public Object convertChar(String value, int sqlType, Type type, String sqlTypeName) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, sqlTypeName);
        return StringUtils.fromString((String)value);
    }

    @Override
    public Object convertByteArray(byte[] value, int sqlType, Type type, String sqlTypeName) throws DataError {
        if (value != null) {
            return ValueCreator.createArrayValue((byte[])value);
        }
        return null;
    }

    @Override
    public Object convertBinary(Object value, int sqlType, Type ballerinaType) throws DataError {
        if (ballerinaType.getTag() == 5) {
            return this.convertChar((String)value, sqlType, ballerinaType);
        }
        return this.convertByteArray(((String)value).getBytes(Charset.defaultCharset()), sqlType, ballerinaType, JDBCType.valueOf(sqlType).getName());
    }

    @Override
    public Object convertInteger(long value, int sqlType, Type type, boolean isNull) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL long or integer");
        if (isNull) {
            return null;
        }
        if (type.getTag() == 5) {
            return StringUtils.fromString((String)String.valueOf(value));
        }
        return value;
    }

    @Override
    public Object convertDouble(double value, int sqlType, Type type, boolean isNull) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL double or float");
        if (isNull) {
            return null;
        }
        if (type.getTag() == 5) {
            return StringUtils.fromString((String)String.valueOf(value));
        }
        return value;
    }

    @Override
    public Object convertDecimal(BigDecimal value, int sqlType, Type type, boolean isNull) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL decimal or real");
        if (isNull) {
            return null;
        }
        if (type.getTag() == 5) {
            return StringUtils.fromString((String)String.valueOf(value));
        }
        return ValueCreator.createDecimalValue((BigDecimal)value);
    }

    @Override
    public Object convertBlob(Blob value, int sqlType, Type type) throws DataError, SQLException {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL Blob");
        if (value != null) {
            return ValueCreator.createArrayValue((byte[])value.getBytes(1L, (int)value.length()));
        }
        return null;
    }

    @Override
    public Object convertDate(java.util.Date date, int sqlType, Type type) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL Date/Time");
        if (date != null) {
            switch (type.getTag()) {
                case 5: {
                    return StringUtils.fromString((String)date.toString());
                }
                case 24: 
                case 47: {
                    if (type.getName().equals("Date")) {
                        if (date instanceof Date) {
                            return Utils.createDateRecord((Date)date);
                        }
                        return StringUtils.fromString((String)date.toString());
                    }
                    throw new TypeMismatchError("SQL Date", Utils.getBTypeName(type), "time:Date");
                }
                case 1: {
                    return date.getTime();
                }
            }
        }
        return null;
    }

    @Override
    public Object convertTime(java.util.Date time, int sqlType, Type type) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL Date/Time");
        if (time != null) {
            switch (type.getTag()) {
                case 5: {
                    return StringUtils.fromString((String)time.toString());
                }
                case 24: 
                case 47: {
                    if (type.getName().equals("TimeOfDay")) {
                        if (time instanceof Time) {
                            return Utils.createTimeRecord((Time)time);
                        }
                        return StringUtils.fromString((String)time.toString());
                    }
                    throw new TypeMismatchError("SQL Time", type.getName(), "time:TimeOfDay");
                }
                case 1: {
                    return time.getTime();
                }
            }
        }
        return null;
    }

    @Override
    public Object convertTimeWithTimezone(OffsetTime offsetTime, int sqlType, Type type) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL Date/Time");
        if (offsetTime != null) {
            switch (type.getTag()) {
                case 5: {
                    return StringUtils.fromString((String)offsetTime.toString());
                }
                case 24: 
                case 47: {
                    if (type.getName().equals("TimeOfDay")) {
                        return Utils.createTimeWithTimezoneRecord(offsetTime);
                    }
                    throw new TypeMismatchError("SQL Time with Timezone", type.getName(), "time:TimeOfDay");
                }
                case 1: {
                    return Time.valueOf(offsetTime.toLocalTime()).getTime();
                }
            }
        }
        return null;
    }

    @Override
    public Object convertTimeStamp(java.util.Date timestamp, int sqlType, Type type) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL Date/Time");
        if (timestamp != null) {
            switch (type.getTag()) {
                case 5: {
                    return StringUtils.fromString((String)timestamp.toString());
                }
                case 24: 
                case 47: {
                    if (type.getName().equalsIgnoreCase("Civil") && timestamp instanceof Timestamp) {
                        return Utils.createTimestampRecord((Timestamp)timestamp);
                    }
                    throw new TypeMismatchError("SQL Timestamp", type.getName(), "time:Civil");
                }
                case 1: {
                    return timestamp.getTime();
                }
                case 34: 
                case 44: {
                    return Utils.createTimeStruct(timestamp.getTime());
                }
            }
        }
        return null;
    }

    @Override
    public Object convertTimestampWithTimezone(OffsetDateTime offsetDateTime, int sqlType, Type type) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL Date/Time");
        int tag = type.getTag();
        if (offsetDateTime != null) {
            switch (tag) {
                case 5: {
                    return StringUtils.fromString((String)offsetDateTime.toString());
                }
                case 24: 
                case 47: {
                    if (type.getName().equalsIgnoreCase("Civil")) {
                        return Utils.createTimestampWithTimezoneRecord(offsetDateTime);
                    }
                    throw new TypeMismatchError("SQL Timestamp with Timezone", type.getName(), "time:Civil");
                }
                case 1: {
                    return Timestamp.valueOf(offsetDateTime.toLocalDateTime()).getTime();
                }
                case 34: 
                case 44: {
                    return Utils.createTimeStruct(Timestamp.valueOf(offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime()).getTime());
                }
            }
        }
        return null;
    }

    @Override
    public Object convertBoolean(boolean value, int sqlType, Type type, boolean isNull) throws DataError {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL Boolean");
        if (!isNull) {
            switch (type.getTag()) {
                case 6: {
                    return value;
                }
                case 1: {
                    if (value) {
                        return 1L;
                    }
                    return 0L;
                }
                case 5: {
                    return StringUtils.fromString((String)String.valueOf(value));
                }
            }
        }
        return null;
    }

    @Override
    public Object convertStruct(Struct value, int sqlType, Type type) throws DataError, SQLException {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL Struct");
        if (value != null) {
            if (type instanceof RecordType) {
                return this.createUserDefinedType(value, (StructureType)((RecordType)type));
            }
            throw new TypeMismatchError("SQL Struct", type.getName(), "record type");
        }
        return null;
    }

    @Override
    public Object convertXml(SQLXML value, int sqlType, Type type) throws DataError, SQLException {
        Utils.validatedInvalidFieldAssignment(sqlType, type, "SQL XML");
        if (value != null) {
            if (type instanceof BXml) {
                return XmlUtils.parse((InputStream)value.getBinaryStream());
            }
            throw new TypeMismatchError("SQL XML", TypeUtils.getType((Object)value).getName(), "xml");
        }
        return null;
    }

    private Object processCharacterTypes(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getString(paramIndex);
    }

    private Object processFloatAndReal(CallableStatement statement, int paramIndex) throws SQLException {
        return Float.valueOf(statement.getFloat(paramIndex));
    }

    private Object processNumericAndDecimal(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getBigDecimal(paramIndex);
    }

    private Object processBitAndBoolean(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getBoolean(paramIndex);
    }

    private Object processRefAndStruct(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getObject(paramIndex);
    }

    @Override
    public Object processChar(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processCharacterTypes(statement, paramIndex);
    }

    @Override
    public Object processVarchar(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processCharacterTypes(statement, paramIndex);
    }

    @Override
    public Object processLongVarchar(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processCharacterTypes(statement, paramIndex);
    }

    @Override
    public Object processNChar(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processCharacterTypes(statement, paramIndex);
    }

    @Override
    public Object processNVarchar(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processCharacterTypes(statement, paramIndex);
    }

    @Override
    public Object processLongNVarchar(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processCharacterTypes(statement, paramIndex);
    }

    @Override
    public Object processBinary(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processCharacterTypes(statement, paramIndex);
    }

    @Override
    public Object processVarBinary(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processCharacterTypes(statement, paramIndex);
    }

    @Override
    public Object processLongVarBinary(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processCharacterTypes(statement, paramIndex);
    }

    @Override
    public Object processBlob(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getBlob(paramIndex);
    }

    @Override
    public Object processClob(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getClob(paramIndex);
    }

    @Override
    public Object processNClob(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getNClob(paramIndex);
    }

    @Override
    public Object processDate(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getDate(paramIndex);
    }

    @Override
    public Object processTime(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getTime(paramIndex);
    }

    @Override
    public Object processTimeWithTimeZone(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getObject(paramIndex, OffsetTime.class);
    }

    @Override
    public Object processTimestamp(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getTimestamp(paramIndex);
    }

    @Override
    public Object processTimestampWithTimeZone(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getObject(paramIndex, OffsetDateTime.class);
    }

    @Override
    public Object processArray(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getArray(paramIndex);
    }

    @Override
    public Object processRowID(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getRowId(paramIndex);
    }

    @Override
    public Object processTinyInt(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getInt(paramIndex);
    }

    @Override
    public Object processSmallInt(CallableStatement statement, int paramIndex) throws SQLException {
        return (int)statement.getShort(paramIndex);
    }

    @Override
    public Object processInteger(CallableStatement statement, int paramIndex) throws SQLException {
        return (long)statement.getInt(paramIndex);
    }

    @Override
    public Object processBigInt(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getLong(paramIndex);
    }

    @Override
    public Object processReal(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processFloatAndReal(statement, paramIndex);
    }

    @Override
    public Object processFloat(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processFloatAndReal(statement, paramIndex);
    }

    @Override
    public Object processDouble(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getDouble(paramIndex);
    }

    @Override
    public Object processNumeric(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processNumericAndDecimal(statement, paramIndex);
    }

    @Override
    public Object processDecimal(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processNumericAndDecimal(statement, paramIndex);
    }

    @Override
    public Object processBit(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processBitAndBoolean(statement, paramIndex);
    }

    @Override
    public Object processBoolean(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processBitAndBoolean(statement, paramIndex);
    }

    @Override
    public Object processRef(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processRefAndStruct(statement, paramIndex);
    }

    @Override
    public Object processStruct(CallableStatement statement, int paramIndex) throws SQLException {
        return this.processRefAndStruct(statement, paramIndex);
    }

    @Override
    public Object processXML(CallableStatement statement, int paramIndex) throws SQLException {
        return statement.getSQLXML(paramIndex);
    }

    @Override
    public Object processCustomOutParameters(CallableStatement statement, int paramIndex, int sqlType) throws DataError, SQLException {
        throw new UnsupportedTypeError(JDBCType.valueOf(sqlType).getName(), paramIndex);
    }

    @Override
    public Object processCustomTypeFromResultSet(ResultSet resultSet, int columnIndex, PrimitiveTypeColumnDefinition columnDefinition) throws DataError, SQLException {
        throw new UnsupportedTypeError(columnDefinition.getSqlTypeName(), columnIndex);
    }

    @Override
    public Object convertCustomOutParameter(Object value, String outParamObjectName, int sqlType, Type ballerinaType) throws DataError, SQLException {
        throw new UnsupportedTypeError("Unsupported SQL Custom Out Parameter of type " + String.valueOf(JDBCType.valueOf(sqlType)));
    }

    @Override
    public Object convertCustomInOutParameter(Object value, Object inParamValue, int sqlType, Type ballerinaType) throws DataError, SQLException {
        throw new UnsupportedTypeError("Unsupported SQL Custom InOut Parameter of type " + String.valueOf(JDBCType.valueOf(sqlType)));
    }

    @Override
    public Object processCustomArrayOutParameter(Object[] dataArray, Type ballerinaType) throws DataError, SQLException {
        throw new UnsupportedTypeError("Unsupported SQL Custom Array Out Parameter.");
    }

    @Override
    public Object processCustomArrayInOutParameter(Object[] dataArray, Type ballerinaType) throws DataError, SQLException {
        throw new UnsupportedTypeError("Unsupported SQL Custom Array InOut Parameter.");
    }

    @Override
    public BObject getBalStreamResultIterator() {
        return null;
    }
}

