/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.sequencemodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.sequencemodelgenerator.core.ParticipantBodyAnalyzer;
import io.ballerina.sequencemodelgenerator.core.model.Participant;
import io.ballerina.sequencemodelgenerator.core.model.SequenceNode;
import io.ballerina.tools.text.LineRange;
import java.util.List;
import java.util.Objects;

public class ParticipantAnalyzer
extends NodeVisitor {
    private final SemanticModel semanticModel;
    private String name;
    private final String moduleName;
    private Participant.ParticipantKind kind;
    private LineRange location;
    private List<SequenceNode> sequenceNodes;

    public ParticipantAnalyzer(SemanticModel semanticModel, String moduleName) {
        this.semanticModel = semanticModel;
        this.moduleName = moduleName;
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        this.name = functionDefinitionNode.functionName().text();
        this.kind = Participant.ParticipantKind.FUNCTION;
        this.location = functionDefinitionNode.location().lineRange();
        ParticipantBodyAnalyzer participantBodyAnalyzer = new ParticipantBodyAnalyzer(this.semanticModel);
        functionDefinitionNode.functionBody().accept((NodeVisitor)participantBodyAnalyzer);
        this.sequenceNodes = participantBodyAnalyzer.getSequenceNodes();
    }

    public void visit(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        this.kind = Participant.ParticipantKind.ENDPOINT;
        this.location = moduleVariableDeclarationNode.location().lineRange();
    }

    public void visit(VariableDeclarationNode variableDeclarationNode) {
        this.kind = Participant.ParticipantKind.ENDPOINT;
        this.location = variableDeclarationNode.location().lineRange();
    }

    public void visit(CaptureBindingPatternNode captureBindingPatternNode) {
        this.name = captureBindingPatternNode.variableName().text();
        captureBindingPatternNode.parent().parent().accept((NodeVisitor)this);
    }

    public Participant getParticipant() {
        String id = String.valueOf(Objects.hash(this.location));
        return new Participant(id, this.name, this.kind, this.moduleName, this.sequenceNodes, this.location);
    }
}

