/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.config.schema.generator;

import io.ballerina.projects.ConfigReader;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.configschema.ConfigSchemaBuilder;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CompilationAnalysisContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;

public class ConfigSchemaGenTask
implements AnalysisTask<CompilationAnalysisContext> {
    static final String CONFIG_SCHEMA = "config-schema.json";

    public void perform(CompilationAnalysisContext compilationAnalysisContext) {
        if (compilationAnalysisContext.currentPackage().compilationOptions().configSchemaGen().booleanValue()) {
            String schema = new ConfigSchemaBuilder().getConfigSchemaContent(ConfigReader.getConfigVariables((Package)compilationAnalysisContext.currentPackage()));
            this.writeConfigJSONSchema(schema, compilationAnalysisContext.currentPackage().project());
        }
    }

    private void writeConfigJSONSchema(String schema, Project project) {
        Path path = project.kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT) ? Path.of(System.getProperty("user.dir"), new String[0]) : project.targetDir().resolve("bin");
        if (!schema.isEmpty()) {
            Path configSchemaFile = path.resolve(CONFIG_SCHEMA);
            ConfigSchemaGenTask.createIfNotExists(configSchemaFile);
            ConfigSchemaGenTask.writeContent(configSchemaFile, schema);
        }
    }

    private static void createIfNotExists(Path filePath) {
        Path parentDir = filePath.getParent();
        if (parentDir != null && !parentDir.toFile().exists()) {
            try {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            catch (IOException ioException) {
                throw new ProjectException("Failed to create " + parentDir.toString());
            }
        }
        if (!filePath.toFile().exists()) {
            try {
                Files.createFile(filePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProjectException("Failed to create " + filePath.toString());
            }
        }
    }

    private static void writeContent(Path filePath, String content) {
        try {
            Files.write(filePath, Collections.singleton(content), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write dependencies to the " + filePath.toString() + " file");
        }
    }
}

