/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.AbstractStructuredTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.Objects;
import java.util.Optional;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaArrayTypeSymbol
extends AbstractStructuredTypeSymbol
implements ArrayTypeSymbol {
    private Integer size;
    private TypeSymbol memberTypeDesc;
    private String signature;

    public BallerinaArrayTypeSymbol(CompilerContext context, BArrayType arrayType) {
        super(context, TypeDescKind.ARRAY, arrayType);
        if (arrayType.getSize() >= 0) {
            this.size = arrayType.getSize();
        }
    }

    @Override
    public TypeSymbol memberTypeDescriptor() {
        if (this.memberTypeDesc == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            BType eType = ((BArrayType)this.getBType()).eType;
            this.memberTypeDesc = eType.tsymbol != null && eType.tsymbol.getOrigin() == SymbolOrigin.VIRTUAL ? typesFactory.getTypeDescriptor(eType, eType.tsymbol, true) : typesFactory.getTypeDescriptor(eType);
        }
        return this.memberTypeDesc;
    }

    @Override
    public String signature() {
        if (this.signature != null) {
            return this.signature;
        }
        StringBuilder sigBuilder = new StringBuilder();
        TypeSymbol memberType = this.memberTypeDescriptor();
        sigBuilder.append('[').append(((BArrayType)this.getBType()).state == BArrayState.INFERRED ? "*" : this.size().map(Objects::toString).orElse("")).append(']');
        while (memberType.typeKind() == TypeDescKind.ARRAY) {
            ArrayTypeSymbol arrType = (ArrayTypeSymbol)memberType;
            BType memberBType = ((AbstractTypeSymbol)memberType).getBType();
            boolean isInferredMemberType = memberBType instanceof BArrayType && ((BArrayType)memberBType).state == BArrayState.INFERRED;
            sigBuilder.append('[').append(isInferredMemberType ? "*" : arrType.size().map(Objects::toString).orElse("")).append(']');
            memberType = arrType.memberTypeDescriptor();
        }
        this.signature = memberType.typeKind() == TypeDescKind.UNION || memberType.typeKind() == TypeDescKind.INTERSECTION ? "(" + memberType.signature() + ")" + String.valueOf(sigBuilder) : memberType.signature() + String.valueOf(sigBuilder);
        return this.signature;
    }

    @Override
    public Optional<Integer> size() {
        return Optional.ofNullable(this.size);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

