/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnnotationAttachmentSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.Annotatable;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaFunctionTypeSymbol
extends AbstractTypeSymbol
implements FunctionTypeSymbol {
    private List<ParameterSymbol> requiredParams;
    private List<ParameterSymbol> params;
    private ParameterSymbol restParam;
    private TypeSymbol returnType;
    private Annotatable returnTypeAnnots;
    private final BInvokableTypeSymbol typeSymbol;
    private String signature;

    public BallerinaFunctionTypeSymbol(CompilerContext context, BInvokableTypeSymbol invokableSymbol, BType type) {
        super(context, TypeDescKind.FUNCTION, type);
        this.typeSymbol = invokableSymbol;
    }

    @Override
    public List<ParameterSymbol> parameters() {
        if (this.requiredParams == null) {
            if (this.typeSymbol.params == null) {
                this.requiredParams = Collections.emptyList();
                return this.requiredParams;
            }
            SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
            this.requiredParams = this.typeSymbol.params.stream().filter(symbol -> symbol.kind != SymbolKind.PATH_PARAMETER && symbol.kind != SymbolKind.PATH_REST_PARAMETER).map(symbol -> {
                ParameterKind parameterKind = symbol.isDefaultable ? ParameterKind.DEFAULTABLE : ParameterKind.REQUIRED;
                return symbolFactory.createBallerinaParameter((BVarSymbol)symbol, parameterKind);
            }).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return this.requiredParams;
    }

    @Override
    public Optional<List<ParameterSymbol>> params() {
        if (this.params != null) {
            return Optional.of(this.params);
        }
        if (Symbols.isFlagOn(this.typeSymbol.flags, 0x8000000000L)) {
            return Optional.empty();
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<ParameterSymbol> params = new ArrayList<ParameterSymbol>();
        for (BVarSymbol param : this.typeSymbol.params) {
            ParameterKind paramKind;
            if (Symbols.isFlagOn(param.flags, 0x800000000L)) {
                paramKind = ParameterKind.REQUIRED;
            } else if (Symbols.isFlagOn(param.flags, 0x1000000000L)) {
                paramKind = ParameterKind.DEFAULTABLE;
            } else {
                if (!Symbols.isFlagOn(param.flags, 0x400000000L)) continue;
                paramKind = ParameterKind.INCLUDED_RECORD;
            }
            params.add(symbolFactory.createBallerinaParameter(param, paramKind));
        }
        this.params = Collections.unmodifiableList(params);
        return Optional.of(this.params);
    }

    @Override
    public Optional<ParameterSymbol> restParam() {
        if (this.restParam == null) {
            SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
            this.restParam = symbolFactory.createBallerinaParameter(this.typeSymbol.restParam, ParameterKind.REST);
        }
        return Optional.ofNullable(this.restParam);
    }

    @Override
    public Optional<TypeSymbol> returnTypeDescriptor() {
        if (this.returnType == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.returnType = typesFactory.getTypeDescriptor(this.typeSymbol.returnType);
        }
        return Optional.ofNullable(this.returnType);
    }

    @Override
    public Optional<Annotatable> returnTypeAnnotations() {
        if (this.returnTypeAnnots != null) {
            return Optional.of(this.returnTypeAnnots);
        }
        if (this.typeSymbol.returnTypeAnnots.isEmpty()) {
            return Optional.empty();
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<AnnotationSymbol> annots = new ArrayList<AnnotationSymbol>();
        ArrayList<BallerinaAnnotationAttachmentSymbol> annotationAttachments = new ArrayList<BallerinaAnnotationAttachmentSymbol>();
        for (BAnnotationAttachmentSymbol annot : this.typeSymbol.returnTypeAnnots) {
            BallerinaAnnotationAttachmentSymbol annotAttachment = symbolFactory.createAnnotAttachment(annot);
            annots.add(annotAttachment.typeDescriptor());
            annotationAttachments.add(annotAttachment);
        }
        AnnotatableReturnType annotatableReturnType = new AnnotatableReturnType();
        annotatableReturnType.setAnnotations(Collections.unmodifiableList(annots));
        annotatableReturnType.setAnnotAttachments(Collections.unmodifiableList(annotationAttachments));
        this.returnTypeAnnots = annotatableReturnType;
        return Optional.of(this.returnTypeAnnots);
    }

    @Override
    public String signature() {
        if (this.signature != null) {
            return this.signature;
        }
        if (Symbols.isFlagOn(this.getBType().getFlags(), 0x8000000000L)) {
            this.signature = "function";
            return this.signature;
        }
        StringBuilder signature = new StringBuilder("function (");
        StringJoiner joiner = new StringJoiner(", ");
        for (ParameterSymbol requiredParam : this.params().get()) {
            String ballerinaParameterSignature = requiredParam.signature();
            joiner.add(ballerinaParameterSignature);
        }
        this.restParam().ifPresent(ballerinaParameter -> joiner.add(ballerinaParameter.signature()));
        signature.append(joiner.toString()).append(")");
        this.returnTypeDescriptor().ifPresent(typeDescriptor -> signature.append(" returns ").append(typeDescriptor.signature()));
        return signature.toString();
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    private static class AnnotatableReturnType
    implements Annotatable {
        private List<AnnotationSymbol> annots;
        private List<AnnotationAttachmentSymbol> annotAttachments;

        private AnnotatableReturnType() {
        }

        @Override
        public List<AnnotationSymbol> annotations() {
            return this.annots;
        }

        @Override
        public List<AnnotationAttachmentSymbol> annotAttachments() {
            return this.annotAttachments;
        }

        void setAnnotations(List<AnnotationSymbol> annots) {
            this.annots = annots;
        }

        public void setAnnotAttachments(List<AnnotationAttachmentSymbol> annotAttachments) {
            this.annotAttachments = annotAttachments;
        }
    }
}

