/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnnotationAttachmentSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnnotationSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.model.symbols.AnnotationAttachmentSymbol;
import org.ballerinalang.model.types.ArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaPathParameterSymbol
extends BallerinaSymbol
implements PathParameterSymbol {
    private static final String TYPE_ONLY_PATH_REST_PARAM = "$^^";
    private static final String TYPE_ONLY_PATH_PARAM = "$^";
    private final PathSegment.Kind segmentKind;
    private final boolean isTypeOnlyPathParam;
    private TypeSymbol typeDescriptor;
    private List<AnnotationSymbol> annots;
    private List<io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol> annotAttachments;
    private String signature;

    public BallerinaPathParameterSymbol(String name, PathSegment.Kind kind, BSymbol symbol, CompilerContext context) {
        super(name, SymbolKind.PATH_PARAMETER, symbol, context);
        this.segmentKind = kind;
        this.isTypeOnlyPathParam = TYPE_ONLY_PATH_REST_PARAM.equals(name) || TYPE_ONLY_PATH_PARAM.equals(name);
    }

    @Override
    public Optional<String> getName() {
        if (this.isTypeOnlyPathParam) {
            return Optional.empty();
        }
        return super.getName();
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        if (this.annots != null) {
            return this.annots;
        }
        if (this.getInternalSymbol() instanceof BResourcePathSegmentSymbol) {
            this.annots = Collections.emptyList();
            return this.annots;
        }
        BVarSymbol symbol = (BVarSymbol)this.getInternalSymbol();
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<BallerinaAnnotationSymbol> annotSymbols = new ArrayList<BallerinaAnnotationSymbol>();
        for (AnnotationAttachmentSymbol annotationAttachmentSymbol : symbol.getAnnotations()) {
            annotSymbols.add(symbolFactory.createAnnotationSymbol((BAnnotationAttachmentSymbol)annotationAttachmentSymbol));
        }
        this.annots = Collections.unmodifiableList(annotSymbols);
        return this.annots;
    }

    @Override
    public List<io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol> annotAttachments() {
        if (this.annotAttachments != null) {
            return this.annotAttachments;
        }
        if (this.getInternalSymbol() instanceof BResourcePathSegmentSymbol) {
            this.annotAttachments = Collections.emptyList();
            return this.annotAttachments;
        }
        BVarSymbol symbol = (BVarSymbol)this.getInternalSymbol();
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<BallerinaAnnotationAttachmentSymbol> annotAttachments = new ArrayList<BallerinaAnnotationAttachmentSymbol>();
        for (AnnotationAttachmentSymbol annotationAttachmentSymbol : symbol.getAnnotations()) {
            annotAttachments.add(symbolFactory.createAnnotAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol));
        }
        this.annotAttachments = Collections.unmodifiableList(annotAttachments);
        return this.annotAttachments;
    }

    @Override
    public boolean isTypeOnlyParam() {
        return this.isTypeOnlyPathParam;
    }

    @Override
    public TypeSymbol typeDescriptor() {
        if (this.typeDescriptor != null) {
            return this.typeDescriptor;
        }
        BType bType = this.segmentKind == PathSegment.Kind.PATH_REST_PARAMETER && this.getInternalSymbol() instanceof BVarSymbol ? (BType)((ArrayType)((Object)this.getInternalSymbol().type)).getElementType() : this.getInternalSymbol().type;
        TypesFactory typesFactory = TypesFactory.getInstance(this.context);
        this.typeDescriptor = typesFactory.getTypeDescriptor(bType);
        return this.typeDescriptor;
    }

    @Override
    public PathSegment.Kind pathSegmentKind() {
        return this.segmentKind;
    }

    @Override
    public String signature() {
        if (this.signature != null) {
            return this.signature;
        }
        Object typeSignature = this.pathSegmentKind() == PathSegment.Kind.PATH_REST_PARAMETER ? this.typeDescriptor().signature() + "..." : this.typeDescriptor().signature();
        this.signature = this.getName().isPresent() ? "[" + (String)typeSignature + " " + this.getName().get() + "]" : "[" + (String)typeSignature + "]";
        return this.signature;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

