/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.symbols.BallerinaMethodSymbol;
import io.ballerina.compiler.api.impl.symbols.resourcepath.BallerinaDotResourcePath;
import io.ballerina.compiler.api.impl.symbols.resourcepath.BallerinaPathRestParam;
import io.ballerina.compiler.api.impl.symbols.resourcepath.BallerinaPathSegmentList;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import java.util.List;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaResourceMethodSymbol
extends BallerinaMethodSymbol
implements ResourceMethodSymbol {
    private static final String DOT_RESOURCE_PATH = ".";
    private static final String PATH_PARAM = "^";
    private static final String PATH_REST_PARAM = "^^";
    private static final String TYPE_ONLY_PATH_REST_PARAM = "$^^";
    private final CompilerContext context;
    private final BInvokableSymbol internalSymbol;
    private ResourcePath resourcePath;
    private String signature;

    public BallerinaResourceMethodSymbol(FunctionSymbol functionSymbol, BInvokableSymbol symbol, CompilerContext context) {
        super(functionSymbol, symbol, context);
        this.internalSymbol = symbol;
        this.context = context;
    }

    @Override
    public ResourcePath resourcePath() {
        if (this.resourcePath != null) {
            return this.resourcePath;
        }
        BObjectTypeSymbol classSymbol = (BObjectTypeSymbol)this.internalSymbol.owner;
        BResourceFunction resourceFn = this.getBResourceFunction(classSymbol.attachedFuncs, this.internalSymbol);
        List<BResourcePathSegmentSymbol> pathSegmentSymbols = resourceFn.pathSegmentSymbols;
        if (pathSegmentSymbols.isEmpty()) {
            throw new IllegalStateException("Resource path is empty in resource function: " + resourceFn.toString());
        }
        BResourcePathSegmentSymbol firstPath = pathSegmentSymbols.get(0);
        switch (firstPath.getName().getValue()) {
            case ".": {
                this.resourcePath = new BallerinaDotResourcePath();
                break;
            }
            case "^^": {
                this.resourcePath = new BallerinaPathRestParam(resourceFn.restPathParam.getName().getValue(), resourceFn.restPathParam, this.context);
                break;
            }
            case "$^^": {
                this.resourcePath = new BallerinaPathRestParam(TYPE_ONLY_PATH_REST_PARAM, firstPath, this.context);
                break;
            }
            default: {
                this.resourcePath = new BallerinaPathSegmentList(resourceFn.pathSegmentSymbols, resourceFn.pathParams, resourceFn.restPathParam, this.context);
            }
        }
        return this.resourcePath;
    }

    @Override
    public SymbolKind kind() {
        return SymbolKind.RESOURCE_METHOD;
    }

    @Override
    public String signature() {
        if (this.signature != null) {
            return this.signature;
        }
        StringJoiner qualifierJoiner = new StringJoiner(" ");
        this.qualifiers().stream().map(Qualifier::getValue).forEach(qualifierJoiner::add);
        qualifierJoiner.add("function ");
        StringBuilder signature = new StringBuilder(qualifierJoiner.toString());
        StringJoiner joiner = new StringJoiner(", ");
        signature.append(this.getName().get()).append(" ").append(this.resourcePath().signature()).append(" (");
        for (ParameterSymbol requiredParam : this.typeDescriptor().params().get()) {
            String ballerinaParameterSignature = requiredParam.signature();
            joiner.add(ballerinaParameterSignature);
        }
        this.typeDescriptor().restParam().ifPresent(ballerinaParameter -> joiner.add(ballerinaParameter.signature()));
        signature.append(joiner.toString()).append(")");
        this.typeDescriptor().returnTypeDescriptor().ifPresent(typeDescriptor -> signature.append(" returns ").append(typeDescriptor.signature()));
        this.signature = signature.toString();
        return this.signature;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    private BResourceFunction getBResourceFunction(List<BAttachedFunction> methods, BInvokableSymbol internalSymbol) {
        for (BAttachedFunction method : methods) {
            if (internalSymbol != method.symbol || !(method instanceof BResourceFunction)) continue;
            BResourceFunction bResourceFunction = (BResourceFunction)method;
            return bResourceFunction;
        }
        throw new IllegalStateException("Matching BResourceFunction not found for internal symbol: " + internalSymbol.name.value);
    }
}

