/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.SymbolTransformer;
import io.ballerina.compiler.api.SymbolVisitor;
import io.ballerina.compiler.api.impl.LangLibrary;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.SingletonTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.List;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaSingletonTypeSymbol
extends AbstractTypeSymbol
implements SingletonTypeSymbol {
    private final String typeName;
    private final BType broadType;
    private TypeSymbol originalType;

    public BallerinaSingletonTypeSymbol(CompilerContext context, BType broadType, String value, BType bFiniteType) {
        super(context, TypeDescKind.SINGLETON, bFiniteType);
        this.typeName = 5 == broadType.tag ? "\"" + value + "\"" : value;
        this.broadType = broadType;
    }

    @Override
    public List<FunctionSymbol> langLibMethods() {
        if (this.langLibFunctions == null) {
            LangLibrary langLibrary = LangLibrary.getInstance(this.context);
            List<FunctionSymbol> functions = langLibrary.getMethods(this.broadType);
            this.langLibFunctions = this.filterLangLibMethods(functions, this.broadType);
        }
        return this.langLibFunctions;
    }

    @Override
    public String signature() {
        return this.typeName;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(SymbolTransformer<T> transformer) {
        return transformer.transform(this);
    }

    @Override
    public TypeSymbol originalType() {
        if (this.originalType != null) {
            return this.originalType;
        }
        TypesFactory typesFactory = TypesFactory.getInstance(this.context);
        this.originalType = typesFactory.getTypeDescriptor(this.broadType);
        return this.originalType;
    }
}

