/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnyTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnydataTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaArrayTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaBooleanTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaByteTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaCompilationErrorTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaDecimalTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaErrorTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFloatTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFunctionTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFutureTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaHandleTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaIntSigned16TypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaIntSigned32TypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaIntSigned8TypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaIntTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaIntUnsigned16TypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaIntUnsigned32TypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaIntUnsigned8TypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaIntersectionTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaJSONTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaMapTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaNeverTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaNilTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaNoneTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaObjectTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaReadonlyTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaRecordTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaRegexpTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSingletonTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaStreamTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaStringCharTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaStringTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTableTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTupleTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeDescTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeReferenceTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaUnionTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaXMLCommentTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaXMLElementTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaXMLProcessingInstructionTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaXMLTextTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaXMLTypeSymbol;
import io.ballerina.compiler.api.symbols.IntTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.XMLTypeSymbol;
import io.ballerina.types.Core;
import io.ballerina.types.SemType;
import io.ballerina.types.Value;
import java.util.Objects;
import java.util.Optional;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNeverType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BReadonlyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRegexpType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStringSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class TypesFactory {
    private static final CompilerContext.Key<TypesFactory> TYPES_FACTORY_KEY = new CompilerContext.Key();
    private final CompilerContext context;
    private final SymbolFactory symbolFactory;
    private final BLangAnonymousModelHelper anonymousModelHelper;
    private SymbolTable symTable;

    private TypesFactory(CompilerContext context) {
        context.put(TYPES_FACTORY_KEY, this);
        this.context = context;
        this.symbolFactory = SymbolFactory.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    public static TypesFactory getInstance(CompilerContext context) {
        TypesFactory typesFactory = context.get(TYPES_FACTORY_KEY);
        if (typesFactory == null) {
            typesFactory = new TypesFactory(context);
        }
        return typesFactory;
    }

    public TypeSymbol getTypeDescriptor(BType bType) {
        return this.getTypeDescriptor(bType, bType != null ? bType.tsymbol : null, false);
    }

    public TypeSymbol getTypeDescriptor(BType bType, BSymbol tSymbol) {
        return this.getTypeDescriptor(bType, tSymbol, false);
    }

    public TypeSymbol getTypeDescriptor(BType bType, BSymbol tSymbol, boolean rawTypeOnly) {
        return this.getTypeDescriptor(bType, tSymbol, rawTypeOnly, true, false);
    }

    TypeSymbol getTypeDescriptor(BType bType, BSymbol tSymbol, boolean rawTypeOnly, boolean getOriginalType, boolean typeRefFromIntersectType) {
        if (bType == null) {
            return null;
        }
        if (this.isTypeReference(bType, tSymbol, rawTypeOnly)) {
            return new BallerinaTypeReferenceTypeSymbol(this.context, bType, tSymbol, typeRefFromIntersectType);
        }
        BTypeSymbol typeSymbol = tSymbol instanceof BTypeDefinitionSymbol ? tSymbol.type.tsymbol : (BTypeSymbol)tSymbol;
        return this.createTypeDescriptor(bType, typeSymbol);
    }

    private TypeSymbol createTypeDescriptor(BType bType, BTypeSymbol tSymbol) {
        switch (bType.getKind()) {
            case BOOLEAN: {
                return new BallerinaBooleanTypeSymbol(this.context, bType);
            }
            case BYTE: {
                return new BallerinaByteTypeSymbol(this.context, bType);
            }
            case INT: {
                if (bType instanceof BIntSubType) {
                    BIntSubType intSubType = (BIntSubType)bType;
                    return this.createIntSubType(intSubType);
                }
                return new BallerinaIntTypeSymbol(this.context, bType);
            }
            case FLOAT: {
                return new BallerinaFloatTypeSymbol(this.context, bType);
            }
            case DECIMAL: {
                return new BallerinaDecimalTypeSymbol(this.context, bType);
            }
            case STRING: {
                if (bType instanceof BStringSubType) {
                    BStringSubType stringSubType = (BStringSubType)bType;
                    return new BallerinaStringCharTypeSymbol(this.context, stringSubType);
                }
                return new BallerinaStringTypeSymbol(this.context, bType);
            }
            case ANY: {
                return new BallerinaAnyTypeSymbol(this.context, (BAnyType)bType);
            }
            case ANYDATA: {
                if (bType instanceof BRegexpType) {
                    BRegexpType regexpType = (BRegexpType)bType;
                    return new BallerinaRegexpTypeSymbol(this.context, regexpType);
                }
                return new BallerinaAnydataTypeSymbol(this.context, (BAnydataType)bType);
            }
            case HANDLE: {
                return new BallerinaHandleTypeSymbol(this.context, (BHandleType)bType);
            }
            case JSON: {
                return new BallerinaJSONTypeSymbol(this.context, (BJSONType)bType);
            }
            case READONLY: {
                return new BallerinaReadonlyTypeSymbol(this.context, (BReadonlyType)bType);
            }
            case TABLE: {
                return new BallerinaTableTypeSymbol(this.context, (BTableType)bType);
            }
            case XML: {
                if (bType instanceof BXMLSubType) {
                    BXMLSubType subType = (BXMLSubType)bType;
                    return this.createXMLSubType(subType);
                }
                return new BallerinaXMLTypeSymbol(this.context, (BXMLType)bType);
            }
            case OBJECT: {
                BallerinaObjectTypeSymbol objType = new BallerinaObjectTypeSymbol(this.context, (BObjectType)bType);
                if (Symbols.isFlagOn(tSymbol.flags, 0x10000000L)) {
                    return this.symbolFactory.createClassSymbol((BClassSymbol)tSymbol, tSymbol.name.value, objType);
                }
                return objType;
            }
            case RECORD: {
                return new BallerinaRecordTypeSymbol(this.context, (BRecordType)bType);
            }
            case ERROR: {
                return new BallerinaErrorTypeSymbol(this.context, (BErrorType)bType);
            }
            case UNION: {
                return new BallerinaUnionTypeSymbol(this.context, (BUnionType)bType);
            }
            case FUTURE: {
                return new BallerinaFutureTypeSymbol(this.context, (BFutureType)bType);
            }
            case MAP: {
                return new BallerinaMapTypeSymbol(this.context, (BMapType)bType);
            }
            case STREAM: {
                return new BallerinaStreamTypeSymbol(this.context, (BStreamType)bType);
            }
            case ARRAY: {
                return new BallerinaArrayTypeSymbol(this.context, (BArrayType)bType);
            }
            case TUPLE: {
                return new BallerinaTupleTypeSymbol(this.context, (BTupleType)bType);
            }
            case TYPEDESC: {
                return new BallerinaTypeDescTypeSymbol(this.context, (BTypedescType)bType);
            }
            case NIL: {
                return new BallerinaNilTypeSymbol(this.context, bType);
            }
            case FINITE: {
                BFiniteType finiteType = (BFiniteType)bType;
                Optional value = Core.singleShape((SemType)finiteType.semType());
                if (value.isPresent()) {
                    BType broadType = SemTypeHelper.broadTypes(finiteType, this.symTable).iterator().next();
                    String valueString = Objects.toString(((Value)value.get()).value, "()");
                    return new BallerinaSingletonTypeSymbol(this.context, broadType, valueString, bType);
                }
                return new BallerinaUnionTypeSymbol(this.context, finiteType);
            }
            case FUNCTION: {
                return new BallerinaFunctionTypeSymbol(this.context, (BInvokableTypeSymbol)tSymbol, bType);
            }
            case NEVER: {
                return new BallerinaNeverTypeSymbol(this.context, (BNeverType)bType);
            }
            case NONE: {
                return new BallerinaNoneTypeSymbol(this.context, (BNoType)bType);
            }
            case INTERSECTION: {
                return new BallerinaIntersectionTypeSymbol(this.context, (BIntersectionType)bType);
            }
            case PARAMETERIZED: 
            case TYPEREFDESC: {
                return new BallerinaTypeReferenceTypeSymbol(this.context, bType, tSymbol, false);
            }
            case REGEXP: {
                return new BallerinaRegexpTypeSymbol(this.context, (BRegexpType)bType);
            }
        }
        if (bType.tag == 28) {
            return new BallerinaCompilationErrorTypeSymbol(this.context, bType);
        }
        return new BallerinaTypeSymbol(this.context, bType);
    }

    private IntTypeSymbol createIntSubType(BIntSubType internalType) {
        return switch (internalType.tag) {
            case 44 -> new BallerinaIntUnsigned8TypeSymbol(this.context, internalType);
            case 41 -> new BallerinaIntSigned8TypeSymbol(this.context, internalType);
            case 43 -> new BallerinaIntUnsigned16TypeSymbol(this.context, internalType);
            case 40 -> new BallerinaIntSigned16TypeSymbol(this.context, internalType);
            case 42 -> new BallerinaIntUnsigned32TypeSymbol(this.context, internalType);
            case 39 -> new BallerinaIntSigned32TypeSymbol(this.context, internalType);
            default -> throw new IllegalStateException("Invalid integer subtype type tag: " + internalType.tag);
        };
    }

    private XMLTypeSymbol createXMLSubType(BXMLSubType internalType) {
        return switch (internalType.tag) {
            case 46 -> new BallerinaXMLElementTypeSymbol(this.context, internalType);
            case 47 -> new BallerinaXMLProcessingInstructionTypeSymbol(this.context, internalType);
            case 48 -> new BallerinaXMLCommentTypeSymbol(this.context, internalType);
            case 49 -> new BallerinaXMLTextTypeSymbol(this.context, internalType);
            default -> throw new IllegalStateException("Invalid XML subtype type tag: " + internalType.tag);
        };
    }

    public boolean isTypeReference(BType bType, BSymbol tSymbol, boolean rawTypeOnly) {
        if (rawTypeOnly || tSymbol == null || Symbols.isFlagOn(tSymbol.flags, 0x200000L)) {
            return false;
        }
        if (Symbols.isFlagOn(tSymbol.flags, 2048L)) {
            return false;
        }
        if ((tSymbol.tag & 0x200801CL) == 33587228L) {
            return false;
        }
        if (!(TypesFactory.isBuiltinNamedType(bType.tag) || tSymbol.name.value.isEmpty() || this.anonymousModelHelper.isAnonymousType(tSymbol))) {
            return true;
        }
        TypeKind kind = bType.getKind();
        return kind == TypeKind.PARAMETERIZED || tSymbol.kind == SymbolKind.ENUM || TypesFactory.isCustomError(tSymbol);
    }

    public static TypeDescKind getTypeDescKind(TypeKind bTypeKind) {
        return switch (bTypeKind) {
            case TypeKind.ANY -> TypeDescKind.ANY;
            case TypeKind.ANYDATA -> TypeDescKind.ANYDATA;
            case TypeKind.ARRAY -> TypeDescKind.ARRAY;
            case TypeKind.BOOLEAN -> TypeDescKind.BOOLEAN;
            case TypeKind.BYTE -> TypeDescKind.BYTE;
            case TypeKind.DECIMAL -> TypeDescKind.DECIMAL;
            case TypeKind.FLOAT -> TypeDescKind.FLOAT;
            case TypeKind.HANDLE -> TypeDescKind.HANDLE;
            case TypeKind.INT -> TypeDescKind.INT;
            case TypeKind.NEVER -> TypeDescKind.NEVER;
            case TypeKind.NIL -> TypeDescKind.NIL;
            case TypeKind.STRING -> TypeDescKind.STRING;
            case TypeKind.JSON -> TypeDescKind.JSON;
            case TypeKind.XML -> TypeDescKind.XML;
            case TypeKind.FUNCTION -> TypeDescKind.FUNCTION;
            case TypeKind.FUTURE -> TypeDescKind.FUTURE;
            case TypeKind.MAP -> TypeDescKind.MAP;
            case TypeKind.OBJECT -> TypeDescKind.OBJECT;
            case TypeKind.STREAM -> TypeDescKind.STREAM;
            case TypeKind.TUPLE -> TypeDescKind.TUPLE;
            case TypeKind.TYPEDESC -> TypeDescKind.TYPEDESC;
            case TypeKind.UNION -> TypeDescKind.UNION;
            case TypeKind.INTERSECTION -> TypeDescKind.INTERSECTION;
            case TypeKind.ERROR -> TypeDescKind.ERROR;
            case TypeKind.NONE, TypeKind.OTHER -> TypeDescKind.NONE;
            default -> null;
        };
    }

    private static boolean isCustomError(BSymbol tSymbol) {
        return tSymbol.kind == SymbolKind.ERROR && !Names.ERROR.equals(tSymbol.name);
    }

    private static boolean isBuiltinNamedType(int tag) {
        return switch (tag) {
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 16, 18, 28, 29, 32, 37, 38, 50 -> true;
            default -> false;
        };
    }
}

