/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaArrayTypeBuilder
implements TypeBuilder.ARRAY {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private TypeSymbol type;
    private int size = -1;
    private BArrayState state = BArrayState.OPEN;

    public BallerinaArrayTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.ARRAY withType(TypeSymbol type) {
        this.type = type;
        return this;
    }

    @Override
    public TypeBuilder.ARRAY withSize(Integer size) {
        if (size != null && size >= 0) {
            this.size = size;
            this.state = BArrayState.CLOSED;
        } else {
            this.size = -1;
            this.state = BArrayState.OPEN;
        }
        return this;
    }

    @Override
    public TypeBuilder.ARRAY withInferredSize() {
        this.state = BArrayState.INFERRED;
        this.size = -2;
        return this;
    }

    @Override
    public ArrayTypeSymbol build() {
        BTypeSymbol arrayTSymbol = Symbols.createTypeSymbol(8421404L, 1L, Names.EMPTY, this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        BArrayType arrayType = new BArrayType(this.symTable.typeEnv(), this.getBType(this.type), arrayTSymbol, this.size, this.state);
        arrayTSymbol.type = arrayType;
        ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)this.typesFactory.getTypeDescriptor(arrayType);
        this.size = -1;
        this.type = null;
        this.state = BArrayState.OPEN;
        return arrayTypeSymbol;
    }

    private BType getBType(TypeSymbol type) {
        if (type == null) {
            throw new IllegalArgumentException("Array member type descriptor can not be null");
        }
        if (type instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)type;
            return abstractTypeSymbol.getBType();
        }
        throw new IllegalArgumentException("Invalid array member type descriptor provided");
    }
}

