/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.SingletonTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaSingletonTypeBuilder
implements TypeBuilder.SINGLETON {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private TypeSymbol valueTypeSymbol;
    private Object value;

    public BallerinaSingletonTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.SINGLETON withValueSpace(Object value, TypeSymbol typeSymbol) {
        this.value = value;
        this.valueTypeSymbol = typeSymbol;
        return this;
    }

    @Override
    public SingletonTypeSymbol build() {
        if (this.value == null) {
            throw new IllegalArgumentException("The value provided to the singleton type can not be null");
        }
        if (!this.isValidValueType(this.value, this.valueTypeSymbol)) {
            throw new IllegalArgumentException("Type of value provided doesn't match with the provided type symbol");
        }
        BLangLiteral valueLiteral = new BLangLiteral(this.value, this.getValueBType(this.valueTypeSymbol));
        BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(557084L, 1L, Names.fromString(this.value.toString()), this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        BFiniteType finiteType = BFiniteType.newSingletonBFiniteType(finiteTypeSymbol, SemTypeHelper.resolveSingletonType(valueLiteral));
        finiteTypeSymbol.type = finiteType;
        SingletonTypeSymbol singletonTypeSymbol = (SingletonTypeSymbol)this.typesFactory.getTypeDescriptor(finiteType, finiteTypeSymbol, true);
        this.value = null;
        this.valueTypeSymbol = null;
        return singletonTypeSymbol;
    }

    private boolean isValidValueType(Object value, TypeSymbol typeSymbol) {
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.STRING -> {
                if (value instanceof String || value instanceof Character) {
                    yield true;
                }
                yield false;
            }
            case TypeDescKind.INT -> value instanceof Integer;
            case TypeDescKind.DECIMAL, TypeDescKind.FLOAT -> {
                if (value instanceof Float || value instanceof Double) {
                    yield true;
                }
                yield false;
            }
            case TypeDescKind.BYTE -> value instanceof Byte;
            case TypeDescKind.BOOLEAN -> value instanceof Boolean;
            case TypeDescKind.NIL -> value.equals("()");
            default -> false;
        };
    }

    private BType getValueBType(TypeSymbol typeSymbol) {
        if (typeSymbol == null) {
            return this.symTable.noType;
        }
        if (typeSymbol instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)typeSymbol;
            return abstractTypeSymbol.getBType();
        }
        return this.symTable.anyType;
    }
}

