/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaUnionTypeBuilder
implements TypeBuilder.UNION {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private final List<TypeSymbol> memberTypes = new ArrayList<TypeSymbol>();

    public BallerinaUnionTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.UNION withMemberTypes(TypeSymbol ... memberTypes) {
        this.memberTypes.clear();
        this.memberTypes.addAll(Arrays.asList(memberTypes));
        return this;
    }

    @Override
    public UnionTypeSymbol build() {
        BTypeSymbol unionSymbol = Symbols.createTypeSymbol(1081372L, 1L, Names.EMPTY, this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        BUnionType unionType = BUnionType.create(this.symTable.typeEnv(), unionSymbol, this.getMemberBTypes());
        UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)this.typesFactory.getTypeDescriptor(unionType);
        this.memberTypes.clear();
        return unionTypeSymbol;
    }

    private BType[] getMemberBTypes() {
        if (this.memberTypes.isEmpty()) {
            throw new IllegalArgumentException("Member types can not be empty");
        }
        ArrayList<BType> bTypeList = new ArrayList<BType>();
        for (TypeSymbol memberType : this.memberTypes) {
            if (memberType instanceof AbstractTypeSymbol) {
                AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)memberType;
                bTypeList.add(abstractTypeSymbol.getBType());
                continue;
            }
            if ((memberType instanceof ClassSymbol || memberType instanceof ConstantSymbol || memberType instanceof EnumSymbol) && memberType instanceof BallerinaSymbol) {
                BallerinaSymbol ballerinaSymbol = (BallerinaSymbol)((Object)memberType);
                bTypeList.add(ballerinaSymbol.getInternalSymbol().getType());
                continue;
            }
            throw new IllegalArgumentException("Invalid member type provided.");
        }
        return bTypeList.toArray(new BType[0]);
    }
}

