/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.util;

import io.ballerina.compiler.api.impl.util.SymbolUtils;
import java.util.LinkedHashMap;

public class FieldMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 609051204130116L;

    @Override
    public V get(Object key) {
        this.validateKeyType(key);
        return super.get(SymbolUtils.unescapeUnicode((String)key));
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        this.validateKeyType(key);
        return super.getOrDefault(SymbolUtils.unescapeUnicode((String)key), defaultValue);
    }

    @Override
    public V put(K key, V value) {
        this.validateKeyType(key);
        return super.put(SymbolUtils.unescapeUnicode((String)key), value);
    }

    @Override
    public boolean containsKey(Object key) {
        this.validateKeyType(key);
        return super.containsKey(SymbolUtils.unescapeUnicode((String)key));
    }

    private void validateKeyType(Object key) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Expected a String arg, but found: " + key.getClass().getCanonicalName());
        }
    }
}

