/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BuiltInCompilerPluginInfo;
import io.ballerina.projects.CodeActionManager;
import io.ballerina.projects.CodeAnalyzerManager;
import io.ballerina.projects.CodeGeneratorManager;
import io.ballerina.projects.CodeModifierManager;
import io.ballerina.projects.CompilerLifecycleManager;
import io.ballerina.projects.CompilerPluginCache;
import io.ballerina.projects.CompilerPluginContextIml;
import io.ballerina.projects.CompilerPluginInfo;
import io.ballerina.projects.CompilerPluginKind;
import io.ballerina.projects.CompletionManager;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageProvidedCompilerPluginInfo;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.internal.model.CompilerPluginDescriptor;
import io.ballerina.projects.internal.plugins.CompilerPlugins;
import io.ballerina.projects.plugins.CompilerPlugin;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class CompilerPluginManager {
    private final PackageCompilation compilation;
    private final List<CompilerPluginContextIml> compilerPluginContexts;
    private CodeAnalyzerManager codeAnalyzerManager;
    private CodeGeneratorManager codeGeneratorManager;
    private CodeModifierManager codeModifierManager;
    private CompilerLifecycleManager compilerLifecycleListenerManager;
    private CodeActionManager codeActionManager;
    private CompletionManager completionManager;

    private CompilerPluginManager(PackageCompilation compilation, List<CompilerPluginContextIml> compilerPluginContexts) {
        this.compilation = compilation;
        this.compilerPluginContexts = compilerPluginContexts;
    }

    static CompilerPluginManager from(PackageCompilation compilation) {
        if (!compilation.packageContext().project().compilerPluginContexts().isEmpty()) {
            List<CompilerPluginContextIml> compilerPluginContexts = compilation.packageContext().project().compilerPluginContexts();
            return new CompilerPluginManager(compilation, compilerPluginContexts);
        }
        PackageResolution packageResolution = compilation.getResolution();
        ResolvedPackageDependency rootPkgNode = new ResolvedPackageDependency(packageResolution.packageContext().project().currentPackage(), PackageDependencyScope.DEFAULT);
        DependencyGraph<ResolvedPackageDependency> dependencyGraph = packageResolution.dependencyGraph();
        List<Package> directDependencies = CompilerPluginManager.getDirectDependencies(rootPkgNode, dependencyGraph);
        List<CompilerPluginInfo> compilerPlugins = CompilerPluginManager.loadEngagedCompilerPlugins(directDependencies);
        List<CompilerPluginInfo> inBuiltCompilerPlugins = CompilerPluginManager.loadInBuiltCompilerPlugins(rootPkgNode.packageInstance());
        compilerPlugins.addAll(inBuiltCompilerPlugins);
        List<CompilerPluginContextIml> compilerPluginContexts = CompilerPluginManager.initializePlugins(compilerPlugins, compilation);
        return new CompilerPluginManager(compilation, compilerPluginContexts);
    }

    private static List<CompilerPluginInfo> loadInBuiltCompilerPlugins(Package rootPackage) {
        ArrayList<CompilerPluginInfo> compilerPluginInfoList = new ArrayList<CompilerPluginInfo>();
        for (CompilerPlugin plugin : CompilerPlugins.getBuiltInPlugins()) {
            try {
                if (rootPackage.manifest().descriptor().isBuiltInPackage() || rootPackage.project().kind().equals((Object)ProjectKind.BALA_PROJECT)) continue;
                CompilerPlugin compilerPlugin = CompilerPlugins.loadCompilerPlugin(plugin.getClass().getName(), Collections.emptyList());
                compilerPluginInfoList.add(new BuiltInCompilerPluginInfo(compilerPlugin));
            }
            catch (Throwable e) {
                throw new ProjectException("Failed to load the compiler plugin class: '" + plugin.getClass().getName() + "'. " + e.getMessage());
            }
        }
        return compilerPluginInfoList;
    }

    PackageCompilation compilation() {
        return this.compilation;
    }

    CodeAnalyzerManager getCodeAnalyzerManager() {
        if (this.codeAnalyzerManager != null) {
            return this.codeAnalyzerManager;
        }
        this.codeAnalyzerManager = CodeAnalyzerManager.from(this.compilation, this.compilerPluginContexts);
        return this.codeAnalyzerManager;
    }

    CodeGeneratorManager getCodeGeneratorManager() {
        if (this.codeGeneratorManager != null) {
            return this.codeGeneratorManager;
        }
        this.codeGeneratorManager = CodeGeneratorManager.from(this.compilation, this.compilerPluginContexts);
        return this.codeGeneratorManager;
    }

    CodeModifierManager getCodeModifierManager() {
        if (this.codeModifierManager != null) {
            return this.codeModifierManager;
        }
        this.codeModifierManager = CodeModifierManager.from(this.compilation, this.compilerPluginContexts);
        return this.codeModifierManager;
    }

    CodeActionManager getCodeActionManager() {
        if (this.codeActionManager != null) {
            return this.codeActionManager;
        }
        this.codeActionManager = CodeActionManager.from(this.compilerPluginContexts);
        return this.codeActionManager;
    }

    CompletionManager getCompletionManager() {
        if (this.completionManager != null) {
            return this.completionManager;
        }
        this.completionManager = CompletionManager.from(this.compilerPluginContexts);
        return this.completionManager;
    }

    int engagedCodeGeneratorCount() {
        int count = 0;
        for (CompilerPluginContextIml compilerPluginContext : this.compilerPluginContexts) {
            count += compilerPluginContext.codeGenerators().size();
        }
        return count;
    }

    int engagedCodeModifierCount() {
        int count = 0;
        for (CompilerPluginContextIml compilerPluginContext : this.compilerPluginContexts) {
            count += compilerPluginContext.codeModifiers().size();
        }
        return count;
    }

    private static List<CompilerPluginInfo> loadEngagedCompilerPlugins(List<Package> dependencies) {
        ArrayList<CompilerPluginInfo> compilerPlugins = new ArrayList<CompilerPluginInfo>();
        for (Package pkgDependency : dependencies) {
            PackageManifest pkgManifest = pkgDependency.manifest();
            pkgManifest.compilerPluginDescriptor().ifPresent(pluginDesc -> compilerPlugins.add(CompilerPluginManager.loadCompilerPlugin(pluginDesc, pkgManifest)));
        }
        return compilerPlugins;
    }

    private static CompilerPluginInfo loadCompilerPlugin(CompilerPluginDescriptor pluginDescriptor, PackageManifest pkgManifest) {
        CompilerPlugin compilerPlugin;
        String pluginClassName = pluginDescriptor.plugin().getClassName();
        List<Path> jarLibraryPaths = pluginDescriptor.getCompilerPluginDependencies().stream().map(x$0 -> Path.of(x$0, new String[0])).toList();
        try {
            compilerPlugin = CompilerPlugins.loadCompilerPlugin(pluginClassName, jarLibraryPaths);
        }
        catch (Throwable e) {
            throw new ProjectException("Failed to load the compiler plugin in package: '" + String.valueOf(pkgManifest.org()) + ":" + String.valueOf(pkgManifest.name()) + ":" + String.valueOf(pkgManifest.version()) + "'. " + e.getMessage(), e);
        }
        return new PackageProvidedCompilerPluginInfo(compilerPlugin, pkgManifest.descriptor(), pluginDescriptor);
    }

    private static List<Package> getDirectDependencies(ResolvedPackageDependency rootPkgNode, DependencyGraph<ResolvedPackageDependency> dependencyGraph) {
        return dependencyGraph.getDirectDependencies(rootPkgNode).stream().map(ResolvedPackageDependency::packageInstance).toList();
    }

    private static List<CompilerPluginContextIml> initializePlugins(List<CompilerPluginInfo> compilerPlugins, PackageCompilation compilation) {
        ArrayList<CompilerPluginContextIml> compilerPluginContexts = new ArrayList<CompilerPluginContextIml>(compilerPlugins.size());
        for (CompilerPluginInfo compilerPluginInfo : compilerPlugins) {
            CompilerPluginCache pluginCache = compilation.packageContext().project().projectEnvironmentContext().environment().getService(CompilerPluginCache.class);
            CompilerPluginContextIml pluginContext = new CompilerPluginContextIml(compilerPluginInfo, pluginCache.getData(compilerPluginInfo.compilerPlugin().getClass().getCanonicalName()));
            CompilerPluginManager.initializePlugin(compilerPluginInfo, pluginContext);
            compilerPluginContexts.add(pluginContext);
            compilation.packageContext().project().compilerPluginContexts().add(pluginContext);
        }
        return compilerPluginContexts;
    }

    private static void initializePlugin(CompilerPluginInfo compilerPluginInfo, CompilerPluginContextIml pluginContext) {
        try {
            compilerPluginInfo.compilerPlugin().init(pluginContext);
        }
        catch (Throwable e) {
            String message;
            if (compilerPluginInfo.kind().equals((Object)CompilerPluginKind.PACKAGE_PROVIDED)) {
                PackageDescriptor pkgDesc = ((PackageProvidedCompilerPluginInfo)compilerPluginInfo).packageDesc();
                message = "Failed to initialize the compiler plugin in package: '" + String.valueOf(pkgDesc.org()) + ":" + String.valueOf(pkgDesc.name()) + ":" + String.valueOf(pkgDesc.version()) + "'. ";
            } else {
                message = "Failed to initialize the compiler plugin: '" + compilerPluginInfo.compilerPlugin().getClass().getName() + "'. ";
            }
            throw new ProjectException(message + e.getMessage(), e);
        }
    }

    public CompilerLifecycleManager getCompilerLifecycleListenerManager() {
        if (this.compilerLifecycleListenerManager == null) {
            this.compilerLifecycleListenerManager = CompilerLifecycleManager.from(this.compilation, this.compilerPluginContexts);
            return this.compilerLifecycleListenerManager;
        }
        return this.compilerLifecycleListenerManager;
    }
}

