/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.DependencyResolutionType;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.environment.ModuleLoadRequest;
import io.ballerina.projects.internal.TransactionImportValidator;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.SourceKind;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangNodeBuilder;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

class DocumentContext {
    private static final String IDENTIFIER_LITERAL_PREFIX = "'";
    private SyntaxTree syntaxTree;
    private TextDocument textDocument;
    private Set<ModuleLoadRequest> moduleLoadRequests;
    private BLangCompilationUnit compilationUnit;
    private NodeCloner nodeCloner;
    private final DocumentId documentId;
    private final String name;
    private String content;
    private final boolean disableSyntaxTree;

    private DocumentContext(DocumentId documentId, String name, String content, boolean disableSyntaxTree) {
        this.documentId = documentId;
        this.name = name;
        this.content = content;
        this.disableSyntaxTree = disableSyntaxTree;
    }

    static DocumentContext from(DocumentConfig documentConfig, boolean disableSyntaxTree) {
        return new DocumentContext(documentConfig.documentId(), documentConfig.name(), documentConfig.content(), disableSyntaxTree);
    }

    DocumentId documentId() {
        return this.documentId;
    }

    String name() {
        return this.name;
    }

    SyntaxTree parse() {
        if (this.syntaxTree != null) {
            return this.syntaxTree;
        }
        if (!this.disableSyntaxTree) {
            this.syntaxTree = SyntaxTree.from((TextDocument)this.textDocument(), (String)this.name);
            return this.syntaxTree;
        }
        return SyntaxTree.from((TextDocument)this.textDocument(), (String)this.name);
    }

    SyntaxTree syntaxTree() {
        return this.parse();
    }

    TextDocument textDocument() {
        if (this.textDocument != null) {
            return this.textDocument;
        }
        if (!this.disableSyntaxTree) {
            this.textDocument = TextDocuments.from((String)this.content);
            return this.textDocument;
        }
        return TextDocuments.from((String)this.content);
    }

    BLangCompilationUnit compilationUnit(CompilerContext compilerContext, PackageID pkgID, SourceKind sourceKind) {
        BLangDiagnosticLog dlog = BLangDiagnosticLog.getInstance(compilerContext);
        SyntaxTree synTree = this.syntaxTree();
        this.reportSyntaxDiagnostics(pkgID, synTree, dlog);
        this.nodeCloner = NodeCloner.getInstance(compilerContext);
        if (this.compilationUnit != null) {
            return this.nodeCloner.cloneCUnit(this.compilationUnit);
        }
        BLangNodeBuilder bLangNodeBuilder = new BLangNodeBuilder(compilerContext, pkgID, this.name);
        this.compilationUnit = (BLangCompilationUnit)bLangNodeBuilder.accept(synTree.rootNode()).get(0);
        this.compilationUnit.setSourceKind(sourceKind);
        return this.nodeCloner.cloneCUnit(this.compilationUnit);
    }

    Set<ModuleLoadRequest> moduleLoadRequests(ModuleDescriptor currentModuleDesc, PackageDependencyScope scope) {
        if (this.moduleLoadRequests != null) {
            return this.moduleLoadRequests;
        }
        this.moduleLoadRequests = this.getModuleLoadRequests(currentModuleDesc, scope);
        return this.moduleLoadRequests;
    }

    private Set<ModuleLoadRequest> getModuleLoadRequests(ModuleDescriptor currentModuleDesc, PackageDependencyScope scope) {
        LinkedHashSet<ModuleLoadRequest> moduleLoadRequestSet = new LinkedHashSet<ModuleLoadRequest>();
        ModulePartNode modulePartNode = (ModulePartNode)this.syntaxTree().rootNode();
        for (ImportDeclarationNode importDcl : modulePartNode.imports()) {
            moduleLoadRequestSet.add(this.getModuleLoadRequest(importDcl, scope));
        }
        TransactionImportValidator trxImportValidator = new TransactionImportValidator();
        if (trxImportValidator.shouldImportTransactionPackage(modulePartNode) && !currentModuleDesc.name().toString().equals(Names.TRANSACTION.value)) {
            String moduleName = Names.TRANSACTION.value;
            ModuleLoadRequest ballerinaiLoadReq = new ModuleLoadRequest(PackageOrg.from(Names.BALLERINA_INTERNAL_ORG.value), moduleName, scope, DependencyResolutionType.PLATFORM_PROVIDED);
            moduleLoadRequestSet.add(ballerinaiLoadReq);
        }
        return moduleLoadRequestSet;
    }

    private ModuleLoadRequest getModuleLoadRequest(ImportDeclarationNode importDcl, PackageDependencyScope scope) {
        PackageOrg orgName = importDcl.orgName().map(orgNameNode -> PackageOrg.from(orgNameNode.orgName().text())).orElse(null);
        SeparatedNodeList identifierTokenList = importDcl.moduleName();
        StringJoiner stringJoiner = new StringJoiner(".");
        for (int i = 0; i < identifierTokenList.size(); ++i) {
            stringJoiner.add(this.handleQuotedIdentifier(((IdentifierToken)identifierTokenList.get(i)).text()));
        }
        String moduleName = stringJoiner.toString();
        return new ModuleLoadRequest(orgName, moduleName, scope, DependencyResolutionType.SOURCE, (Location)importDcl.location());
    }

    private String handleQuotedIdentifier(String identifier) {
        if (identifier.startsWith(IDENTIFIER_LITERAL_PREFIX)) {
            return identifier.substring(1);
        }
        return identifier;
    }

    private void reportSyntaxDiagnostics(PackageID pkgID, SyntaxTree tree, BLangDiagnosticLog dlog) {
        for (Diagnostic syntaxDiagnostic : tree.diagnostics()) {
            dlog.logDiagnostic(pkgID, syntaxDiagnostic);
        }
    }

    DocumentContext duplicate() {
        return new DocumentContext(this.documentId, this.name, this.syntaxTree().toSourceCode(), false);
    }

    void shrink() {
        if (this.compilationUnit != null) {
            this.compilationUnit.topLevelNodes.clear();
        }
        this.syntaxTree = null;
        this.moduleLoadRequests = null;
        this.content = null;
    }
}

