/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import java.util.Objects;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.util.Name;

public class ModuleDescriptor
implements Comparable<ModuleDescriptor> {
    private final ModuleName moduleName;
    private final PackageDescriptor packageDesc;
    private final PackageID moduleCompilationId;
    private final PackageID moduleTestCompilationId;

    private ModuleDescriptor(ModuleName moduleName, PackageDescriptor packageDesc) {
        this.moduleName = moduleName;
        this.packageDesc = packageDesc;
        if (packageDesc.name().value().equals(".") && packageDesc.org().anonymous()) {
            this.moduleTestCompilationId = this.moduleCompilationId = PackageID.DEFAULT;
        } else {
            this.moduleCompilationId = new PackageID(new Name(packageDesc.org().value()), new Name(packageDesc.name().value()), new Name(moduleName.toString()), new Name(packageDesc.version().toString()), null);
            this.moduleTestCompilationId = new PackageID(new Name(packageDesc.org().value()), new Name(packageDesc.name().value()), new Name(moduleName.toString()), new Name(packageDesc.version().toString()), null, true, false);
        }
    }

    public static ModuleDescriptor from(ModuleName moduleName, PackageDescriptor packageDescriptor) {
        return new ModuleDescriptor(moduleName, packageDescriptor);
    }

    public PackageName packageName() {
        return this.packageDesc.name();
    }

    public PackageOrg org() {
        return this.packageDesc.org();
    }

    public PackageVersion version() {
        return this.packageDesc.version();
    }

    public ModuleName name() {
        return this.moduleName;
    }

    PackageID moduleCompilationId() {
        return this.moduleCompilationId;
    }

    public PackageID moduleTestCompilationId() {
        return this.moduleTestCompilationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ModuleDescriptor that = (ModuleDescriptor)other;
        return Objects.equals(this.moduleName, that.moduleName) && Objects.equals(this.packageDesc, that.packageDesc);
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.packageDesc);
    }

    @Override
    public int compareTo(ModuleDescriptor other) {
        return this.moduleName.toString().compareTo(other.moduleName.toString());
    }
}

