/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DependencyManifest;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.ModuleConfig;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ResourceConfig;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class PackageConfig {
    private final PackageId packageId;
    private final PackageManifest packageManifest;
    private final DependencyManifest dependencyManifest;
    private final DocumentConfig ballerinaToml;
    private final DocumentConfig dependenciesToml;
    private final DocumentConfig cloudToml;
    private final DocumentConfig compilerPluginToml;
    private final DocumentConfig balToolToml;
    private final Path packagePath;
    private final DependencyGraph<PackageDescriptor> packageDescDependencyGraph;
    private final Collection<ModuleConfig> otherModules;
    private final DocumentConfig readmeMd;
    private final boolean disableSyntaxTree;
    private final List<ResourceConfig> resources;
    private final List<ResourceConfig> testResources;

    private PackageConfig(PackageId packageId, Path packagePath, PackageManifest packageManifest, DependencyManifest dependencyManifest, DocumentConfig ballerinaToml, DocumentConfig dependenciesToml, DocumentConfig cloudToml, DocumentConfig compilerPluginToml, DocumentConfig balToolToml, Collection<ModuleConfig> moduleConfigs, DependencyGraph<PackageDescriptor> packageDescDependencyGraph, DocumentConfig readmeMd, boolean disableSyntaxTree, List<ResourceConfig> resources, List<ResourceConfig> testResources) {
        this.packageId = packageId;
        this.packagePath = packagePath;
        this.packageManifest = packageManifest;
        this.dependencyManifest = dependencyManifest;
        this.ballerinaToml = ballerinaToml;
        this.dependenciesToml = dependenciesToml;
        this.cloudToml = cloudToml;
        this.compilerPluginToml = compilerPluginToml;
        this.balToolToml = balToolToml;
        this.otherModules = moduleConfigs;
        this.packageDescDependencyGraph = packageDescDependencyGraph;
        this.readmeMd = readmeMd;
        this.disableSyntaxTree = disableSyntaxTree;
        this.resources = resources;
        this.testResources = testResources;
    }

    public static PackageConfig from(PackageId packageId, Path packagePath, PackageManifest packageManifest, DependencyManifest dependencyManifest, DocumentConfig ballerinaToml, DocumentConfig dependenciesToml, DocumentConfig cloudToml, DocumentConfig compilerPluginToml, DocumentConfig balToolToml, DocumentConfig packageMd, Collection<ModuleConfig> moduleConfigs, List<ResourceConfig> resources, List<ResourceConfig> testResources) {
        return new PackageConfig(packageId, packagePath, packageManifest, dependencyManifest, ballerinaToml, dependenciesToml, cloudToml, compilerPluginToml, balToolToml, moduleConfigs, DependencyGraph.emptyGraph(), packageMd, false, resources, testResources);
    }

    public static PackageConfig from(PackageId packageId, Path packagePath, PackageManifest packageManifest, DependencyManifest dependencyManifest, DocumentConfig ballerinaToml, DocumentConfig dependenciesToml, DocumentConfig cloudToml, DocumentConfig compilerPluginToml, DocumentConfig balToolToml, DocumentConfig packageMd, Collection<ModuleConfig> moduleConfigs, DependencyGraph<PackageDescriptor> packageDescDependencyGraph, List<ResourceConfig> resources, List<ResourceConfig> testResources) {
        return new PackageConfig(packageId, packagePath, packageManifest, dependencyManifest, ballerinaToml, dependenciesToml, cloudToml, compilerPluginToml, balToolToml, moduleConfigs, packageDescDependencyGraph, packageMd, false, resources, testResources);
    }

    public static PackageConfig from(PackageId packageId, Path path, PackageManifest packageManifest, DependencyManifest dependencyManifest, DocumentConfig ballerinaToml, DocumentConfig dependenciesToml, DocumentConfig cloudToml, DocumentConfig compilerPluginToml, DocumentConfig balToolToml, DocumentConfig readmeMd, List<ModuleConfig> moduleConfigs, DependencyGraph<PackageDescriptor> packageDependencyGraph, boolean disableSyntaxTree, List<ResourceConfig> resources, List<ResourceConfig> testResources) {
        return new PackageConfig(packageId, path, packageManifest, dependencyManifest, ballerinaToml, dependenciesToml, cloudToml, compilerPluginToml, balToolToml, moduleConfigs, packageDependencyGraph, readmeMd, disableSyntaxTree, resources, testResources);
    }

    public PackageId packageId() {
        return this.packageId;
    }

    public PackageName packageName() {
        return this.packageManifest.name();
    }

    public PackageOrg packageOrg() {
        return this.packageManifest.org();
    }

    public PackageVersion packageVersion() {
        return this.packageManifest.version();
    }

    public boolean packageTemplate() {
        return this.packageManifest.template();
    }

    public PackageManifest packageManifest() {
        return this.packageManifest;
    }

    public DependencyManifest dependencyManifest() {
        return this.dependencyManifest;
    }

    public Optional<DocumentConfig> ballerinaToml() {
        return Optional.ofNullable(this.ballerinaToml);
    }

    public Optional<DocumentConfig> cloudToml() {
        return Optional.ofNullable(this.cloudToml);
    }

    public Optional<DocumentConfig> compilerPluginToml() {
        return Optional.ofNullable(this.compilerPluginToml);
    }

    public Optional<DocumentConfig> balToolToml() {
        return Optional.ofNullable(this.balToolToml);
    }

    public CompilationOptions compilationOptions() {
        return null;
    }

    public DependencyGraph<PackageDescriptor> packageDescDependencyGraph() {
        return this.packageDescDependencyGraph;
    }

    public Path packagePath() {
        return this.packagePath;
    }

    public Collection<ModuleConfig> otherModules() {
        return this.otherModules;
    }

    @Deprecated(forRemoval=true)
    public Optional<DocumentConfig> packageMd() {
        return Optional.ofNullable(this.readmeMd);
    }

    public Optional<DocumentConfig> readmeMd() {
        return Optional.ofNullable(this.readmeMd);
    }

    public Optional<DocumentConfig> dependenciesToml() {
        return Optional.ofNullable(this.dependenciesToml);
    }

    boolean isSyntaxTreeDisabled() {
        return this.disableSyntaxTree;
    }

    public List<ResourceConfig> resources() {
        return this.resources;
    }

    public List<ResourceConfig> testResources() {
        return this.testResources;
    }
}

