/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.util.ProjectUtils;
import java.util.Objects;
import java.util.Optional;

public class PackageDescriptor
implements Comparable<PackageDescriptor> {
    private final PackageName packageName;
    private final PackageOrg packageOrg;
    private final PackageVersion packageVersion;
    private final String repository;
    private final Boolean isDeprecated;
    private final String deprecationMsg;

    private PackageDescriptor(PackageOrg packageOrg, PackageName packageName, PackageVersion packageVersion, String repository) {
        this.packageName = packageName;
        this.packageOrg = packageOrg;
        this.repository = repository;
        this.packageVersion = ProjectUtils.isBuiltInPackage(packageOrg, packageName.value()) ? PackageVersion.BUILTIN_PACKAGE_VERSION : packageVersion;
        this.isDeprecated = false;
        this.deprecationMsg = "";
    }

    private PackageDescriptor(PackageOrg packageOrg, PackageName packageName, PackageVersion packageVersion, String repository, Boolean isDeprecated, String deprecationMsg) {
        this.packageName = packageName;
        this.packageOrg = packageOrg;
        this.repository = repository;
        this.packageVersion = ProjectUtils.isBuiltInPackage(packageOrg, packageName.value()) ? PackageVersion.BUILTIN_PACKAGE_VERSION : packageVersion;
        this.isDeprecated = isDeprecated;
        this.deprecationMsg = deprecationMsg;
    }

    public static PackageDescriptor from(PackageOrg packageOrg, PackageName packageName) {
        return new PackageDescriptor(packageOrg, packageName, null, null);
    }

    public static PackageDescriptor from(PackageOrg packageOrg, PackageName packageName, PackageVersion packageVersion) {
        return new PackageDescriptor(packageOrg, packageName, packageVersion, null);
    }

    public static PackageDescriptor from(PackageOrg packageOrg, PackageName packageName, PackageVersion packageVersion, String repository) {
        return new PackageDescriptor(packageOrg, packageName, packageVersion, repository);
    }

    public static PackageDescriptor from(PackageOrg packageOrg, PackageName packageName, PackageVersion packageVersion, Boolean isDeprecated, String deprecationMsg) {
        return new PackageDescriptor(packageOrg, packageName, packageVersion, null, isDeprecated, deprecationMsg);
    }

    public PackageName name() {
        return this.packageName;
    }

    public PackageOrg org() {
        return this.packageOrg;
    }

    public PackageVersion version() {
        return this.packageVersion;
    }

    public Optional<String> repository() {
        return Optional.ofNullable(this.repository);
    }

    public boolean isLangLibPackage() {
        return ProjectUtils.isLangLibPackage(this.packageOrg, this.packageName);
    }

    public boolean isBuiltInPackage() {
        return ProjectUtils.isBuiltInPackage(this.packageOrg, this.packageName.value());
    }

    public Boolean getDeprecated() {
        return this.isDeprecated;
    }

    public String getDeprecationMsg() {
        return this.deprecationMsg;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PackageDescriptor that = (PackageDescriptor)other;
        return this.packageName.equals(that.packageName) && this.packageOrg.equals(that.packageOrg) && Objects.equals(this.packageVersion, that.packageVersion);
    }

    public int hashCode() {
        return Objects.hash(this.packageName, this.packageOrg, this.packageVersion);
    }

    public String toString() {
        String pkgStr = String.valueOf(this.packageOrg) + "/" + String.valueOf(this.packageName);
        if (this.packageVersion == null) {
            return pkgStr;
        }
        return pkgStr + ":" + String.valueOf(this.packageVersion);
    }

    @Override
    public int compareTo(PackageDescriptor other) {
        return this.toString().compareTo(other.toString());
    }
}

