/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CompilationCache;
import io.ballerina.projects.CompilationCacheFactory;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.EnvironmentBuilder;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.environment.DefaultProjectEnvironment;
import io.ballerina.projects.repos.BuildProjectCompilationCache;
import io.ballerina.projects.repos.TempDirCompilationCache;
import java.util.HashMap;
import java.util.Map;

public class ProjectEnvironmentBuilder {
    private final Environment environment;
    private final Map<Class<?>, Object> services = new HashMap();
    private CompilationCacheFactory compilationCacheFactory;

    private ProjectEnvironmentBuilder(Environment environment) {
        this.environment = environment;
    }

    public static ProjectEnvironmentBuilder getBuilder(Environment environment) {
        return new ProjectEnvironmentBuilder(environment);
    }

    public static ProjectEnvironmentBuilder getDefaultBuilder() {
        return new ProjectEnvironmentBuilder(EnvironmentBuilder.buildDefault());
    }

    public ProjectEnvironmentBuilder addCompilationCacheFactory(CompilationCacheFactory compilationCacheFactory) {
        this.compilationCacheFactory = compilationCacheFactory;
        return this;
    }

    public ProjectEnvironment build(Project project) {
        CompilationCache compilationCache;
        if (this.compilationCacheFactory != null) {
            compilationCache = this.compilationCacheFactory.createCompilationCache(project);
        } else {
            compilationCache = switch (project.kind()) {
                default -> throw new MatchException(null, null);
                case ProjectKind.BUILD_PROJECT -> BuildProjectCompilationCache.from(project);
                case ProjectKind.SINGLE_FILE_PROJECT -> TempDirCompilationCache.from(project);
                case ProjectKind.BALA_PROJECT -> throw new IllegalStateException("BALAProject should always be created with a CompilationCache");
            };
        }
        this.services.put(CompilationCache.class, compilationCache);
        return new DefaultProjectEnvironment(project, this.environment, this.services);
    }
}

