/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.DependencyResolutionType;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDependency;
import io.ballerina.projects.PackageDependencyScope;

public class ResolvedPackageDependency
extends PackageDependency
implements Comparable<ResolvedPackageDependency> {
    private final Package resolvedPackage;
    private final DependencyResolutionType dependencyResolvedType;

    public ResolvedPackageDependency(Package resolvedPackage, PackageDependencyScope scope) {
        super(resolvedPackage.packageId(), scope);
        this.resolvedPackage = resolvedPackage;
        this.dependencyResolvedType = DependencyResolutionType.SOURCE;
    }

    public ResolvedPackageDependency(Package resolvedPackage, PackageDependencyScope scope, DependencyResolutionType dependencyResolvedType) {
        super(resolvedPackage.packageId(), scope);
        this.resolvedPackage = resolvedPackage;
        this.dependencyResolvedType = dependencyResolvedType;
    }

    public Package packageInstance() {
        return this.resolvedPackage;
    }

    public DependencyResolutionType dependencyResolvedType() {
        return this.dependencyResolvedType;
    }

    public boolean isPlatformProvided() {
        return this.dependencyResolvedType == DependencyResolutionType.PLATFORM_PROVIDED;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(ResolvedPackageDependency other) {
        return this.resolvedPackage.descriptor().toString().compareTo(other.resolvedPackage.descriptor().toString());
    }
}

