/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.directory;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildTool;
import io.ballerina.projects.BuildToolResolution;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.internal.BalaFiles;
import io.ballerina.projects.internal.PackageConfigCreator;
import io.ballerina.projects.internal.ProjectFiles;
import io.ballerina.projects.internal.model.BuildJson;
import io.ballerina.projects.internal.model.Dependency;
import io.ballerina.projects.internal.model.ToolDependency;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.ProjectPaths;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.wso2.ballerinalang.util.RepoUtils;

public class BuildProject
extends Project {
    public static BuildProject load(ProjectEnvironmentBuilder environmentBuilder, Path projectPath) {
        return BuildProject.load(environmentBuilder, projectPath, BuildOptions.builder().build());
    }

    public static BuildProject load(Path projectPath) {
        return BuildProject.load(projectPath, BuildOptions.builder().build());
    }

    public static BuildProject load(Path projectPath, BuildOptions buildOptions) {
        ProjectEnvironmentBuilder environmentBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        return BuildProject.load(environmentBuilder, projectPath, buildOptions);
    }

    public static BuildProject load(ProjectEnvironmentBuilder environmentBuilder, Path projectPath, BuildOptions buildOptions) {
        PackageConfig packageConfig = PackageConfigCreator.createBuildProjectConfig(projectPath, buildOptions.disableSyntaxTree());
        BuildOptions mergedBuildOptions = ProjectFiles.createBuildOptions(packageConfig, buildOptions, projectPath);
        BuildProject buildProject = new BuildProject(environmentBuilder, projectPath, mergedBuildOptions);
        buildProject.addPackage(packageConfig);
        return buildProject;
    }

    private BuildProject(ProjectEnvironmentBuilder environmentBuilder, Path projectPath, BuildOptions buildOptions) {
        super(ProjectKind.BUILD_PROJECT, projectPath, environmentBuilder, buildOptions);
        this.populateCompilerContext();
    }

    private Optional<Path> modulePath(ModuleId moduleId) {
        if (this.currentPackage().moduleIds().contains(moduleId)) {
            if (this.currentPackage().getDefaultModule().moduleId() == moduleId) {
                return Optional.of(this.sourceRoot);
            }
            return Optional.of(this.sourceRoot.resolve("modules").resolve(this.currentPackage().module(moduleId).moduleName().moduleNamePart()));
        }
        return Optional.empty();
    }

    private Optional<Path> generatedModulePath(ModuleId moduleId) {
        if (this.currentPackage().moduleIds().contains(moduleId)) {
            Optional<Path> generatedModuleDirPath;
            Optional<Path> generatedModulePath = Optional.of(this.sourceRoot.resolve("generated"));
            if (this.currentPackage().getDefaultModule().moduleId() == moduleId && Files.isDirectory(generatedModulePath.get(), new LinkOption[0])) {
                return generatedModulePath;
            }
            String moduleName = this.currentPackage().module(moduleId).moduleName().moduleNamePart();
            if (Files.isDirectory(generatedModulePath.get(), new LinkOption[0]) && Files.isDirectory((generatedModuleDirPath = Optional.of(generatedModulePath.get().resolve(moduleName))).get(), new LinkOption[0])) {
                return Optional.of(generatedModulePath.get().resolve(moduleName));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Path> documentPath(DocumentId documentId) {
        for (ModuleId moduleId : this.currentPackage().moduleIds()) {
            Optional<Path> generatedModulePath;
            Module module = this.currentPackage().module(moduleId);
            Optional<Path> modulePath = this.modulePath(moduleId);
            if (module.documentIds().contains(documentId)) {
                generatedModulePath = this.generatedModulePath(moduleId);
                if (generatedModulePath.isPresent() && Files.exists(generatedModulePath.get().resolve(module.document(documentId).name()), new LinkOption[0])) {
                    return Optional.of(generatedModulePath.get().resolve(module.document(documentId).name()));
                }
                if (!modulePath.isPresent()) continue;
                return Optional.of(modulePath.get().resolve(module.document(documentId).name()));
            }
            if (!module.testDocumentIds().contains(documentId)) continue;
            generatedModulePath = this.generatedModulePath(moduleId);
            if (generatedModulePath.isPresent() && Files.exists(generatedModulePath.get().resolve("tests").resolve(module.document(documentId).name().split("tests/")[1]), new LinkOption[0])) {
                return Optional.of(generatedModulePath.get().resolve("tests").resolve(module.document(documentId).name().split("tests/")[1]));
            }
            if (!modulePath.isPresent()) continue;
            return Optional.of(modulePath.get().resolve("tests").resolve(module.document(documentId).name().split("tests/")[1]));
        }
        return Optional.empty();
    }

    @Override
    public void clearCaches() {
        this.resetPackage(this);
        this.projectEnvironment = ProjectEnvironmentBuilder.getDefaultBuilder().build(this);
    }

    @Override
    public Project duplicate() {
        BuildOptions duplicateBuildOptions = BuildOptions.builder().build().acceptTheirs(this.buildOptions());
        BuildProject buildProject = new BuildProject(ProjectEnvironmentBuilder.getDefaultBuilder(), this.sourceRoot, duplicateBuildOptions);
        return this.resetPackage(buildProject);
    }

    @Override
    public DocumentId documentId(Path file) {
        if (this.isFilePathInProject(file)) {
            Path parent = Optional.of(file.toAbsolutePath().getParent()).get();
            String parentFileName = Optional.of(parent.getFileName()).get().toString();
            boolean isDefaultModule = false;
            for (ModuleId moduleId : this.currentPackage().moduleIds()) {
                Path modulePath;
                String moduleDirName;
                if (!this.currentPackage().getDefaultModule().moduleId().equals(moduleId)) {
                    moduleDirName = this.currentPackage().module(moduleId).moduleName().toString().split(this.currentPackage().packageName().toString() + "\\.")[1];
                } else {
                    moduleDirName = Optional.of(this.sourceRoot.getFileName()).get().toString();
                    isDefaultModule = true;
                }
                Module module = this.currentPackage().module(moduleId);
                if (parentFileName.equals(moduleDirName) || isDefaultModule && "generated".equals(parentFileName)) {
                    for (DocumentId documentId : module.documentIds()) {
                        if (!module.document(documentId).name().equals(Optional.of(file.getFileName()).get().toString())) continue;
                        return documentId;
                    }
                    continue;
                }
                if (!"tests".equals(parentFileName) || !Optional.of((modulePath = Optional.of(parent.getParent()).get()).getFileName()).get().toString().equals(moduleDirName) && !Optional.of(Optional.of(modulePath.getParent()).get().getFileName()).get().toString().equals(moduleDirName)) continue;
                for (DocumentId documentId : module.testDocumentIds()) {
                    String[] splitName = module.document(documentId).name().split("tests/");
                    if (splitName.length <= 1 || !splitName[1].equals(Optional.of(file.getFileName()).get().toString())) continue;
                    return documentId;
                }
            }
        }
        throw new ProjectException("'" + file.toString() + "' does not belong to the current project");
    }

    private boolean isFilePathInProject(Path filepath) {
        try {
            ProjectPaths.packageRoot(filepath);
        }
        catch (ProjectException e) {
            return false;
        }
        return true;
    }

    @Override
    public void save() {
        Path buildFilePath = this.targetDir().resolve("build");
        boolean shouldUpdate = this.currentPackage().getResolution().autoUpdate();
        if (!buildFilePath.toFile().exists()) {
            BuildProject.createBuildFile(buildFilePath);
            this.writeBuildFile(buildFilePath);
            this.writeDependencies();
        } else {
            BuildJson buildJson = null;
            try {
                buildJson = ProjectUtils.readBuildJson(buildFilePath);
            }
            catch (JsonSyntaxException | IOException throwable) {
                // empty catch block
            }
            this.writeDependencies();
            if (buildJson != null && !shouldUpdate) {
                buildJson.setLastBuildTime(System.currentTimeMillis());
                Path projectPath = this.currentPackage().project().sourceRoot();
                HashMap<String, Long> lastModifiedTime = new HashMap<String, Long>();
                lastModifiedTime.put(this.currentPackage().packageName().value(), FileUtils.lastModifiedTimeOfBalProject(projectPath));
                buildJson.setLastModifiedTime(lastModifiedTime);
                BuildProject.writeBuildFile(buildFilePath, buildJson);
            } else {
                this.writeBuildFile(buildFilePath);
            }
        }
    }

    private void writeDependencies() {
        Package currentPackage = this.currentPackage();
        if (currentPackage != null) {
            Comparator comparator = (o1, o2) -> {
                if (o1.getOrg().equals(o2.getOrg())) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o1.getOrg().compareTo(o2.getOrg());
            };
            Comparator<ToolDependency> toolComparator = Comparator.comparing(ToolDependency::getId);
            List<Dependency> pkgDependencies = this.getPackageDependencies();
            pkgDependencies.sort(comparator);
            List<ToolDependency> toolDependencies = this.getToolDependencies();
            toolDependencies.sort(toolComparator);
            Path dependenciesTomlFile = currentPackage.project().sourceRoot().resolve("Dependencies.toml");
            String dependenciesContent = ProjectUtils.getDependenciesTomlContent(pkgDependencies, toolDependencies);
            if (!pkgDependencies.isEmpty()) {
                BuildProject.createIfNotExists(dependenciesTomlFile);
                BuildProject.writeContent(dependenciesTomlFile, dependenciesContent);
            } else if (dependenciesTomlFile.toFile().exists()) {
                BuildProject.writeContent(dependenciesTomlFile, dependenciesContent);
            }
        }
    }

    private List<Dependency> getPackageDependencies() {
        PackageResolution packageResolution = this.currentPackage().getResolution();
        ResolvedPackageDependency rootPkgNode = new ResolvedPackageDependency(this.currentPackage(), PackageDependencyScope.DEFAULT);
        DependencyGraph<ResolvedPackageDependency> dependencyGraph = packageResolution.dependencyGraph();
        Collection<ResolvedPackageDependency> directDependencies = dependencyGraph.getDirectDependencies(rootPkgNode);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Package rootPackage = rootPkgNode.packageInstance();
        Dependency rootPkgDependency = new Dependency(rootPackage.packageOrg().value(), rootPackage.packageName().value(), rootPackage.packageVersion().value().toString());
        ArrayList<Dependency.Module> rootPkgModules = new ArrayList<Dependency.Module>();
        for (ModuleId moduleId : rootPackage.moduleIds()) {
            Module module = rootPackage.module(moduleId);
            Dependency.Module depsModule = new Dependency.Module(module.descriptor().org().value(), module.descriptor().packageName().value(), module.descriptor().name().toString());
            rootPkgModules.add(depsModule);
        }
        rootPkgModules.sort(Comparator.comparing(Dependency.Module::moduleName));
        rootPkgDependency.setModules(rootPkgModules);
        rootPkgDependency.setDependencies(this.getTransitiveDependencies(dependencyGraph, rootPkgNode));
        rootPkgDependency.setTransitive(false);
        rootPkgDependency.setScope(rootPkgNode.scope());
        dependencies.add(rootPkgDependency);
        for (ResolvedPackageDependency directDependency : directDependencies) {
            Package aPackage = directDependency.packageInstance();
            Dependency dependency = new Dependency(aPackage.packageOrg().toString(), aPackage.packageName().value(), aPackage.packageVersion().toString());
            BalaFiles.DependencyGraphResult packageDependencyGraph = BalaFiles.createPackageDependencyGraph(directDependency.packageInstance().project().sourceRoot());
            Set<ModuleDescriptor> moduleDescriptors = packageDependencyGraph.moduleDependencies().keySet();
            ArrayList<Dependency.Module> modules = new ArrayList<Dependency.Module>();
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                Dependency.Module module = new Dependency.Module(moduleDescriptor.org().value(), moduleDescriptor.packageName().value(), moduleDescriptor.name().toString());
                modules.add(module);
            }
            modules.sort(Comparator.comparing(Dependency.Module::moduleName));
            dependency.setModules(modules);
            dependency.setDependencies(this.getTransitiveDependencies(dependencyGraph, directDependency));
            dependency.setScope(directDependency.scope());
            dependency.setTransitive(false);
            dependencies.add(dependency);
        }
        Collection<ResolvedPackageDependency> allDependencies = dependencyGraph.getNodes();
        for (ResolvedPackageDependency transDependency : allDependencies) {
            if (directDependencies.contains(transDependency) || transDependency.packageInstance() == this.currentPackage()) continue;
            Package aPackage = transDependency.packageInstance();
            Dependency dependency = new Dependency(aPackage.packageOrg().toString(), aPackage.packageName().value(), aPackage.packageVersion().toString());
            dependency.setDependencies(this.getTransitiveDependencies(dependencyGraph, transDependency));
            dependency.setScope(transDependency.scope());
            dependency.setTransitive(true);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private List<ToolDependency> getToolDependencies() {
        ArrayList<ToolDependency> toolDependencies = new ArrayList<ToolDependency>();
        BuildToolResolution buildToolResolution = this.currentPackage().getBuildToolResolution();
        if (buildToolResolution != null) {
            List<BuildTool> tools = buildToolResolution.getResolvedTools();
            for (BuildTool tool : tools) {
                ToolDependency toolDependency = new ToolDependency(tool.id().value(), tool.org().value(), tool.name().value(), tool.version().toString());
                toolDependencies.add(toolDependency);
            }
        }
        return toolDependencies;
    }

    private List<Dependency> getTransitiveDependencies(DependencyGraph<ResolvedPackageDependency> dependencyGraph, ResolvedPackageDependency directDependency) {
        ArrayList<Dependency> dependencyList = new ArrayList<Dependency>();
        Collection<ResolvedPackageDependency> pkgDependencies = dependencyGraph.getDirectDependencies(directDependency);
        for (ResolvedPackageDependency resolvedTransitiveDep : pkgDependencies) {
            Package dependencyPkgContext = resolvedTransitiveDep.packageInstance();
            Dependency dep = new Dependency(dependencyPkgContext.packageOrg().toString(), dependencyPkgContext.packageName().value(), dependencyPkgContext.packageVersion().toString());
            dependencyList.add(dep);
        }
        Comparator comparator = (o1, o2) -> {
            if (o1.getOrg().equals(o2.getOrg())) {
                return o1.getName().compareTo(o2.getName());
            }
            return o1.getOrg().compareTo(o2.getOrg());
        };
        dependencyList.sort(comparator);
        return dependencyList;
    }

    private static void createIfNotExists(Path filePath) {
        if (!filePath.toFile().exists()) {
            try {
                Files.createFile(filePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProjectException("Failed to create 'Dependencies.toml' file to write dependencies");
            }
        }
    }

    private static void writeContent(Path filePath, String content) {
        try {
            Files.write(filePath, Collections.singleton(content), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write dependencies to the 'Dependencies.toml' file");
        }
    }

    private static void createBuildFile(Path buildFilePath) {
        try {
            if (!buildFilePath.getParent().toFile().exists()) {
                Files.createDirectory(buildFilePath.getParent(), new FileAttribute[0]);
            }
            Files.createFile(buildFilePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to create 'build' file");
        }
    }

    private void writeBuildFile(Path buildFilePath) {
        Path projectPath = this.currentPackage().project().sourceRoot();
        HashMap<String, Long> lastModifiedTime = new HashMap<String, Long>();
        lastModifiedTime.put(this.currentPackage().packageName().value(), FileUtils.lastModifiedTimeOfBalProject(projectPath));
        BuildJson buildJson = new BuildJson(System.currentTimeMillis(), System.currentTimeMillis(), RepoUtils.getBallerinaShortVersion(), lastModifiedTime);
        BuildProject.writeBuildFile(buildFilePath, buildJson);
    }

    private static void writeBuildFile(Path buildFilePath, BuildJson buildJson) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!buildFilePath.toFile().canWrite()) {
            return;
        }
        try {
            Files.write(buildFilePath, Collections.singleton(gson.toJson((Object)buildJson)), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Path targetDir() {
        if (this.buildOptions().getTargetPath() == null) {
            return this.sourceRoot.resolve("target");
        }
        return Path.of(this.buildOptions().getTargetPath(), new String[0]);
    }

    @Override
    public Path generatedResourcesDir() {
        Path generatedResourcesPath = this.targetDir().resolve("resources");
        if (!Files.exists(generatedResourcesPath, new LinkOption[0])) {
            try {
                Files.createDirectories(generatedResourcesPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return generatedResourcesPath;
    }
}

