/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.environment;

import io.ballerina.projects.DependencyResolutionType;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageOrg;
import io.ballerina.tools.diagnostics.Location;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ModuleLoadRequest {
    private final PackageOrg orgName;
    private final String moduleName;
    private final PackageDependencyScope scope;
    private final DependencyResolutionType dependencyResolvedType;
    private final Set<Location> locations;

    public ModuleLoadRequest(PackageOrg orgName, String moduleName, PackageDependencyScope scope, DependencyResolutionType dependencyResolvedType) {
        this.orgName = orgName;
        this.moduleName = moduleName;
        this.scope = scope;
        this.dependencyResolvedType = dependencyResolvedType;
        this.locations = Collections.emptySet();
    }

    public ModuleLoadRequest(PackageOrg orgName, String moduleName, PackageDependencyScope scope, DependencyResolutionType dependencyResolvedType, Location location) {
        this.orgName = orgName;
        this.moduleName = moduleName;
        this.scope = scope;
        this.dependencyResolvedType = dependencyResolvedType;
        this.locations = Collections.singleton(location);
    }

    public ModuleLoadRequest(PackageOrg orgName, String moduleName, PackageDependencyScope scope, DependencyResolutionType dependencyResolvedType, Set<Location> locations) {
        this.orgName = orgName;
        this.moduleName = moduleName;
        this.scope = scope;
        this.dependencyResolvedType = dependencyResolvedType;
        this.locations = Collections.unmodifiableSet(locations);
    }

    public Optional<PackageOrg> orgName() {
        return Optional.ofNullable(this.orgName);
    }

    public String moduleName() {
        return this.moduleName;
    }

    public PackageDependencyScope scope() {
        return this.scope;
    }

    public DependencyResolutionType dependencyResolvedType() {
        return this.dependencyResolvedType;
    }

    public boolean injected() {
        return this.dependencyResolvedType == DependencyResolutionType.PLATFORM_PROVIDED;
    }

    public Set<Location> locations() {
        return this.locations;
    }

    public void addAllLocations(Set<Location> locations) {
        this.locations.addAll(locations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleLoadRequest that = (ModuleLoadRequest)o;
        return Objects.equals(this.orgName, that.orgName) && this.moduleName.equals(that.moduleName);
    }

    public int hashCode() {
        return Objects.hash(this.orgName, this.moduleName);
    }
}

