/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.internal.PackageContainer;
import io.ballerina.projects.internal.PackageVersionContainer;
import io.ballerina.projects.internal.ResolutionEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;

public final class DotGraphs {
    private static final Comparator<ResolutionEngine.DependencyNode> packageVersionComparator = (depNode1, depNode2) -> {
        PackageVersion latest;
        boolean isV2PreReleaseVersion;
        PackageVersion v1 = depNode1.pkgDesc().version();
        PackageVersion v2 = depNode2.pkgDesc().version();
        SemanticVersion semVer1 = v1.value();
        SemanticVersion semVer2 = v2.value();
        boolean isV1PreReleaseVersion = semVer1.isPreReleaseVersion();
        if (isV1PreReleaseVersion ^ (isV2PreReleaseVersion = semVer2.isPreReleaseVersion())) {
            latest = isV1PreReleaseVersion ? v2 : v1;
        } else {
            PackageVersion packageVersion = latest = semVer1.greaterThanOrEqualTo(semVer2) ? v1 : v2;
        }
        if (v1 == latest) {
            return 1;
        }
        return -1;
    };

    private DotGraphs() {
    }

    public static String serializeResolvedPackageDependencyGraph(DependencyGraph<ResolvedPackageDependency> dependencyGraph) {
        return DotGraphs.serializeDependencyNodeGraph(DotGraphs.toDependencyNodeGraph(dependencyGraph), Collections.emptyList());
    }

    public static String serializeDependencyNodeGraph(DependencyGraph<ResolutionEngine.DependencyNode> dependencyGraph, Collection<ResolutionEngine.DependencyNode> unresolvedNodes) {
        return DotGraphs.serializeDependencyNodeGraph(dependencyGraph, DotGraphs.getGraphName(dependencyGraph), unresolvedNodes);
    }

    public static String serializeDependencyNodeGraph(DependencyGraph<ResolutionEngine.DependencyNode> dependencyGraph, Collection<ResolutionEngine.DependencyNode> unresolvedNodes, Collection<ResolutionEngine.DependencyNode> missingDirectDeps) {
        return DotGraphs.serializeDependencyNodeGraph(dependencyGraph, DotGraphs.getGraphName(dependencyGraph), unresolvedNodes, missingDirectDeps);
    }

    public static String serializeDependencyNodeGraph(DependencyGraph<ResolutionEngine.DependencyNode> dependencyGraph, String graphName, Collection<ResolutionEngine.DependencyNode> unresolvedNodes) {
        return DotGraphs.serializeDependencyNodeGraph(dependencyGraph, graphName, unresolvedNodes, Collections.emptyList());
    }

    public static String serializeDependencyNodeGraph(DependencyGraph<ResolutionEngine.DependencyNode> dependencyGraph, String graphName, Collection<ResolutionEngine.DependencyNode> unresolvedNodes, Collection<ResolutionEngine.DependencyNode> missingDirectDeps) {
        PackageDescriptor pkgDesc;
        PackageVersionContainer<ResolutionEngine.DependencyNode> pkgContainer = new PackageVersionContainer<ResolutionEngine.DependencyNode>();
        for (ResolutionEngine.DependencyNode missingDirectDep : missingDirectDeps) {
            pkgDesc = missingDirectDep.pkgDesc();
            pkgContainer.add(pkgDesc.org(), pkgDesc.name(), pkgDesc.version(), missingDirectDep);
        }
        for (ResolutionEngine.DependencyNode depNode : dependencyGraph.getNodes()) {
            pkgDesc = depNode.pkgDesc();
            if (pkgDesc.isLangLibPackage()) continue;
            pkgContainer.add(pkgDesc.org(), pkgDesc.name(), pkgDesc.version(), depNode);
        }
        String firstLine = DotGraphs.getFirstLine(graphName);
        String lastLine = "}";
        StringJoiner edges = new StringJoiner("\n\t", "\n\t// Edges\n\t", "\n");
        StringJoiner nodes = new StringJoiner("\n\t", "\t", "\n");
        PackageContainer<ResolutionEngine.DependencyNode> visitedNodes = new PackageContainer<ResolutionEngine.DependencyNode>();
        ArrayList<ResolutionEngine.DependencyNode> sortedList = new ArrayList<ResolutionEngine.DependencyNode>(dependencyGraph.toTopologicallySortedList());
        for (ResolutionEngine.DependencyNode missingDirectDep : missingDirectDeps) {
            sortedList.add(sortedList.indexOf(dependencyGraph.getRoot()), missingDirectDep);
        }
        for (int i = sortedList.size() - 1; i >= 0; --i) {
            ResolutionEngine.DependencyNode depNode = (ResolutionEngine.DependencyNode)sortedList.get(i);
            if (depNode.pkgDesc().isLangLibPackage()) continue;
            Collection<ResolutionEngine.DependencyNode> directDependencies = dependencyGraph.getDirectDependencies(depNode);
            if (depNode.equals(dependencyGraph.getRoot())) {
                directDependencies.addAll(missingDirectDeps);
            }
            for (ResolutionEngine.DependencyNode directDep : directDependencies) {
                if (directDep.pkgDesc().isLangLibPackage()) continue;
                edges.add(DotGraphs.getEdgeLine(depNode, directDep));
            }
            if (visitedNodes.contains(depNode.pkgDesc().org(), depNode.pkgDesc().name())) continue;
            visitedNodes.add(depNode.pkgDesc().org(), depNode.pkgDesc().name(), depNode);
            nodes.add(DotGraphs.getNodeLine(depNode, pkgContainer, unresolvedNodes.contains(depNode)));
        }
        return firstLine + nodes.toString() + edges.toString() + lastLine;
    }

    private static String getGraphName(DependencyGraph<ResolutionEngine.DependencyNode> dependencyGraph) {
        ResolutionEngine.DependencyNode graphRoot = dependencyGraph.getRoot();
        if (graphRoot != null) {
            return graphRoot.pkgDesc().toString();
        }
        return "app";
    }

    private static String getFirstLine(String graphName) {
        return "digraph \"" + graphName + "\" {\n\tnode [shape=record]\n";
    }

    private static String getEdgeLine(ResolutionEngine.DependencyNode fromNode, ResolutionEngine.DependencyNode toNode) {
        return DotGraphs.getNodeLabelInEdge(fromNode.pkgDesc()) + " -> " + DotGraphs.getNodeLabelInEdge(toNode.pkgDesc()) + ";";
    }

    private static String getNodeLabelInEdge(PackageDescriptor pkgDesc) {
        return DotGraphs.getNodeLabel(pkgDesc) + (String)(pkgDesc.version() != null ? ":\"" + String.valueOf(pkgDesc.version()) + "\"" : "");
    }

    private static String getNodeLabel(PackageDescriptor pkgDesc) {
        return "\"" + String.valueOf(pkgDesc.org()) + "/" + String.valueOf(pkgDesc.name()) + "\"";
    }

    private static String getNodeLine(ResolutionEngine.DependencyNode depNode, PackageVersionContainer<ResolutionEngine.DependencyNode> pkgContainer, boolean isUnresolved) {
        StringJoiner attrs = new StringJoiner(",", DotGraphs.getNodeLabel(depNode.pkgDesc()) + " [", "];");
        String labelAttr = DotGraphs.getNodeLabelAttr(depNode, pkgContainer);
        if (DotGraphs.getScope(depNode, pkgContainer) == PackageDependencyScope.TEST_ONLY) {
            attrs.add(DotGraphs.getTestOnlyNodeLine(depNode));
        } else if (depNode.pkgDesc().repository().isPresent()) {
            attrs.add(DotGraphs.getLocalRepoNodeLine());
        }
        if (depNode.errorNode()) {
            attrs.add(DotGraphs.getErrorNodeLine());
        } else if (isUnresolved) {
            attrs.add(DotGraphs.getUnresolvedNodeLine());
            attrs.add(DotGraphs.addColorLine("grey"));
        }
        attrs.add(labelAttr);
        return attrs.toString();
    }

    private static PackageDependencyScope getScope(ResolutionEngine.DependencyNode depNode, PackageVersionContainer<ResolutionEngine.DependencyNode> pkgContainer) {
        PackageDescriptor pkgDesc = depNode.pkgDesc();
        Collection<ResolutionEngine.DependencyNode> depNodes = pkgContainer.get(pkgDesc.org(), pkgDesc.name());
        for (ResolutionEngine.DependencyNode node : depNodes) {
            if (node.scope() != PackageDependencyScope.DEFAULT) continue;
            return PackageDependencyScope.DEFAULT;
        }
        return PackageDependencyScope.TEST_ONLY;
    }

    private static String getNodeLabelAttr(ResolutionEngine.DependencyNode depNode, PackageVersionContainer<ResolutionEngine.DependencyNode> pkgContainer) {
        PackageDescriptor pkgDesc = depNode.pkgDesc();
        Collection<ResolutionEngine.DependencyNode> unSortedDepNodes = pkgContainer.get(pkgDesc.org(), pkgDesc.name());
        List<ResolutionEngine.DependencyNode> sortedDepNodes = DotGraphs.sortVersions(unSortedDepNodes);
        StringJoiner labelAttr = new StringJoiner(" | ", "label=\"", "\"");
        for (ResolutionEngine.DependencyNode sortedDepNode : sortedDepNodes) {
            String version = sortedDepNode.pkgDesc().version() == null ? "" : "<" + String.valueOf(sortedDepNode.pkgDesc().version()) + "> ";
            labelAttr.add(version + String.valueOf(sortedDepNode.pkgDesc()));
        }
        return labelAttr.toString();
    }

    private static List<ResolutionEngine.DependencyNode> sortVersions(Collection<ResolutionEngine.DependencyNode> depNodes) {
        ArrayList<ResolutionEngine.DependencyNode> sortedList = new ArrayList<ResolutionEngine.DependencyNode>(depNodes);
        sortedList.sort(packageVersionComparator);
        return sortedList;
    }

    private static String getTestOnlyNodeLine(ResolutionEngine.DependencyNode node) {
        if (node.pkgDesc().repository().isPresent()) {
            return "scope=\"" + node.scope().getValue() + "\", repo=\"local\"";
        }
        return "scope=\"" + node.scope().getValue() + "\"";
    }

    private static String getLocalRepoNodeLine() {
        return "repo=\"local\"";
    }

    private static String getErrorNodeLine() {
        return "error=\"true\"";
    }

    private static String getUnresolvedNodeLine() {
        return "unresolved=\"true\"";
    }

    private static String addColorLine(String color) {
        return "color=\"" + color + "\"";
    }

    private static DependencyGraph<ResolutionEngine.DependencyNode> toDependencyNodeGraph(DependencyGraph<ResolvedPackageDependency> dependencyGraph) {
        ResolutionEngine.DependencyNode rootNode = DotGraphs.toDependencyNode(dependencyGraph.getRoot());
        DependencyGraph.DependencyGraphBuilder<ResolutionEngine.DependencyNode> graphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder(rootNode);
        for (ResolvedPackageDependency resPkgNode : dependencyGraph.getNodes()) {
            ResolutionEngine.DependencyNode depNode = DotGraphs.toDependencyNode(resPkgNode);
            for (ResolvedPackageDependency resPkgDirectDep : dependencyGraph.getDirectDependencies(resPkgNode)) {
                ResolutionEngine.DependencyNode depNodeDirectDep = DotGraphs.toDependencyNode(resPkgDirectDep);
                graphBuilder.addDependency(depNode, depNodeDirectDep);
            }
        }
        return graphBuilder.build();
    }

    private static ResolutionEngine.DependencyNode toDependencyNode(ResolvedPackageDependency resPkgDep) {
        return new ResolutionEngine.DependencyNode(resPkgDep.packageInstance().descriptor(), resPkgDep.scope(), resPkgDep.dependencyResolvedType());
    }
}

