/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.environment.ModuleLoadRequest;
import java.util.List;
import java.util.Objects;

public class ImportModuleRequest {
    private final PackageOrg packageOrg;
    private final String moduleName;
    private final List<PackageDescriptor> possiblePackages;
    private ModuleLoadRequest moduleLoadRequest;

    public ImportModuleRequest(PackageOrg packageOrg, String moduleName) {
        this.packageOrg = packageOrg;
        this.moduleName = moduleName;
        this.possiblePackages = null;
    }

    public ImportModuleRequest(PackageOrg packageOrg, String moduleName, List<PackageDescriptor> possiblePackages) {
        this.packageOrg = packageOrg;
        this.moduleName = moduleName;
        this.possiblePackages = possiblePackages;
    }

    public ImportModuleRequest(PackageOrg packageOrg, ModuleLoadRequest moduleLoadRequest) {
        this.packageOrg = packageOrg;
        this.moduleName = moduleLoadRequest.moduleName();
        this.moduleLoadRequest = moduleLoadRequest;
        this.possiblePackages = null;
    }

    public ImportModuleRequest(PackageOrg packageOrg, ModuleLoadRequest moduleLoadRequest, List<PackageDescriptor> possiblePackages) {
        this.packageOrg = packageOrg;
        this.moduleName = moduleLoadRequest.moduleName();
        this.moduleLoadRequest = moduleLoadRequest;
        this.possiblePackages = possiblePackages;
    }

    public PackageOrg packageOrg() {
        return this.packageOrg;
    }

    public String moduleName() {
        return this.moduleName;
    }

    public ModuleLoadRequest moduleLoadRequest() {
        return this.moduleLoadRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportModuleRequest that = (ImportModuleRequest)o;
        return this.packageOrg.equals(that.packageOrg) && this.moduleName.equals(that.moduleName);
    }

    public int hashCode() {
        return Objects.hash(this.packageOrg, this.moduleName);
    }

    public List<PackageDescriptor> possiblePackages() {
        return this.possiblePackages;
    }
}

