/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class PackageDiagnostic
extends Diagnostic {
    protected Diagnostic diagnostic;
    protected Location location;
    protected Project project;
    protected ModuleDescriptor moduleDescriptor;

    public PackageDiagnostic(DiagnosticInfo diagnosticInfo, Location location) {
        this.diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
        this.location = location;
    }

    public PackageDiagnostic(DiagnosticInfo diagnosticInfo, String filePath) {
        this(diagnosticInfo, new NullLocation(filePath));
    }

    public PackageDiagnostic(Diagnostic diagnostic, ModuleDescriptor moduleDescriptor, Project project) {
        String filePath;
        ModuleName moduleName = moduleDescriptor.name();
        String diagnosticPath = diagnostic.location().lineRange().filePath();
        Path modulesRoot = Path.of("modules", new String[0]);
        if (project.kind().equals((Object)ProjectKind.BALA_PROJECT)) {
            Path modulePath = modulesRoot.resolve(moduleName.toString());
            filePath = project.sourceRoot().resolve(modulePath).resolve(diagnosticPath).toString();
        } else {
            Path generatedRoot = Path.of("generated", new String[0]);
            if (!moduleName.isDefaultModuleName()) {
                Path generatedPath = generatedRoot.resolve(moduleName.moduleNamePart());
                filePath = Files.exists(project.sourceRoot().resolve(generatedPath).resolve(diagnosticPath).toAbsolutePath(), new LinkOption[0]) ? generatedPath.resolve(diagnosticPath).toString() : modulesRoot.resolve(moduleName.moduleNamePart()).resolve(diagnosticPath).toString();
            } else {
                filePath = Files.exists(project.sourceRoot().resolve(generatedRoot).resolve(diagnosticPath).toAbsolutePath(), new LinkOption[0]) ? generatedRoot.resolve(diagnosticPath).toString() : diagnosticPath;
            }
        }
        this.diagnostic = diagnostic;
        this.project = project;
        this.moduleDescriptor = moduleDescriptor;
        this.location = new DiagnosticLocation(filePath, this.diagnostic.location());
    }

    public Location location() {
        return this.location;
    }

    public DiagnosticInfo diagnosticInfo() {
        return this.diagnostic.diagnosticInfo();
    }

    public String message() {
        return this.diagnostic.message();
    }

    public List<DiagnosticProperty<?>> properties() {
        return this.diagnostic.properties();
    }

    public String toString() {
        Object filePath = this.location.lineRange().filePath();
        if (this.project != null && ProjectKind.BALA_PROJECT.equals((Object)this.project.kind())) {
            filePath = String.valueOf(this.moduleDescriptor.org()) + "/" + this.moduleDescriptor.name().toString() + "/" + String.valueOf(this.moduleDescriptor.version()) + "::" + String.valueOf(Optional.of(Path.of((String)filePath, new String[0]).getFileName()).get());
        }
        if (this.diagnostic.location() instanceof NullLocation) {
            return this.diagnosticInfo().severity().toString() + " [" + (String)filePath + "] " + this.diagnosticInfo().messageFormat();
        }
        LineRange lineRange = this.diagnostic.location().lineRange();
        LineRange oneBasedLineRange = LineRange.from((String)filePath, (LinePosition)LinePosition.from((int)(lineRange.startLine().line() + 1), (int)(lineRange.startLine().offset() + 1)), (LinePosition)LinePosition.from((int)(lineRange.endLine().line() + 1), (int)(lineRange.endLine().offset() + 1)));
        return this.diagnosticInfo().severity().toString() + " [" + (String)filePath + ":" + String.valueOf(oneBasedLineRange) + "] " + this.message();
    }

    private static class NullLocation
    implements Location {
        private final String filepath;

        NullLocation(String filePath) {
            this.filepath = filePath;
        }

        public LineRange lineRange() {
            LinePosition from = LinePosition.from((int)0, (int)0);
            return LineRange.from((String)this.filepath, (LinePosition)from, (LinePosition)from);
        }

        public TextRange textRange() {
            return TextRange.from((int)0, (int)0);
        }
    }

    private static class DiagnosticLocation
    implements Location {
        private final LineRange lineRange;
        private final TextRange textRange;

        public DiagnosticLocation(String filePath, Location location) {
            LineRange lineRange = location.lineRange();
            int startLine = lineRange.startLine().line();
            int endLine = lineRange.endLine().line();
            int startColumn = lineRange.startLine().offset();
            int endColumn = lineRange.endLine().offset();
            filePath = filePath.replace("tests/", "tests" + File.separator);
            this.lineRange = LineRange.from((String)filePath, (LinePosition)LinePosition.from((int)startLine, (int)startColumn), (LinePosition)LinePosition.from((int)endLine, (int)endColumn));
            this.textRange = location.textRange();
        }

        public LineRange lineRange() {
            return this.lineRange;
        }

        public TextRange textRange() {
            return this.textRange;
        }

        public String toString() {
            return this.lineRange.toString() + this.textRange.toString();
        }
    }
}

