/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.exceptions.InvalidBalaException;
import io.ballerina.projects.internal.DocumentData;
import io.ballerina.projects.internal.ManifestBuilder;
import io.ballerina.projects.internal.ModuleData;
import io.ballerina.projects.internal.PackageData;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ProjectFiles {
    public static final PathMatcher BAL_EXTENSION_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.bal");
    public static final PathMatcher BALA_EXTENSION_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.bala");
    private static final PrintStream outStream = System.out;

    private ProjectFiles() {
    }

    public static PackageData loadSingleFileProjectPackageData(Path filePath) {
        DocumentData documentData = ProjectFiles.loadDocument(filePath);
        ModuleData defaultModule = ModuleData.from(filePath, ".", Collections.singletonList(documentData), Collections.emptyList(), null);
        return PackageData.from(filePath, defaultModule, Collections.emptyList(), null, null, null, null, null, null, Collections.emptyList(), Collections.emptyList());
    }

    public static PackageData loadBuildProjectPackageData(Path packageDirPath) {
        ModuleData defaultModule = ProjectFiles.loadModule(packageDirPath);
        List<ModuleData> otherModules = ProjectFiles.loadOtherModules(packageDirPath);
        List<ModuleData> newModules = ProjectFiles.loadNewGeneratedModules(packageDirPath);
        otherModules = Stream.concat(otherModules.stream(), newModules.stream()).toList();
        DocumentData ballerinaToml = ProjectFiles.loadDocument(packageDirPath.resolve("Ballerina.toml"));
        DocumentData dependenciesToml = ProjectFiles.loadDocument(packageDirPath.resolve("Dependencies.toml"));
        DocumentData cloudToml = ProjectFiles.loadDocument(packageDirPath.resolve("Cloud.toml"));
        DocumentData compilerPluginToml = ProjectFiles.loadDocument(packageDirPath.resolve("CompilerPlugin.toml"));
        DocumentData balToolToml = ProjectFiles.loadDocument(packageDirPath.resolve("BalTool.toml"));
        DocumentData packageMd = ProjectFiles.loadDocument(packageDirPath.resolve("Package.md"));
        List<Path> resources = ProjectFiles.loadResources(packageDirPath);
        List<Path> generatedResources = ProjectFiles.loadResources(packageDirPath.resolve("generated"));
        if (!generatedResources.isEmpty()) {
            resources.addAll(generatedResources);
        }
        List<Path> testResources = ProjectFiles.loadResources(packageDirPath.resolve("tests"));
        List<Path> generatedTestResources = ProjectFiles.loadResources(packageDirPath.resolve("generated").resolve("tests"));
        if (!generatedTestResources.isEmpty()) {
            testResources.addAll(generatedTestResources);
        }
        return PackageData.from(packageDirPath, defaultModule, otherModules, ballerinaToml, dependenciesToml, cloudToml, compilerPluginToml, balToolToml, packageMd, resources, testResources);
    }

    private static List<ModuleData> loadNewGeneratedModules(Path packageDirPath) {
        Path generatedSourceRoot = packageDirPath.resolve("generated");
        if (Files.isDirectory(generatedSourceRoot, new LinkOption[0])) {
            List<ModuleData> list;
            block9: {
                Stream<Path> pathStream = Files.walk(generatedSourceRoot, 1, new FileVisitOption[0]);
                try {
                    list = pathStream.filter(path -> !"generated".equals(path.toFile().getName())).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> ProjectFiles.isNewModule(packageDirPath, path)).filter(path -> {
                        if (!ProjectUtils.validateModuleName(path.toFile().getName())) {
                            throw new ProjectException("Invalid module name : '" + String.valueOf(path.getFileName()) + "' :\nModule name can only contain alphanumerics, underscores and periods");
                        }
                        if (!ProjectUtils.validateNameLength(path.toFile().getName())) {
                            throw new ProjectException("Invalid module name : '" + String.valueOf(path.getFileName()) + "' :\nMaximum length of module name is 256 characters");
                        }
                        return true;
                    }).map(ProjectFiles::loadModule).toList();
                    if (pathStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (pathStream != null) {
                            try {
                                pathStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ProjectException(e);
                    }
                }
                pathStream.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    private static boolean isNewModule(Path packageDirPath, Path path) {
        String dirName = path.toFile().getName();
        if (dirName.equals("tests") || dirName.equals("resources")) {
            return false;
        }
        Path modulePath = packageDirPath.resolve("modules").resolve(dirName);
        return !Files.exists(modulePath, new LinkOption[0]);
    }

    private static List<ModuleData> loadOtherModules(Path packageDirPath) {
        List<ModuleData> list;
        block9: {
            Path modulesDirPath = packageDirPath.resolve("modules");
            if (!Files.isDirectory(modulesDirPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> pathStream = Files.walk(modulesDirPath, 1, new FileVisitOption[0]);
            try {
                list = pathStream.filter(path -> !path.equals(modulesDirPath)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> {
                    if (!ProjectUtils.validateModuleName(path.toFile().getName())) {
                        throw new ProjectException("Invalid module name : '" + String.valueOf(path.getFileName()) + "' :\nModule name can only contain alphanumerics, underscores and periods");
                    }
                    if (!ProjectUtils.validateNameLength(path.toFile().getName())) {
                        throw new ProjectException("Invalid module name : '" + String.valueOf(path.getFileName()) + "' :\nMaximum length of module name is 256 characters");
                    }
                    return true;
                }).map(ProjectFiles::loadModule).collect(Collectors.toList());
                if (pathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    private static ModuleData loadModule(Path moduleDirPath) {
        List<Path> moduleResources;
        Path generatedSourcesRoot;
        ArrayList<DocumentData> testSrcDocs;
        List<DocumentData> srcDocs = ProjectFiles.loadDocuments(moduleDirPath);
        Path testDirPath = moduleDirPath.resolve("tests");
        ArrayList<DocumentData> arrayList = testSrcDocs = Files.isDirectory(testDirPath, new LinkOption[0]) ? ProjectFiles.loadTestDocuments(testDirPath) : new ArrayList<DocumentData>();
        if (!"generated".equals(Optional.of(moduleDirPath.toAbsolutePath().getParent()).get().toFile().getName()) && Files.isDirectory(generatedSourcesRoot = ProjectFiles.getGeneratedSourcesRoot(moduleDirPath), new LinkOption[0])) {
            List<DocumentData> generatedDocs = ProjectFiles.loadDocuments(generatedSourcesRoot);
            ProjectFiles.verifyDuplicateNames(srcDocs, generatedDocs, moduleDirPath.toFile().getName(), moduleDirPath, false);
            srcDocs.addAll(generatedDocs);
            if (Files.isDirectory(generatedSourcesRoot.resolve("tests"), new LinkOption[0])) {
                List<DocumentData> generatedTestDocs = ProjectFiles.loadTestDocuments(generatedSourcesRoot.resolve("tests"));
                ProjectFiles.verifyDuplicateNames(testSrcDocs, generatedTestDocs, moduleDirPath.toFile().getName(), moduleDirPath, true);
                testSrcDocs.addAll(generatedTestDocs);
            }
        }
        DocumentData moduleMd = ProjectFiles.loadDocument(moduleDirPath.resolve("Module.md"));
        Path parentPath = moduleDirPath.getParent();
        if (parentPath != null && "modules".equals(parentPath.toFile().getName()) && !(moduleResources = ProjectFiles.loadResources(moduleDirPath)).isEmpty()) {
            String warning = "WARNING: module-level resources are not supported. Relocate the module-level resources detected in '" + moduleDirPath.toFile().getName() + "' to the package resources path. Resource files:\n" + moduleResources.stream().map(Path::toString).collect(Collectors.joining("\n")) + "\n";
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.DEPRECATED_RESOURCES_STRUCTURE.diagnosticId(), warning, DiagnosticSeverity.WARNING);
            PackageDiagnostic packageDiagnostic = new PackageDiagnostic(diagnosticInfo, "");
            ProjectUtils.addMiscellaneousProjectDiagnostics(packageDiagnostic);
        }
        return ModuleData.from(moduleDirPath, moduleDirPath.toFile().getName(), srcDocs, testSrcDocs, moduleMd);
    }

    private static Path getGeneratedSourcesRoot(Path moduleDirPath) {
        Path generatedSourcesRoot = moduleDirPath.resolve("generated");
        if ("modules".equals(Optional.of(moduleDirPath.toAbsolutePath().getParent()).get().toFile().getName())) {
            generatedSourcesRoot = Optional.of(Optional.of(Optional.of(moduleDirPath.toAbsolutePath().getParent()).get().getParent()).get().resolve("generated")).get().resolve(Optional.of(moduleDirPath.toFile()).get().getName());
        }
        return generatedSourcesRoot;
    }

    private static void verifyDuplicateNames(List<DocumentData> srcDocs, List<DocumentData> generatedDocs, String moduleName, Path modulesDirPath, boolean isTestDocs) {
        for (DocumentData doc : srcDocs) {
            generatedDocs.forEach(generatedDoc -> {
                if (doc.name().equals(generatedDoc.name())) {
                    if (isTestDocs) {
                        throw new ProjectException("Test source file with a duplicate name '" + doc.name() + "' detected in both generated and module tests for the module '" + moduleName + "'. Please provide a unique name for '" + String.valueOf(modulesDirPath.resolve("tests").resolve(doc.name())) + "'");
                    }
                    throw new ProjectException("Source file with a duplicate name '" + doc.name() + "' detected in both generated and module sources for the module '" + moduleName + "'. Please provide a unique name for '" + String.valueOf(modulesDirPath.resolve(doc.name())) + "'");
                }
            });
        }
    }

    public static List<Path> loadResources(Path packagePath) {
        List<Path> list;
        block11: {
            Path resourcesPath = packagePath.resolve("resources");
            if (Files.notExists(resourcesPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            try {
                ProjectUtils.checkReadPermission(packagePath);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            Stream<Path> pathStream = Files.walk(resourcesPath, 10, new FileVisitOption[0]);
            try {
                list = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
                if (pathStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    public static List<DocumentData> loadDocuments(Path dirPath) {
        List<DocumentData> list;
        block10: {
            try {
                ProjectUtils.checkReadPermission(dirPath);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            Stream<Path> pathStream = Files.walk(dirPath, 1, new FileVisitOption[0]);
            try {
                list = pathStream.filter(BAL_EXTENSION_MATCHER::matches).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(ProjectFiles::loadDocument).collect(Collectors.toList());
                if (pathStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    private static List<DocumentData> loadTestDocuments(Path dirPath) {
        List<DocumentData> list;
        block10: {
            try {
                ProjectUtils.checkReadPermission(dirPath);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            Stream<Path> pathStream = Files.walk(dirPath, 1, new FileVisitOption[0]);
            try {
                list = pathStream.filter(BAL_EXTENSION_MATCHER::matches).map(ProjectFiles::loadTestDocument).collect(Collectors.toList());
                if (pathStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    public static DocumentData loadDocument(Path documentFilePath) {
        String content;
        if (Files.notExists(documentFilePath, new LinkOption[0])) {
            return null;
        }
        try {
            ProjectUtils.checkReadPermission(documentFilePath);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            content = Files.readString(documentFilePath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ProjectException(e);
        }
        return DocumentData.from(Optional.of(documentFilePath.getFileName()).get().toString(), content);
    }

    private static DocumentData loadTestDocument(Path documentFilePath) {
        String content;
        try {
            ProjectUtils.checkReadPermission(documentFilePath);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            content = Files.readString(documentFilePath, Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new ProjectException(e);
        }
        String documentName = Optional.of(documentFilePath.getFileName()).get().toString();
        return DocumentData.from("tests/" + documentName, content);
    }

    public static BuildOptions createBuildOptions(PackageConfig packageConfig, BuildOptions theirOptions, Path projectDirPath) {
        TomlDocument balToolToml;
        TomlDocument pluginToml;
        TomlDocument ballerinaToml = TomlDocument.from("Ballerina.toml", packageConfig.ballerinaToml().map(DocumentConfig::content).orElse(""));
        ManifestBuilder manifestBuilder = ManifestBuilder.from(ballerinaToml, pluginToml = TomlDocument.from("CompilerPlugin.toml", packageConfig.dependenciesToml().map(DocumentConfig::content).orElse("")), balToolToml = TomlDocument.from("BalTool.toml", packageConfig.balToolToml().map(DocumentConfig::content).orElse("")), projectDirPath);
        BuildOptions defaultBuildOptions = manifestBuilder.buildOptions();
        if (defaultBuildOptions == null) {
            defaultBuildOptions = BuildOptions.builder().build();
        }
        return defaultBuildOptions.acceptTheirs(theirOptions);
    }

    public static void validateBuildProjectDirPath(Path projectDirPath) {
        if (Files.notExists(projectDirPath, new LinkOption[0])) {
            throw new ProjectException("The directory does not exist: " + String.valueOf(projectDirPath));
        }
        if (!Files.isDirectory(projectDirPath, new LinkOption[0])) {
            throw new ProjectException("Invalid Ballerina package directory: " + String.valueOf(projectDirPath));
        }
        if (!ProjectUtils.isBallerinaProject(projectDirPath)) {
            throw new ProjectException("Invalid Ballerina package directory: " + String.valueOf(projectDirPath) + ", cannot find 'Ballerina.toml' file.");
        }
        if (ProjectUtils.findProjectRoot(projectDirPath.toAbsolutePath().getParent()) != null) {
            throw new ProjectException("'" + String.valueOf(projectDirPath) + "' is already within a Ballerina package");
        }
        ProjectUtils.checkReadPermission(projectDirPath);
    }

    public static void validateSingleFileProjectFilePath(Path filePath) {
        if (Files.notExists(filePath, new LinkOption[0])) {
            throw new ProjectException("The file does not exist: " + String.valueOf(filePath));
        }
        if (!Files.isRegularFile(filePath, new LinkOption[0]) || !BAL_EXTENSION_MATCHER.matches(filePath)) {
            throw new ProjectException("Invalid Ballerina source file(.bal): " + String.valueOf(filePath));
        }
        Path projectRoot = ProjectUtils.findProjectRoot(filePath);
        if (null != projectRoot) {
            Path absFilePath = filePath.toAbsolutePath();
            if (projectRoot.equals(absFilePath.getParent())) {
                throw new ProjectException("The source file '" + String.valueOf(filePath) + "' belongs to a Ballerina package.");
            }
            Path modulesRoot = projectRoot.resolve("modules");
            Path parent = absFilePath.getParent();
            if (parent != null && modulesRoot.equals(parent.getParent())) {
                throw new ProjectException("The source file '" + String.valueOf(filePath) + "' belongs to a Ballerina package.");
            }
        }
        ProjectUtils.checkReadPermission(filePath);
    }

    public static void validateBalaProjectPath(Path balaPath) {
        if (Files.notExists(balaPath, new LinkOption[0])) {
            throw new ProjectException("Given bala path does not exist: " + String.valueOf(balaPath));
        }
        if (!ProjectFiles.isValidBalaFile(balaPath) && !ProjectFiles.isValidBalaDir(balaPath)) {
            throw new InvalidBalaException("invalid bala file: " + String.valueOf(balaPath));
        }
        if (!balaPath.toFile().canRead()) {
            throw new ProjectException("insufficient privileges to bala: " + String.valueOf(balaPath));
        }
    }

    private static boolean isValidBalaDir(Path balaPath) {
        if (Files.notExists(balaPath.resolve("dependency-graph.json"), new LinkOption[0])) {
            return false;
        }
        if (Files.notExists(balaPath.resolve("package.json"), new LinkOption[0])) {
            return false;
        }
        if (Files.notExists(balaPath.resolve("bala.json"), new LinkOption[0])) {
            return false;
        }
        Path modulesRoot = balaPath.resolve("modules");
        File[] files = modulesRoot.toFile().listFiles();
        if (files == null) {
            return false;
        }
        return Files.isDirectory(modulesRoot, new LinkOption[0]) && files.length >= 1;
    }

    private static boolean isValidBalaFile(Path balaPath) {
        return Files.isRegularFile(balaPath, new LinkOption[0]) && BALA_EXTENSION_MATCHER.matches(balaPath);
    }
}

