/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ResourceConfig;
import java.nio.file.Path;
import java.util.Locale;

public class ProvidedResourceConfig
extends ResourceConfig {
    public static final String OS = System.getProperty("os.name").toLowerCase(Locale.getDefault());

    private ProvidedResourceConfig(DocumentId documentId, Path path, String name, byte[] content) {
        super(documentId, path, name, content);
    }

    public static ProvidedResourceConfig from(DocumentId documentId, Path resource, Path packagePath) {
        Path relativeResourcePath = resource.startsWith(packagePath) ? packagePath.relativize(resource) : resource;
        String resourcePath = relativeResourcePath.toString();
        String marker = "resources" + (OS.contains("win") ? "\\" : "/");
        int markerIndex = resourcePath.indexOf(marker);
        String path = markerIndex != -1 ? resourcePath.substring(markerIndex + marker.length()) : resourcePath;
        return new ProvidedResourceConfig(documentId, resource, ProvidedResourceConfig.convertWinPathToUnixFormat(path), null);
    }

    public static String convertWinPathToUnixFormat(String path) {
        if (OS.contains("win")) {
            path = path.replace("\\", "/");
        }
        return path;
    }
}

