/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.configschema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.projects.internal.configschema.VisitedType;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.BooleanSubtype;
import io.ballerina.types.subtypedata.DecimalSubtype;
import io.ballerina.types.subtypedata.FloatSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.StringSubtype;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.SemNamedType;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class TypeConverter {
    static final String PROPERTIES = "properties";
    static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    static final String TYPE = "type";
    private final Map<String, VisitedType> visitedTypeMap = new HashMap<String, VisitedType>();

    private VisitedType getVisitedType(String typeName) {
        if (this.visitedTypeMap.containsKey(typeName)) {
            return this.visitedTypeMap.get(typeName);
        }
        return null;
    }

    public void addVisitedTypeEntry(String typeName) {
        this.visitedTypeMap.put(typeName, new VisitedType());
    }

    private void completeVisitedTypeEntry(String typeName, JsonObject typeNode) {
        VisitedType visitedType = this.visitedTypeMap.get(typeName);
        visitedType.setCompleted(true);
        visitedType.setTypeNode(typeNode);
    }

    JsonObject getType(BType type) {
        JsonObject typeNode = new JsonObject();
        type = Types.getReferredType(type);
        if (TypeTags.isSimpleBasicType(type.tag)) {
            String typeVal = TypeConverter.getSimpleType(type);
            typeNode.addProperty(TYPE, typeVal);
        } else {
            if (22 == type.tag && type instanceof BIntersectionType) {
                BIntersectionType intersectionType = (BIntersectionType)type;
                BType effectiveType = Types.getImpliedType(type);
                if (TypeTags.isSimpleBasicType(effectiveType.tag)) {
                    String typeVal = TypeConverter.getSimpleType(effectiveType);
                    typeNode.addProperty(TYPE, typeVal);
                    return typeNode;
                }
                VisitedType visitedType = this.getVisitedType(effectiveType.toString());
                if (visitedType != null) {
                    if (visitedType.isCompleted()) {
                        return visitedType.getTypeNode();
                    }
                    JsonObject nullType = new JsonObject();
                    nullType.addProperty(TYPE, "null");
                    return nullType;
                }
                this.visitedTypeMap.put(effectiveType.toString(), new VisitedType());
                if (20 == effectiveType.tag && effectiveType instanceof BArrayType) {
                    BArrayType arrayType = (BArrayType)effectiveType;
                    this.generateArrayType(typeNode, arrayType);
                }
                if (12 == effectiveType.tag && effectiveType instanceof BRecordType) {
                    BRecordType recordType = (BRecordType)effectiveType;
                    typeNode = this.generateRecordType(recordType, intersectionType);
                }
                if (16 == effectiveType.tag && effectiveType instanceof BMapType) {
                    BMapType mapType = (BMapType)effectiveType;
                    this.generateMapType(typeNode, mapType);
                }
                if (21 == effectiveType.tag && effectiveType instanceof BUnionType) {
                    BUnionType unionType = (BUnionType)effectiveType;
                    this.generateUnionType(typeNode, unionType);
                }
                if (9 == effectiveType.tag && effectiveType instanceof BTableType) {
                    BTableType tableType = (BTableType)effectiveType;
                    this.generateTableType(typeNode, tableType);
                }
                this.completeVisitedTypeEntry(effectiveType.toString(), typeNode);
            } else if (21 == type.tag && type instanceof BUnionType) {
                BUnionType unionType = (BUnionType)type;
                this.generateUnionType(typeNode, unionType);
            }
            if (33 == type.tag && type instanceof BFiniteType) {
                BFiniteType finiteType = (BFiniteType)type;
                JsonArray enumArray = new JsonArray();
                TypeConverter.getEnumArray(enumArray, finiteType);
                typeNode.add("enum", (JsonElement)enumArray);
            }
        }
        return typeNode;
    }

    private void generateTableType(JsonObject typeNode, BTableType effectiveType) {
        typeNode.addProperty(TYPE, "array");
        typeNode.add("items", (JsonElement)this.getType(effectiveType.getConstraint()));
    }

    private void generateArrayType(JsonObject typeNode, BArrayType effectiveType) {
        typeNode.addProperty(TYPE, "array");
        typeNode.add("items", (JsonElement)this.getType(effectiveType.getElementType()));
    }

    private JsonObject generateRecordType(BRecordType effectiveType, BIntersectionType intersectionType) {
        LinkedHashMap<String, BField> fieldLinkedHashMap = effectiveType.getFields();
        JsonObject effectiveTypeNode = new JsonObject();
        JsonArray requiredFields = new JsonArray();
        for (Map.Entry<String, BField> key : fieldLinkedHashMap.entrySet()) {
            BField field = key.getValue();
            JsonObject fieldTypeNode = this.getType(field.getType());
            effectiveTypeNode.add(field.getName().getValue(), (JsonElement)fieldTypeNode);
            if (Symbols.isOptional(field.symbol)) continue;
            requiredFields.add(field.getName().getValue());
        }
        JsonObject typeNode = TypeConverter.createObjNode(effectiveTypeNode);
        if (!requiredFields.isEmpty()) {
            typeNode.add("required", (JsonElement)requiredFields);
        }
        BTypeSymbol intersectionSymbol = intersectionType.tsymbol;
        if (intersectionSymbol.name != Names.EMPTY) {
            typeNode.addProperty("name", intersectionSymbol.toString().trim());
        } else {
            for (BType bType : intersectionType.getConstituentTypes()) {
                if (bType.tag != 14) continue;
                typeNode.addProperty("name", bType.toString().trim());
            }
        }
        return typeNode;
    }

    private void generateMapType(JsonObject typeNode, BMapType effectiveType) {
        typeNode.addProperty(TYPE, "object");
        typeNode.add(ADDITIONAL_PROPERTIES, (JsonElement)this.getType(effectiveType.getConstraint()));
    }

    private void generateUnionType(JsonObject typeNode, BUnionType effectiveType) {
        Set members = effectiveType.getMemberTypes();
        JsonArray memberArray = new JsonArray();
        JsonArray enumArray = new JsonArray();
        this.updateUnionMembers((LinkedHashSet<BType>)members, memberArray, enumArray);
        if (enumArray.isEmpty() && !memberArray.isEmpty()) {
            typeNode.add("anyOf", (JsonElement)memberArray);
        } else if (!enumArray.isEmpty() && memberArray.isEmpty()) {
            typeNode.add("enum", (JsonElement)enumArray);
        } else if (!enumArray.isEmpty() && !memberArray.isEmpty()) {
            JsonObject memberObj = new JsonObject();
            memberObj.add("enum", (JsonElement)enumArray);
            memberArray.add((JsonElement)memberObj);
            typeNode.add("anyOf", (JsonElement)memberArray);
        }
    }

    private void updateUnionMembers(LinkedHashSet<BType> members, JsonArray memberArray, JsonArray enumArray) {
        for (BType member : members) {
            if (TypeTags.isSimpleBasicType(member.tag) || 22 == member.tag && member instanceof BIntersectionType) {
                JsonObject memberObj = this.getType(member);
                memberArray.add((JsonElement)memberObj);
                continue;
            }
            if (33 == member.tag && member instanceof BFiniteType) {
                BFiniteType finiteType = (BFiniteType)member;
                TypeConverter.getEnumArray(enumArray, finiteType);
                continue;
            }
            if (14 != member.tag || !(member instanceof BTypeReferenceType)) continue;
            BTypeReferenceType typeReferenceType = (BTypeReferenceType)member;
            BType referredType = typeReferenceType.referredType;
            if (21 != referredType.tag || !(referredType instanceof BUnionType)) continue;
            BUnionType unionType = (BUnionType)referredType;
            Set subMembers = unionType.getMemberTypes();
            this.updateUnionMembers((LinkedHashSet<BType>)subMembers, memberArray, enumArray);
        }
    }

    private static void getEnumArray(JsonArray enumArray, BFiniteType finiteType) {
        for (SemNamedType semNamedType : finiteType.valueSpace) {
            SemType s = semNamedType.semType();
            if (PredefinedType.NIL.equals((Object)s)) {
                enumArray.add(Names.NIL_VALUE.value);
                continue;
            }
            ComplexSemType cs = (ComplexSemType)s;
            if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.BOOLEAN)) {
                boolean boolVal = (Boolean)BooleanSubtype.booleanSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_BOOLEAN)).get();
                enumArray.add(boolVal ? Names.TRUE.value : Names.FALSE.value);
                continue;
            }
            if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.INT)) {
                long longVal = (Long)IntSubtype.intSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_INT)).get();
                enumArray.add((Number)longVal);
                continue;
            }
            if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.FLOAT)) {
                double doubleVal = (Double)FloatSubtype.floatSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_FLOAT)).get();
                enumArray.add((Number)doubleVal);
                continue;
            }
            if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.DECIMAL)) {
                BigDecimal bVal = (BigDecimal)DecimalSubtype.decimalSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_DECIMAL)).get();
                enumArray.add(bVal.toString());
                continue;
            }
            if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.STRING)) {
                String stringVal = (String)StringSubtype.stringSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_STRING)).get();
                enumArray.add(stringVal);
                continue;
            }
            throw new IllegalStateException("Unexpected value space type: " + String.valueOf(s));
        }
    }

    private static String getSimpleType(BType type) {
        if (TypeTags.isIntegerTypeTag(type.tag)) {
            return "integer";
        }
        if (TypeTags.isStringTypeTag(type.tag)) {
            return "string";
        }
        return switch (type.tag) {
            case 3, 4 -> "number";
            case 6 -> "boolean";
            case 2 -> "integer";
            default -> "";
        };
    }

    static JsonObject createObjNode(JsonObject modVarNode) {
        JsonObject node = new JsonObject();
        node.addProperty(TYPE, "object");
        node.add(PROPERTIES, (JsonElement)modVarNode);
        node.addProperty(ADDITIONAL_PROPERTIES, Boolean.valueOf(false));
        return node;
    }
}

