/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.Settings;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.internal.model.BuildJson;
import io.ballerina.projects.internal.model.Dependency;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.internal.model.ToolDependency;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryPredicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.ballerinalang.compiler.BLangCompilerException;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Lists;
import org.wso2.ballerinalang.util.RepoUtils;

public final class ProjectUtils {
    private static final String USER_HOME = "user.home";
    private static final Pattern separatedIdentifierPattern = Pattern.compile("^[a-zA-Z0-9_.]*$");
    private static final Pattern onlyDotsPattern = Pattern.compile("^[.]+$");
    private static final Pattern onlyNonAlphanumericPattern = Pattern.compile("^[^a-zA-Z0-9]+$");
    private static final Pattern orgNamePattern = Pattern.compile("^[a-zA-Z0-9_]*$");
    private static final Pattern separatedIdentifierWithHyphenPattern = Pattern.compile("^[a-zA-Z0-9_.-]*$");
    private static final List<Diagnostic> projectLoadingDiagnostic = new ArrayList<Diagnostic>();
    public static final Path BAL_TOOLS_TOML_PATH = RepoUtils.createAndGetHomeReposPath().resolve(Path.of(".config", "bal-tools.toml"));
    private static final HashSet<String> excludeExtensions = new HashSet<String>(Lists.of("DSA", "SF"));

    private ProjectUtils() {
    }

    public static boolean validateOrgName(String orgName) {
        Matcher m = orgNamePattern.matcher(orgName);
        return m.matches();
    }

    public static boolean validatePackageName(String packageName) {
        return ProjectUtils.validateDotSeparatedIdentifiers(packageName) && ProjectUtils.validateUnderscoresOfName(packageName) && ProjectUtils.validateInitialNumericsOfName(packageName);
    }

    public static boolean validateToolName(String toolName) {
        return ProjectUtils.validateDotSeparatedIdentifiersWithHyphen(toolName) && ProjectUtils.validateUnderscoresOfName(toolName) && ProjectUtils.validateInitialNumericsOfName(toolName);
    }

    public static boolean validatePackageName(String orgName, String packageName) {
        if (ProjectUtils.isLangLibPackage(PackageOrg.from(orgName), PackageName.from(packageName))) {
            return ProjectUtils.validateDotSeparatedIdentifiers(packageName) && ProjectUtils.validateInitialNumericsOfName(packageName);
        }
        return ProjectUtils.validateDotSeparatedIdentifiers(packageName) && ProjectUtils.validateUnderscoresOfName(packageName) && ProjectUtils.validateInitialNumericsOfName(packageName);
    }

    public static Set<String> getPackageImports(Package pkg) {
        HashSet<String> imports = new HashSet<String>();
        for (ModuleId moduleId : pkg.moduleIds()) {
            Module module = pkg.module(moduleId);
            Collection<DocumentId> documentIds = module.documentIds();
            ProjectUtils.getPackageImports(imports, module, documentIds);
            Collection<DocumentId> testDocumentIds = module.testDocumentIds();
            ProjectUtils.getPackageImports(imports, module, testDocumentIds);
        }
        return imports;
    }

    private static void getPackageImports(Set<String> imports, Module module, Collection<DocumentId> documentIds) {
        for (DocumentId docId : documentIds) {
            Document document = module.document(docId);
            ModulePartNode modulePartNode = (ModulePartNode)document.syntaxTree().rootNode();
            for (ImportDeclarationNode importDcl : modulePartNode.imports()) {
                boolean isErrorInImport = false;
                for (Diagnostic diagnostic : importDcl.diagnostics()) {
                    if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
                    isErrorInImport = true;
                    break;
                }
                if (isErrorInImport) continue;
                String orgName = "";
                if (importDcl.orgName().isPresent()) {
                    orgName = ((ImportOrgNameNode)importDcl.orgName().get()).orgName().text();
                }
                SeparatedNodeList identifierTokenList = importDcl.moduleName();
                StringJoiner stringJoiner = new StringJoiner(".");
                for (int i = 0; i < identifierTokenList.size(); ++i) {
                    stringJoiner.add(((IdentifierToken)identifierTokenList.get(i)).text());
                }
                String moduleName = stringJoiner.toString();
                imports.add(orgName + "/" + moduleName);
            }
        }
    }

    public static boolean validateModuleName(String moduleName) {
        return ProjectUtils.validateDotSeparatedIdentifiers(moduleName);
    }

    public static boolean validateNameLength(String name) {
        return name.length() <= 256;
    }

    public static boolean validateUnderscoresOfName(String name) {
        return !name.startsWith("_") && !name.endsWith("_") && !name.contains("__");
    }

    public static boolean validateInitialNumericsOfName(String name) {
        return !name.matches("[0-9].*");
    }

    public static String removeLastChar(String aString) {
        return aString.substring(0, aString.length() - 1);
    }

    public static String removeFirstChar(String aString) {
        return aString.substring(1);
    }

    public static String getPackageValidationError(String packageName) {
        if (!ProjectUtils.validateDotSeparatedIdentifiers(packageName)) {
            return "Package name can only contain alphanumerics and underscores.";
        }
        if (!ProjectUtils.validateInitialNumericsOfName(packageName)) {
            return "Package name cannot have initial numeric characters.";
        }
        return ProjectUtils.getValidateUnderscoreError(packageName, "Package");
    }

    public static String getValidateUnderscoreError(String name, String packageOrModule) {
        if (name.startsWith("_")) {
            return packageOrModule + " name cannot have initial underscore characters.";
        }
        if (name.endsWith("_")) {
            return packageOrModule + " name cannot have trailing underscore characters.";
        }
        return packageOrModule + " name cannot have consecutive underscore characters.";
    }

    public static Path findProjectRoot(Path filePath) {
        if (filePath != null) {
            if ((filePath = filePath.toAbsolutePath().normalize()).toFile().isDirectory() && Files.exists(filePath.resolve("Ballerina.toml"), new LinkOption[0])) {
                return filePath;
            }
            return ProjectUtils.findProjectRoot(filePath.getParent());
        }
        return null;
    }

    public static boolean isBallerinaProject(Path sourceRoot) {
        Path ballerinaToml = sourceRoot.resolve("Ballerina.toml");
        return Files.isDirectory(sourceRoot, new LinkOption[0]) && Files.exists(ballerinaToml, new LinkOption[0]) && Files.isRegularFile(ballerinaToml, new LinkOption[0]);
    }

    public static String guessOrgName() {
        String guessOrgName = System.getProperty("user.name");
        if (guessOrgName == null) {
            guessOrgName = "my_org";
        } else if (!ProjectUtils.validateOrgName(guessOrgName)) {
            guessOrgName = guessOrgName.replaceAll("[^a-zA-Z0-9_]", "_");
        }
        return guessOrgName.toLowerCase(Locale.getDefault());
    }

    public static String guessPkgName(String packageName, String template) {
        if (!ProjectUtils.validateOnlyNonAlphanumeric((String)packageName)) {
            packageName = "my_package";
        }
        if (!ProjectUtils.validatePackageName((String)packageName)) {
            packageName = ((String)packageName).replaceAll("[^a-zA-Z0-9_.]", "_");
        }
        if (((String)packageName).matches("[0-9].*")) {
            packageName = template.equalsIgnoreCase("lib") ? "lib" + (String)packageName : (template.equalsIgnoreCase("tool") ? "tool" + (String)packageName : "app" + (String)packageName);
        }
        if (((String)packageName).startsWith("_")) {
            packageName = ProjectUtils.removeFirstChar((String)packageName);
        }
        if (((String)packageName).contains("__")) {
            packageName = ((String)packageName).replace("__", "_");
        }
        if (((String)packageName).endsWith("_")) {
            packageName = ProjectUtils.removeLastChar((String)packageName);
        }
        return packageName;
    }

    public static String guessModuleName(String moduleName) {
        if (!ProjectUtils.validateModuleName(moduleName)) {
            return moduleName.replaceAll("[^a-zA-Z0-9_.]", "_");
        }
        return moduleName;
    }

    public static PackageOrg defaultOrg() {
        return PackageOrg.from(ProjectUtils.guessOrgName());
    }

    public static PackageName defaultName(Path projectPath) {
        return PackageName.from(ProjectUtils.guessPkgName(Optional.ofNullable(projectPath.getFileName()).map(Path::toString).orElse(""), "app"));
    }

    public static PackageVersion defaultVersion() {
        return PackageVersion.from("0.1.0");
    }

    public static String getBalaName(PackageManifest pkgDesc) {
        return ProjectUtils.getBalaName(pkgDesc.org().toString(), pkgDesc.name().toString(), pkgDesc.version().toString(), null);
    }

    public static String getBalaName(String org, String pkgName, String version, String platform) {
        if (platform == null || platform.isEmpty()) {
            platform = "any";
        }
        return org + "-" + pkgName + "-" + platform + "-" + version + ".bala";
    }

    public static Path getRelativeBalaPath(String org, String pkgName, String version, String platform) {
        if (platform == null || platform.isEmpty()) {
            platform = "any";
        }
        return Path.of(org, pkgName, version, platform);
    }

    public static String getJarFileName(Package pkg) {
        return pkg.packageOrg().toString() + "-" + pkg.packageName().toString() + "-" + String.valueOf(pkg.packageVersion()) + ".jar";
    }

    public static String getExecutableName(Package pkg) {
        return pkg.packageName().toString() + ".jar";
    }

    public static String getOrgFromBalaName(String balaName) {
        return balaName.split("-")[0];
    }

    public static String getPackageNameFromBalaName(String balaName) {
        return balaName.split("-")[1];
    }

    public static String getVersionFromBalaName(String balaName) {
        String versionAndExtension = balaName.split("-")[3];
        int extensionIndex = versionAndExtension.indexOf(".bala");
        return versionAndExtension.substring(0, extensionIndex);
    }

    public static Path getBalHomePath() {
        return Path.of(System.getProperty("ballerina.home"), new String[0]);
    }

    public static Path getBallerinaRTJarPath() {
        String ballerinaVersion = RepoUtils.getBallerinaPackVersion();
        String runtimeJarName = "ballerina-rt-" + ballerinaVersion + ".jar";
        return ProjectUtils.getBalHomePath().resolve("bre").resolve("lib").resolve(runtimeJarName);
    }

    public static List<JarLibrary> testDependencies() {
        ArrayList<JarLibrary> dependencies = new ArrayList<JarLibrary>();
        String testPkgName = "ballerina/test";
        String ballerinaVersion = RepoUtils.getBallerinaPackVersion();
        Path homeLibPath = ProjectUtils.getBalHomePath().resolve("bre").resolve("lib");
        String testRuntimeJarName = "testerina-runtime-" + ballerinaVersion + ".jar";
        String testCoreJarName = "testerina-core-" + ballerinaVersion + ".jar";
        String langJarName = "ballerina-lang-" + ballerinaVersion + ".jar";
        Path testRuntimeJarPath = homeLibPath.resolve(testRuntimeJarName);
        Path testCoreJarPath = homeLibPath.resolve(testCoreJarName);
        Path langJarPath = homeLibPath.resolve(langJarName);
        Path jacocoCoreJarPath = homeLibPath.resolve("org.jacoco.core-0.8.12.jar");
        Path jacocoReportJarPath = homeLibPath.resolve("org.jacoco.report-0.8.12.jar");
        Path asmJarPath = homeLibPath.resolve("asm-9.7.jar");
        Path asmTreeJarPath = homeLibPath.resolve("asm-tree-9.7.jar");
        Path asmCommonsJarPath = homeLibPath.resolve("asm-commons-9.7.jar");
        Path diffUtilsJarPath = homeLibPath.resolve("java-diff-utils-4.5.jar");
        dependencies.add(new JarLibrary(testRuntimeJarPath, PlatformLibraryScope.TEST_ONLY, testPkgName));
        dependencies.add(new JarLibrary(testCoreJarPath, PlatformLibraryScope.TEST_ONLY, testPkgName));
        dependencies.add(new JarLibrary(langJarPath, PlatformLibraryScope.TEST_ONLY, testPkgName));
        dependencies.add(new JarLibrary(jacocoCoreJarPath, PlatformLibraryScope.TEST_ONLY, testPkgName));
        dependencies.add(new JarLibrary(jacocoReportJarPath, PlatformLibraryScope.TEST_ONLY, testPkgName));
        dependencies.add(new JarLibrary(asmJarPath, PlatformLibraryScope.TEST_ONLY, testPkgName));
        dependencies.add(new JarLibrary(asmTreeJarPath, PlatformLibraryScope.TEST_ONLY, testPkgName));
        dependencies.add(new JarLibrary(asmCommonsJarPath, PlatformLibraryScope.TEST_ONLY, testPkgName));
        dependencies.add(new JarLibrary(diffUtilsJarPath, PlatformLibraryScope.TEST_ONLY, testPkgName));
        return dependencies;
    }

    public static Path generateObservabilitySymbolsJar(String packageName) throws IOException {
        Path jarPath = Files.createTempFile(packageName + "-", "-observability-symbols.jar", new FileAttribute[0]);
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(jarPath.toFile())), manifest);
        jarOutputStream.close();
        return jarPath;
    }

    public static void copyRuntimeJar(ZipArchiveOutputStream outStream, Path ballerinaRTJarPath, HashSet<String> copiedEntries) throws IOException {
        HashMap services = new HashMap();
        ZipFile zipFile = new ZipFile(ballerinaRTJarPath.toString());
        ZipArchiveEntryPredicate predicate = entry -> {
            String entryName = entry.getName();
            if (entryName.equals("META-INF/MANIFEST.MF")) {
                return false;
            }
            if (entryName.startsWith("META-INF/services")) {
                StringBuilder s = (StringBuilder)services.get(entryName);
                if (s == null) {
                    s = new StringBuilder();
                    services.put(entryName, s);
                }
                char c = '\n';
                try (BufferedInputStream inStream = new BufferedInputStream(zipFile.getInputStream(entry));){
                    int len;
                    while ((len = inStream.read()) != -1) {
                        c = (char)len;
                        s.append(c);
                    }
                }
                catch (IOException e) {
                    throw new ProjectException(e);
                }
                if (c != '\n') {
                    s.append('\n');
                }
                return false;
            }
            if (ProjectUtils.isCopiedOrExcludedEntry(entryName, copiedEntries)) {
                return false;
            }
            copiedEntries.add(entryName);
            return true;
        };
        zipFile.copyRawEntries(outStream, predicate);
        zipFile.close();
        for (Map.Entry entry2 : services.entrySet()) {
            String s = (String)entry2.getKey();
            StringBuilder service = (StringBuilder)entry2.getValue();
            JarArchiveEntry e = new JarArchiveEntry(s);
            outStream.putArchiveEntry((ZipArchiveEntry)e);
            outStream.write(service.toString().getBytes(StandardCharsets.UTF_8));
            outStream.closeArchiveEntry();
        }
    }

    private static boolean isCopiedOrExcludedEntry(String entryName, HashSet<String> copiedEntries) {
        return copiedEntries.contains(entryName) || excludeExtensions.contains(entryName.substring(entryName.lastIndexOf(".") + 1));
    }

    public static String getJarFileName(Module module) {
        String jarName;
        if (module.packageInstance().manifest().org().anonymous()) {
            DocumentId documentId = module.documentIds().iterator().next();
            String documentName = module.document(documentId).name();
            jarName = FileUtils.getFileNameWithoutExtension(documentName);
        } else {
            ModuleName moduleName = module.moduleName();
            jarName = moduleName.isDefaultModuleName() ? moduleName.packageName().toString() : moduleName.moduleNamePart();
        }
        return jarName;
    }

    public static String getThinJarFileName(PackageOrg org, String moduleName, PackageVersion version) {
        return org.value() + "-" + moduleName + "-" + String.valueOf(version.value());
    }

    public static Path createAndGetHomeReposPath() {
        Path homeRepoPath;
        String homeRepoDir = System.getenv("BALLERINA_HOME_DIR");
        if (homeRepoDir == null || homeRepoDir.isEmpty()) {
            String userHomeDir = System.getProperty(USER_HOME);
            if (userHomeDir == null || userHomeDir.isEmpty()) {
                throw new BLangCompilerException("Error creating home repository: unable to get user home directory");
            }
            homeRepoPath = Path.of(userHomeDir, ".ballerina");
        } else {
            homeRepoPath = Path.of(homeRepoDir, new String[0]);
        }
        homeRepoPath = homeRepoPath.toAbsolutePath();
        if (Files.exists(homeRepoPath, new LinkOption[0]) && !Files.isDirectory(homeRepoPath, LinkOption.NOFOLLOW_LINKS)) {
            throw new BLangCompilerException("Home repository is not a directory: " + String.valueOf(homeRepoPath));
        }
        return homeRepoPath;
    }

    public static boolean isModuleExist(Path projectPath, String moduleName) {
        Path modulePath = projectPath.resolve("modules").resolve(moduleName);
        return Files.exists(modulePath, new LinkOption[0]);
    }

    public static java.net.Proxy initializeProxy(Proxy proxy) {
        if (proxy != null && !"".equals(proxy.host()) && proxy.port() > 0) {
            InetSocketAddress proxyInet = new InetSocketAddress(proxy.host(), proxy.port());
            return new java.net.Proxy(Proxy.Type.HTTP, proxyInet);
        }
        return null;
    }

    public static String getAccessTokenOfCLI(Settings settings) {
        String tokenAsEnvVar = System.getenv("BALLERINA_CENTRAL_ACCESS_TOKEN");
        if (tokenAsEnvVar != null) {
            return tokenAsEnvVar;
        }
        if (settings.getCentral() != null) {
            return settings.getCentral().getAccessToken();
        }
        return "";
    }

    public static void checkWritePermission(Path path) {
        if (!path.toFile().canWrite()) {
            throw new ProjectException("'" + String.valueOf(path.normalize()) + "' does not have write permissions");
        }
    }

    public static void checkReadPermission(Path path) {
        if (!path.toFile().canRead()) {
            throw new ProjectException("'" + String.valueOf(path.normalize()) + "' does not have read permissions");
        }
    }

    public static void checkExecutePermission(Path path) {
        if (!path.toFile().canExecute()) {
            throw new ProjectException("'" + String.valueOf(path.normalize()) + "' does not have execute permissions");
        }
    }

    private static boolean validateDotSeparatedIdentifiers(String identifiers) {
        Matcher m = separatedIdentifierPattern.matcher(identifiers);
        Matcher mm = onlyDotsPattern.matcher(identifiers);
        return m.matches() && !mm.matches();
    }

    private static boolean validateDotSeparatedIdentifiersWithHyphen(String identifiers) {
        Matcher m = separatedIdentifierWithHyphenPattern.matcher(identifiers);
        Matcher mm = onlyDotsPattern.matcher(identifiers);
        return m.matches() && !mm.matches();
    }

    private static boolean validateOnlyNonAlphanumeric(String identifiers) {
        Matcher m = onlyNonAlphanumericPattern.matcher(identifiers);
        return !m.matches();
    }

    public static String getDependenciesTomlContent(Collection<ResolvedPackageDependency> pkgGraphDependencies) {
        String comment = "# AUTO-GENERATED FILE. DO NOT MODIFY.\n\n# This file is auto-generated by Ballerina for managing dependency versions.\n# It should not be modified by hand.\n\n";
        StringBuilder content = new StringBuilder(comment);
        content.append("[ballerina]\n");
        content.append("version = \"").append(RepoUtils.getBallerinaShortVersion()).append("\"\n");
        content.append("dependencies-toml-version = \"").append("2").append("\"\n");
        pkgGraphDependencies.forEach(graphDependency -> {
            content.append("\n");
            PackageDescriptor descriptor = graphDependency.packageInstance().descriptor();
            ProjectUtils.addDependencyContent(content, descriptor.org().value(), descriptor.name().value(), descriptor.version().value().toString(), null, Collections.emptyList(), Collections.emptyList());
        });
        return String.valueOf(content);
    }

    public static String getDependenciesTomlContent(List<Dependency> pkgDependencies, List<ToolDependency> toolDependencies) {
        String comment = "# AUTO-GENERATED FILE. DO NOT MODIFY.\n\n# This file is auto-generated by Ballerina for managing dependency versions.\n# It should not be modified by hand.\n\n";
        StringBuilder content = new StringBuilder(comment);
        content.append("[ballerina]\n");
        content.append("dependencies-toml-version = \"").append("2").append("\"\n");
        content.append("distribution-version = \"").append(RepoUtils.getBallerinaShortVersion()).append("\"\n");
        pkgDependencies.forEach(dependency -> {
            content.append("\n");
            ProjectUtils.addDependencyContent(content, dependency.getOrg(), dependency.getName(), dependency.getVersion(), ProjectUtils.getDependencyScope(dependency.getScope()), dependency.getDependencies(), dependency.getModules());
        });
        toolDependencies.forEach(toolDependency -> {
            content.append("\n");
            ProjectUtils.addToolDependencyContent(content, toolDependency.getId(), toolDependency.getOrg(), toolDependency.getName(), toolDependency.getVersion());
        });
        return String.valueOf(content);
    }

    private static void addDependencyContent(StringBuilder content, String org, String name, String version, String scope, List<Dependency> dependencies, List<Dependency.Module> modules) {
        int count;
        content.append("[[package]]\n");
        content.append("org = \"").append(org).append("\"\n");
        content.append("name = \"").append(name).append("\"\n");
        content.append("version = \"").append(version).append("\"\n");
        if (scope != null) {
            content.append("scope = \"").append(scope).append("\"\n");
        }
        if (!dependencies.isEmpty()) {
            count = 1;
            content.append("dependencies = [\n");
            for (Dependency transDependency : dependencies) {
                content.append("\t{");
                content.append("org = \"").append(transDependency.getOrg()).append("\", ");
                content.append("name = \"").append(transDependency.getName()).append("\"");
                content.append("}");
                if (count != dependencies.size()) {
                    content.append(",\n");
                } else {
                    content.append("\n");
                }
                ++count;
            }
            content.append("]\n");
        }
        if (!modules.isEmpty()) {
            count = 1;
            content.append("modules = [\n");
            for (Dependency.Module module : modules) {
                content.append("\t{");
                content.append("org = \"").append(module.org()).append("\", ");
                content.append("packageName = \"").append(module.packageName()).append("\", ");
                content.append("moduleName = \"").append(module.moduleName()).append("\"");
                content.append("}");
                if (count != modules.size()) {
                    content.append(",\n");
                } else {
                    content.append("\n");
                }
                ++count;
            }
            content.append("]\n");
        }
    }

    private static void addToolDependencyContent(StringBuilder content, String id, String org, String name, String version) {
        content.append("[[tool]]\n");
        content.append("id = \"").append(id).append("\"\n");
        content.append("org = \"").append(org).append("\"\n");
        content.append("name = \"").append(name).append("\"\n");
        content.append("version = \"").append(version).append("\"\n");
    }

    private static String getDependencyScope(PackageDependencyScope scope) {
        if (scope == PackageDependencyScope.TEST_ONLY) {
            return "testOnly";
        }
        return null;
    }

    public static List<PackageName> getPossiblePackageNames(PackageOrg packageOrg, String moduleName) {
        StringJoiner pkgNameBuilder = new StringJoiner(".");
        if (ProjectUtils.isBuiltInPackage(packageOrg, moduleName)) {
            pkgNameBuilder.add(moduleName);
            return Collections.singletonList(PackageName.from(pkgNameBuilder.toString()));
        }
        String[] modNameParts = moduleName.split("\\.");
        ArrayList<PackageName> possiblePkgNames = new ArrayList<PackageName>(modNameParts.length);
        for (String modNamePart : modNameParts) {
            pkgNameBuilder.add(modNamePart);
            possiblePkgNames.add(PackageName.from(pkgNameBuilder.toString()));
        }
        return possiblePkgNames;
    }

    public static boolean isBuiltInPackage(PackageOrg org, String moduleName) {
        return org.isBallerinaOrg() && moduleName.startsWith("lang.") || org.value().equals(Names.BALLERINA_INTERNAL_ORG.getValue()) || org.isBallerinaOrg() && moduleName.equals(Names.JAVA.getValue()) || org.isBallerinaOrg() && moduleName.equals(Names.TEST.getValue());
    }

    public static boolean isLangLibPackage(PackageOrg org, PackageName packageName) {
        return org.isBallerinaOrg() && packageName.value().startsWith("lang.") || org.isBallerinaOrg() && packageName.value().equals(Names.JAVA.getValue());
    }

    public static void extractBala(Path balaFilePath, Path balaFileDestPath) throws IOException {
        if (Files.exists(balaFileDestPath, new LinkOption[0]) && Files.isDirectory(balaFilePath, new LinkOption[0])) {
            ProjectUtils.deleteDirectory(balaFileDestPath);
        } else {
            Files.createDirectories(balaFileDestPath, new FileAttribute[0]);
        }
        byte[] buffer = new byte[4096];
        try (FileInputStream fileInputStream = new FileInputStream(balaFilePath.toString());
             ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String fileName = zipEntry.getName();
                Path outputPath = balaFileDestPath.resolve(fileName);
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(outputPath, new FileAttribute[0]);
                    zipEntry = zipInputStream.getNextEntry();
                    continue;
                }
                Files.createDirectories(Optional.of(outputPath.getParent()).get(), new FileAttribute[0]);
                try (FileOutputStream fileOutputStream = new FileOutputStream(outputPath.toFile());){
                    int len;
                    while ((len = zipInputStream.read(buffer)) > 0) {
                        fileOutputStream.write(buffer, 0, len);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.closeEntry();
        }
    }

    public static boolean deleteDirectory(Path directoryPath) {
        File[] files;
        File directory = new File(String.valueOf(directoryPath));
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File f : files) {
                boolean success = ProjectUtils.deleteDirectory(f.toPath());
                if (success) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public static boolean deleteSelectedFilesInDirectory(Path directoryPath, List<Path> filesToKeep) {
        if (filesToKeep.isEmpty()) {
            return ProjectUtils.deleteDirectory(directoryPath);
        }
        File directory = new File(String.valueOf(directoryPath));
        File[] files = directory.listFiles();
        boolean success = true;
        if (files != null) {
            for (File f : files) {
                if (!filesToKeep.contains(f.toPath()) && f.isDirectory()) {
                    success = ProjectUtils.deleteDirectory(f.toPath());
                    continue;
                }
                if (filesToKeep.contains(f.toPath()) || !f.isFile()) continue;
                success = f.delete();
            }
            return success;
        }
        return true;
    }

    public static BuildJson readBuildJson(Path buildJsonPath) throws JsonSyntaxException, IOException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(buildJsonPath);){
            BuildJson buildJson = (BuildJson)new Gson().fromJson((Reader)bufferedReader, BuildJson.class);
            return buildJson;
        }
    }

    public static boolean isProjectUpdated(Project project) {
        Path observeJarCachePath = project.targetDir().resolve("cache").resolve(project.currentPackage().packageOrg().value()).resolve(project.currentPackage().packageName().value()).resolve(project.currentPackage().packageVersion().value().toString()).resolve("observe").resolve(project.currentPackage().packageOrg().value() + "-" + project.currentPackage().packageName().value() + "-observability-symbols.jar");
        if (project.buildOptions().observabilityIncluded() && !observeJarCachePath.toFile().exists()) {
            return true;
        }
        Path buildFile = project.sourceRoot().resolve("target").resolve("build");
        if (buildFile.toFile().exists()) {
            try {
                BuildJson buildJson = ProjectUtils.readBuildJson(buildFile);
                long lastProjectUpdatedTime = FileUtils.lastModifiedTimeOfBalProject(project.sourceRoot());
                if (buildJson != null && buildJson.getLastModifiedTime() != null && !buildJson.getLastModifiedTime().entrySet().isEmpty()) {
                    Long defaultModuleLastModifiedTime = buildJson.getLastModifiedTime().get(project.currentPackage().packageName().value());
                    if (defaultModuleLastModifiedTime == null) {
                        return true;
                    }
                    return lastProjectUpdatedTime > defaultModuleLastModifiedTime;
                }
            }
            catch (IOException e) {
                try {
                    Files.deleteIfExists(buildFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
        }
        return true;
    }

    public static String getTemporaryTargetPath() {
        return Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("ballerina-cache" + System.nanoTime()).toString();
    }

    public static void writeBuildFile(Path buildFilePath, BuildJson buildJson) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!buildFilePath.toFile().canWrite()) {
            throw new ProjectException("'build' file does not have write permissions");
        }
        try {
            Files.write(buildFilePath, Collections.singleton(gson.toJson((Object)buildJson)), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write to the 'build' file");
        }
    }

    public static PackageVersion getLatest(PackageVersion v1, PackageVersion v2) {
        boolean isV2PreReleaseVersion;
        SemanticVersion semVer1 = v1.value();
        SemanticVersion semVer2 = v2.value();
        boolean isV1PreReleaseVersion = semVer1.isPreReleaseVersion();
        if (isV1PreReleaseVersion ^ (isV2PreReleaseVersion = semVer2.isPreReleaseVersion())) {
            return isV1PreReleaseVersion ? v2 : v1;
        }
        return semVer1.greaterThanOrEqualTo(semVer2) ? v1 : v2;
    }

    public static boolean isProjectEmpty(Project project) {
        for (ModuleId moduleId : project.currentPackage().moduleIds()) {
            Module module = project.currentPackage().module(moduleId);
            if (module.documentIds().isEmpty() && module.testDocumentIds().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static List<Path> getPathsMatchingIncludePatterns(List<String> patterns, Path packageRoot) {
        ArrayList<Path> allMatchingPaths = new ArrayList<Path>();
        for (String pattern : patterns) {
            if (pattern.startsWith("!")) {
                ProjectUtils.removeNegatedIncludePaths(pattern.substring(1), allMatchingPaths);
                continue;
            }
            ProjectUtils.addMatchingIncludePaths(pattern, allMatchingPaths, packageRoot);
        }
        return allMatchingPaths;
    }

    public static boolean isNewUpdateDistribution(SemanticVersion prevDistributionVersion, SemanticVersion currentDistributionVersion) {
        return currentDistributionVersion.major() == prevDistributionVersion.major() && currentDistributionVersion.minor() > prevDistributionVersion.minor();
    }

    private static void removeNegatedIncludePaths(String pattern, List<Path> allMatchingPaths) {
        String combinedPattern = ProjectUtils.getGlobFormatPattern(pattern);
        Stream<Path> pathStream = allMatchingPaths.stream();
        List<Path> patternPaths = ProjectUtils.filterPathStream(pathStream, combinedPattern);
        allMatchingPaths.removeAll(patternPaths);
    }

    private static void addMatchingIncludePaths(String pattern, List<Path> allMatchingPaths, Path packageRoot) {
        String combinedPattern = ProjectUtils.getGlobFormatPattern(pattern);
        try (Stream<Path> pathStream = Files.walk(packageRoot, new FileVisitOption[0]);){
            List<Path> patternPaths = ProjectUtils.filterPathStream(pathStream, combinedPattern);
            for (Path absolutePath : patternPaths) {
                if (!ProjectUtils.isCorrectPatternPathMatch(absolutePath, packageRoot, pattern)) continue;
                Path relativePath = packageRoot.relativize(absolutePath);
                allMatchingPaths.add(relativePath);
            }
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read files matching the include pattern '" + pattern + "': " + e.getMessage(), e);
        }
    }

    private static boolean isCorrectPatternPathMatch(Path absolutePath, Path packageRoot, String pattern) {
        Path relativePath = packageRoot.relativize(absolutePath);
        boolean correctMatch = true;
        if (relativePath.startsWith("target")) {
            correctMatch = false;
        } else if (pattern.startsWith("/") && !packageRoot.equals(absolutePath.getParent())) {
            correctMatch = false;
        } else if (pattern.endsWith("/") && absolutePath.toFile().isFile()) {
            correctMatch = false;
        }
        return correctMatch;
    }

    private static List<Path> filterPathStream(Stream<Path> pathStream, String combinedPattern) {
        return pathStream.filter(FileSystems.getDefault().getPathMatcher("glob:" + combinedPattern)::matches).toList();
    }

    private static String getGlobFormatPattern(String pattern) {
        String patternPrefix = ProjectUtils.getPatternPrefix(pattern);
        String globPattern = ProjectUtils.removeTrailingSlashes(pattern);
        return patternPrefix + globPattern;
    }

    private static String getPatternPrefix(String pattern) {
        if (pattern.startsWith("/")) {
            return "**";
        }
        return "**/";
    }

    private static String removeTrailingSlashes(String pattern) {
        while (pattern.endsWith("/")) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        return pattern;
    }

    public static Path getPackagePath(Path balaDirPath, String org, String name, String version) {
        Path balaPath = balaDirPath.resolve(ProjectUtils.getRelativeBalaPath(org, name, version, null));
        if (!Files.exists(balaPath, new LinkOption[0])) {
            JvmTarget jvmTarget;
            JvmTarget[] jvmTargetArray = JvmTarget.values();
            int n = jvmTargetArray.length;
            for (int i = 0; i < n && !Files.exists(balaPath = balaDirPath.resolve(ProjectUtils.getRelativeBalaPath(org, name, version, (jvmTarget = jvmTargetArray[i]).code())), new LinkOption[0]); ++i) {
            }
        }
        return balaPath;
    }

    public static boolean getSticky(Project project) {
        Path buildFilePath;
        boolean sticky = project.buildOptions().sticky();
        if (sticky) {
            return true;
        }
        if (project.kind() == ProjectKind.BUILD_PROJECT && Files.exists(buildFilePath = project.targetDir().resolve("build"), new LinkOption[0]) && buildFilePath.toFile().length() > 0L) {
            try {
                BuildJson buildJson = ProjectUtils.readBuildJson(buildFilePath);
                if (buildJson != null && buildJson.distributionVersion() != null && buildJson.distributionVersion().equals(RepoUtils.getBallerinaShortVersion()) && !buildJson.isExpiredLastUpdateTime()) {
                    return true;
                }
            }
            catch (JsonSyntaxException | IOException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static List<SemanticVersion> getVersionsInCompatibleRange(SemanticVersion minVersion, List<SemanticVersion> versions, CompatibleRange compatibleRange) {
        if (compatibleRange.equals((Object)CompatibleRange.LATEST)) {
            return versions;
        }
        if (compatibleRange.equals((Object)CompatibleRange.LOCK_MAJOR)) {
            return versions.stream().filter(version -> version.major() == minVersion.major()).toList();
        }
        if (compatibleRange.equals((Object)CompatibleRange.LOCK_MINOR)) {
            return versions.stream().filter(version -> version.major() == minVersion.major() && version.minor() == minVersion.minor()).toList();
        }
        if (versions.contains(minVersion)) {
            return Collections.singletonList(minVersion);
        }
        return Collections.emptyList();
    }

    public static CompatibleRange getCompatibleRange(SemanticVersion version, PackageLockingMode packageLockingMode) {
        if (version == null) {
            return CompatibleRange.LATEST;
        }
        if (packageLockingMode.equals((Object)PackageLockingMode.HARD)) {
            return CompatibleRange.EXACT;
        }
        if (packageLockingMode.equals((Object)PackageLockingMode.MEDIUM) || version.isInitialVersion()) {
            return CompatibleRange.LOCK_MINOR;
        }
        return CompatibleRange.LOCK_MAJOR;
    }

    public static Map<String, byte[]> getAllGeneratedResources(Path generatedResourcesPath) {
        HashMap<String, byte[]> resourcesMap = new HashMap<String, byte[]>();
        if (Files.isDirectory(generatedResourcesPath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(generatedResourcesPath, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                for (Path entry : stream) {
                    Path entryName = entry.getFileName();
                    if (entryName == null) continue;
                    String resourcePath = "resources/" + entryName.toString();
                    resourcesMap.put(resourcePath, Files.readAllBytes(entry));
                }
            }
            catch (IOException e) {
                throw new ProjectException("An error occurred while reading the cached resources from: " + String.valueOf(generatedResourcesPath), e);
            }
        }
        return resourcesMap;
    }

    public static String getConflictingResourcesMsg(String packageDesc, List<String> conflictingResourceFiles) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("failed due to generated resources conflicting with the resources in the current package '").append(packageDesc).append("'. Conflicting resource files:");
        if (conflictingResourceFiles != null && !conflictingResourceFiles.isEmpty()) {
            for (String file : conflictingResourceFiles) {
                errorMessage.append("\n").append(file);
            }
        }
        return errorMessage.toString();
    }

    public static String getResourcesPath() {
        return "'resources/.*'";
    }

    public static void addMiscellaneousProjectDiagnostics(Diagnostic diagnosticMessage) {
        projectLoadingDiagnostic.add(diagnosticMessage);
    }

    public static List<Diagnostic> getProjectLoadingDiagnostic() {
        return projectLoadingDiagnostic;
    }

    public static void clearDiagnostics() {
        projectLoadingDiagnostic.clear();
    }

    public static boolean containsDefaultModuleService(Package pkg) {
        Module defaultModule = pkg.getDefaultModule();
        for (DocumentId documentId : pkg.getDefaultModule().documentIds()) {
            ModulePartNode rootNode = (ModulePartNode)defaultModule.document(documentId).syntaxTree().rootNode();
            if (!rootNode.members().stream().anyMatch(member -> member.kind() == SyntaxKind.SERVICE_DECLARATION)) continue;
            return true;
        }
        return false;
    }

    public static enum CompatibleRange {
        LATEST,
        LOCK_MAJOR,
        LOCK_MINOR,
        EXACT;

    }
}

