/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.symbols;

public enum SymbolOrigin {
    BUILTIN{

        @Override
        public SymbolOrigin toBIROrigin() {
            return BUILTIN;
        }

        @Override
        public byte value() {
            return 1;
        }
    }
    ,
    SOURCE{

        @Override
        public SymbolOrigin toBIROrigin() {
            return COMPILED_SOURCE;
        }

        @Override
        public byte value() {
            return 2;
        }
    }
    ,
    COMPILED_SOURCE{

        @Override
        public SymbolOrigin toBIROrigin() {
            return COMPILED_SOURCE;
        }

        @Override
        public byte value() {
            return 3;
        }
    }
    ,
    VIRTUAL{

        @Override
        public SymbolOrigin toBIROrigin() {
            return VIRTUAL;
        }

        @Override
        public byte value() {
            return 4;
        }
    };


    public abstract SymbolOrigin toBIROrigin();

    public abstract byte value();

    public static SymbolOrigin toOrigin(byte value) {
        return switch (value) {
            case 1 -> BUILTIN;
            case 2 -> SOURCE;
            case 3 -> COMPILED_SOURCE;
            case 4 -> VIRTUAL;
            default -> throw new IllegalStateException("Invalid symbol origin value: " + value);
        };
    }
}

