/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.repository.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.commons.lang3.SystemUtils;
import org.ballerinalang.repository.fs.GeneralFSPackageRepository;
import org.wso2.ballerinalang.compiler.util.Name;

public class ClasspathPackageRepository
extends GeneralFSPackageRepository {
    private static final String JAR_URI_SCHEME = "jar";
    private static final String JAR_SOURCE_LOCATION = "/META-INF/";

    public ClasspathPackageRepository(Class<? extends Object> providerClassRef, String orgName) {
        super(ClasspathPackageRepository.generatePath(providerClassRef, orgName), new Name(orgName));
    }

    private static Path generatePath(Class<? extends Object> providerClassRef, String orgName) {
        try {
            URI pathUri;
            URI classURI = providerClassRef.getProtectionDomain().getCodeSource().getLocation().toURI();
            String classPath = classURI.getPath();
            if (SystemUtils.IS_OS_WINDOWS) {
                classPath = classPath.replace(" ", "%20");
            }
            String basePath = JAR_SOURCE_LOCATION + orgName;
            if (classPath.endsWith(".jar")) {
                pathUri = URI.create("jar:file:" + classPath + "!" + basePath);
            } else {
                if (classPath.endsWith(File.separator)) {
                    classPath = classPath.substring(0, classPath.length() - 1);
                }
                pathUri = URI.create("file:" + classPath + basePath);
            }
            ClasspathPackageRepository.initFS(pathUri);
            return Path.of(pathUri);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void initFS(URI uri) throws IOException {
        if (JAR_URI_SCHEME.equals(uri.getScheme())) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            try {
                FileSystems.newFileSystem(uri, env);
            }
            catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "ClasspathModuleRepository: " + String.valueOf(this.basePath.toUri());
    }
}

