/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.toml.model;

import java.util.Objects;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.toml.model.DependencyMetadata;

public class Dependency {
    private String moduleID;
    private DependencyMetadata metadata;

    public String getModuleID() {
        return this.moduleID == null ? null : this.moduleID.replaceAll("^\"|\"$", "");
    }

    public void setModuleID(String moduleID) {
        this.moduleID = moduleID.replaceAll("^\"|\"$", "");
    }

    public String getOrgName() {
        String[] moduleIDParts = this.getModuleID().split("/");
        if (moduleIDParts.length == 2) {
            return moduleIDParts[0];
        }
        throw new BLangCompilerException("invalid dependency name. dependency should be in the format <org-name>/<module-name>.");
    }

    public String getModuleName() {
        String[] moduleIDParts = this.getModuleID().split("/");
        if (moduleIDParts.length == 2) {
            return moduleIDParts[1];
        }
        throw new BLangCompilerException("invalid dependency name. dependency should be in the format <org-name>/<module-name>.");
    }

    public DependencyMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(DependencyMetadata metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        return null != this.metadata && null != this.metadata.getVersion() && !this.metadata.getVersion().trim().isEmpty() ? this.getModuleID() + ":" + this.metadata.getVersion() : this.getModuleID();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency that = (Dependency)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }
}

