/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util;

import org.wso2.ballerinalang.compiler.util.Names;

public final class Transactions {
    public static final String TRANSACTION_ANNOTATION_NAME = "transactions" + String.valueOf(Names.ORG_NAME_SEPARATOR) + "Participant";
    public static final String TRX_ONCOMMIT_FUNC = "oncommit";
    public static final String TRX_ONABORT_FUNC = "onabort";

    private Transactions() {
    }

    public static boolean isTransactionsAnnotation(String orgName, String pkgName) {
        StringBuilder pathBuilder = new StringBuilder();
        String createdPath = pathBuilder.append(orgName).append(Names.ORG_NAME_SEPARATOR).append(pkgName).toString();
        return createdPath.equals(TRANSACTION_ANNOTATION_NAME);
    }

    public static enum TransactionStatus {
        BLOCK_END(0),
        FAILED(-1),
        ABORTED(-2),
        END(1);

        private final int status;

        private TransactionStatus(int value) {
            this.status = value;
        }

        public int value() {
            return this.status;
        }

        public static TransactionStatus getConst(int statusValue) {
            return switch (statusValue) {
                case 0 -> BLOCK_END;
                case 1 -> END;
                case -1 -> FAILED;
                case -2 -> ABORTED;
                default -> throw new IllegalArgumentException();
            };
        }
    }

    public static enum TransactionType {
        INITIATOR(0),
        PARTICIPANT(1),
        REMOTE_PARTICIPANT(2);

        public final int value;

        private TransactionType(int val) {
            this.value = val;
        }
    }
}

