/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.identifier.Utils;
import io.ballerina.types.Env;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.InitMethodGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Lists;

public final class JvmDesugarPhase {
    private JvmDesugarPhase() {
    }

    public static void addDefaultableBooleanVarsToSignature(Env env, BIRNode.BIRFunction func) {
        BInvokableType type = func.type = new BInvokableType(env, func.type.paramTypes, func.type.restType, func.type.retType, func.type.tsymbol);
        func.type.paramTypes = JvmDesugarPhase.updateParamTypesWithDefaultableBooleanVar(func.type.paramTypes, type.restType);
    }

    public static BIRNode.BIRBasicBlock insertAndGetNextBasicBlock(List<BIRNode.BIRBasicBlock> basicBlocks, InitMethodGen initMethodGen) {
        BIRNode.BIRBasicBlock nextbb = new BIRNode.BIRBasicBlock("wrapperGen", JvmDesugarPhase.getNextDesugarBBId(initMethodGen));
        basicBlocks.add(nextbb);
        return nextbb;
    }

    public static int getNextDesugarBBId(InitMethodGen initMethodGen) {
        return initMethodGen.incrementAndGetNextId();
    }

    private static List<BType> updateParamTypesWithDefaultableBooleanVar(List<BType> funcParams, BType restType) {
        int counter;
        int size;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        int n = size = funcParams == null ? 0 : funcParams.size();
        for (counter = 0; counter < size; ++counter) {
            paramTypes.add(counter, funcParams.get(counter));
        }
        if (restType != null) {
            paramTypes.add(counter, restType);
        }
        return paramTypes;
    }

    static void rewriteRecordInits(Env env, List<BIRNode.BIRTypeDefinition> typeDefs) {
        for (BIRNode.BIRTypeDefinition typeDef : typeDefs) {
            BType recordType = JvmCodeGenUtil.getImpliedType(typeDef.type);
            if (recordType.tag != 12) continue;
            List<BIRNode.BIRFunction> attachFuncs = typeDef.attachedFuncs;
            for (BIRNode.BIRFunction func : attachFuncs) {
                JvmDesugarPhase.rewriteRecordInitFunction(env, func, (BRecordType)recordType);
            }
        }
    }

    private static void rewriteRecordInitFunction(Env env, BIRNode.BIRFunction func, BRecordType recordType) {
        BIRNode.BIRVariableDcl receiver = func.receiver;
        func.name = new Name(JvmCodeGenUtil.toNameString(recordType) + func.name.value);
        receiver.kind = VarKind.ARG;
        String paramName = "$_" + receiver.name.value;
        receiver.name = new Name(paramName);
        BIRNode.BIRFunctionParameter selfParam = new BIRNode.BIRFunctionParameter(null, receiver.type, receiver.name, receiver.scope, VarKind.ARG, paramName, false, false);
        List<BType> updatedParamTypes = Lists.of(receiver.type);
        updatedParamTypes.addAll(func.type.paramTypes);
        func.type = new BInvokableType(env, updatedParamTypes, func.type.restType, func.type.retType, null);
        List<BIRNode.BIRVariableDcl> localVars = func.localVars;
        ArrayList<BIRNode.BIRVariableDcl> updatedLocalVars = new ArrayList<BIRNode.BIRVariableDcl>();
        updatedLocalVars.add(localVars.getFirst());
        updatedLocalVars.add(selfParam);
        for (int index = 1; index < localVars.size(); ++index) {
            updatedLocalVars.add(localVars.get(index));
        }
        func.localVars = updatedLocalVars;
    }

    static HashMap<String, String> encodeModuleIdentifiers(BIRNode.BIRPackage module) {
        HashMap<String, String> encodedVsInitialIds = new HashMap<String, String>();
        JvmDesugarPhase.encodePackageIdentifiers(module.packageID, encodedVsInitialIds);
        JvmDesugarPhase.encodeGlobalVariableIdentifiers(module.globalVars, encodedVsInitialIds);
        JvmDesugarPhase.encodeImportedGlobalVariableIdentifiers(module.importedGlobalVarsDummyVarDcls, encodedVsInitialIds);
        JvmDesugarPhase.encodeFunctionIdentifiers(module.functions, encodedVsInitialIds);
        JvmDesugarPhase.encodeTypeDefIdentifiers(module.typeDefs, encodedVsInitialIds);
        return encodedVsInitialIds;
    }

    private static void encodePackageIdentifiers(PackageID packageID, HashMap<String, String> encodedVsInitialIds) {
        packageID.orgName = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(packageID.orgName.value, encodedVsInitialIds));
        packageID.name = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(packageID.name.value, encodedVsInitialIds));
    }

    private static void encodeTypeDefIdentifiers(List<BIRNode.BIRTypeDefinition> typeDefs, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRTypeDefinition typeDefinition : typeDefs) {
            typeDefinition.type.tsymbol.name = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(typeDefinition.type.tsymbol.name.value, encodedVsInitialIds));
            typeDefinition.internalName = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(typeDefinition.internalName.value, encodedVsInitialIds));
            if (typeDefinition.referenceType != null) {
                typeDefinition.referenceType.tsymbol.name = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(typeDefinition.referenceType.tsymbol.name.value, encodedVsInitialIds));
            }
            JvmDesugarPhase.encodeFunctionIdentifiers(typeDefinition.attachedFuncs, encodedVsInitialIds);
            BType bType = JvmCodeGenUtil.getImpliedType(typeDefinition.type);
            if (bType.tag == 34) {
                BObjectType objectType = (BObjectType)bType;
                BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)bType.tsymbol;
                if (objectTypeSymbol.attachedFuncs != null) {
                    JvmDesugarPhase.encodeAttachedFunctionIdentifiers(objectTypeSymbol.attachedFuncs, encodedVsInitialIds);
                }
                for (BField field : objectType.fields.values()) {
                    field.name = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(field.name.value, encodedVsInitialIds));
                }
            }
            if (bType.tag != 12) continue;
            BRecordType recordType = (BRecordType)bType;
            for (BField field : recordType.fields.values()) {
                field.name = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(field.name.value, encodedVsInitialIds));
            }
        }
    }

    private static void encodeFunctionIdentifiers(List<BIRNode.BIRFunction> functions, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRFunction function : functions) {
            function.name = Names.fromString(JvmDesugarPhase.encodeFunctionIdentifier(function.name.value, encodedVsInitialIds));
            for (BIRNode.BIRVariableDcl bIRVariableDcl : function.localVars) {
                if (bIRVariableDcl.metaVarName == null) continue;
                bIRVariableDcl.metaVarName = JvmDesugarPhase.encodeNonFunctionIdentifier(bIRVariableDcl.metaVarName, encodedVsInitialIds);
            }
            for (BIRNode.BIRParameter bIRParameter : function.requiredParams) {
                bIRParameter.name = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(bIRParameter.name.value, encodedVsInitialIds));
            }
            if (function.type.tsymbol != null) {
                for (BVarSymbol bVarSymbol : ((BInvokableTypeSymbol)function.type.tsymbol).params) {
                    bVarSymbol.name = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(bVarSymbol.name.value, encodedVsInitialIds));
                }
            }
            JvmDesugarPhase.encodeDefaultFunctionName(function.type, encodedVsInitialIds);
            JvmDesugarPhase.encodeWorkerName(function, encodedVsInitialIds);
        }
    }

    private static void encodeDefaultFunctionName(BInvokableType type, HashMap<String, String> encodedVsInitialIds) {
        BInvokableTypeSymbol typeSymbol = (BInvokableTypeSymbol)type.tsymbol;
        if (typeSymbol == null) {
            return;
        }
        for (BInvokableSymbol defaultFunc : typeSymbol.defaultValues.values()) {
            defaultFunc.name = Names.fromString(JvmDesugarPhase.encodeFunctionIdentifier(defaultFunc.name.value, encodedVsInitialIds));
        }
    }

    private static void encodeWorkerName(BIRNode.BIRFunction function, HashMap<String, String> encodedVsInitialIds) {
        if (function.workerName != null) {
            function.workerName = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(function.workerName.value, encodedVsInitialIds));
        }
    }

    private static void encodeAttachedFunctionIdentifiers(List<BAttachedFunction> functions, HashMap<String, String> encodedVsInitialIds) {
        for (BAttachedFunction function : functions) {
            function.funcName = Names.fromString(JvmDesugarPhase.encodeFunctionIdentifier(function.funcName.value, encodedVsInitialIds));
        }
    }

    private static void encodeGlobalVariableIdentifiers(List<BIRNode.BIRGlobalVariableDcl> globalVars, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRGlobalVariableDcl globalVar : globalVars) {
            globalVar.name = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(globalVar.name.value, encodedVsInitialIds));
        }
    }

    private static void encodeImportedGlobalVariableIdentifiers(Set<BIRNode.BIRGlobalVariableDcl> globalVars, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRGlobalVariableDcl globalVar : globalVars) {
            globalVar.name = Names.fromString(JvmDesugarPhase.encodeNonFunctionIdentifier(globalVar.name.value, encodedVsInitialIds));
        }
    }

    static void replaceEncodedModuleIdentifiers(BIRNode.BIRPackage module, HashMap<String, String> encodedVsInitialIds) {
        JvmDesugarPhase.replaceEncodedPackageIdentifiers(module.packageID, encodedVsInitialIds);
        JvmDesugarPhase.replaceEncodedGlobalVariableIdentifiers(module.globalVars, encodedVsInitialIds);
        JvmDesugarPhase.replaceEncodedFunctionIdentifiers(module.functions, encodedVsInitialIds);
        JvmDesugarPhase.replaceEncodedTypeDefIdentifiers(module.typeDefs, encodedVsInitialIds);
    }

    private static void replaceEncodedPackageIdentifiers(PackageID packageID, HashMap<String, String> encodedVsInitialIds) {
        packageID.orgName = JvmDesugarPhase.getInitialIdString(packageID.orgName, encodedVsInitialIds);
        packageID.name = JvmDesugarPhase.getInitialIdString(packageID.name, encodedVsInitialIds);
    }

    private static void replaceEncodedTypeDefIdentifiers(List<BIRNode.BIRTypeDefinition> typeDefs, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRTypeDefinition typeDefinition : typeDefs) {
            typeDefinition.type.tsymbol.name = JvmDesugarPhase.getInitialIdString(typeDefinition.type.tsymbol.name, encodedVsInitialIds);
            typeDefinition.internalName = JvmDesugarPhase.getInitialIdString(typeDefinition.internalName, encodedVsInitialIds);
            JvmDesugarPhase.replaceEncodedFunctionIdentifiers(typeDefinition.attachedFuncs, encodedVsInitialIds);
            BType bType = JvmCodeGenUtil.getImpliedType(typeDefinition.type);
            if (bType.tag == 34) {
                BObjectType objectType = (BObjectType)bType;
                BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)bType.tsymbol;
                if (objectTypeSymbol.attachedFuncs != null) {
                    JvmDesugarPhase.replaceEncodedAttachedFunctionIdentifiers(objectTypeSymbol.attachedFuncs, encodedVsInitialIds);
                }
                for (BField field : objectType.fields.values()) {
                    field.name = JvmDesugarPhase.getInitialIdString(field.name, encodedVsInitialIds);
                }
            }
            if (bType.tag != 12) continue;
            BRecordType recordType = (BRecordType)bType;
            for (BField field : recordType.fields.values()) {
                field.name = JvmDesugarPhase.getInitialIdString(field.name, encodedVsInitialIds);
            }
        }
    }

    private static void replaceEncodedFunctionIdentifiers(List<BIRNode.BIRFunction> functions, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRFunction function : functions) {
            function.name = JvmDesugarPhase.getInitialIdString(function.name, encodedVsInitialIds);
            for (BIRNode.BIRParameter bIRParameter : function.requiredParams) {
                bIRParameter.name = JvmDesugarPhase.getInitialIdString(bIRParameter.name, encodedVsInitialIds);
            }
            if (function.type.tsymbol != null) {
                for (BVarSymbol bVarSymbol : ((BInvokableTypeSymbol)function.type.tsymbol).params) {
                    bVarSymbol.name = JvmDesugarPhase.getInitialIdString(bVarSymbol.name, encodedVsInitialIds);
                }
            }
            JvmDesugarPhase.replaceEncodedDefaultFunctionName(function.type, encodedVsInitialIds);
            JvmDesugarPhase.replaceEncodedWorkerName(function, encodedVsInitialIds);
        }
    }

    private static void replaceEncodedDefaultFunctionName(BInvokableType type, HashMap<String, String> encodedVsInitialIds) {
        BInvokableTypeSymbol typeSymbol = (BInvokableTypeSymbol)type.tsymbol;
        if (typeSymbol == null) {
            return;
        }
        for (BInvokableSymbol defaultFunc : typeSymbol.defaultValues.values()) {
            defaultFunc.name = JvmDesugarPhase.getInitialIdString(defaultFunc.name, encodedVsInitialIds);
        }
    }

    private static void replaceEncodedWorkerName(BIRNode.BIRFunction function, HashMap<String, String> encodedVsInitialIds) {
        if (function.workerName != null) {
            function.workerName = JvmDesugarPhase.getInitialIdString(function.workerName, encodedVsInitialIds);
        }
    }

    private static void replaceEncodedAttachedFunctionIdentifiers(List<BAttachedFunction> functions, HashMap<String, String> encodedVsInitialIds) {
        for (BAttachedFunction function : functions) {
            function.funcName = JvmDesugarPhase.getInitialIdString(function.funcName, encodedVsInitialIds);
        }
    }

    private static void replaceEncodedGlobalVariableIdentifiers(List<BIRNode.BIRGlobalVariableDcl> globalVars, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRGlobalVariableDcl globalVar : globalVars) {
            globalVar.name = JvmDesugarPhase.getInitialIdString(globalVar.name, encodedVsInitialIds);
        }
    }

    private static String encodeFunctionIdentifier(String identifier, HashMap<String, String> encodedVsInitialIds) {
        if (encodedVsInitialIds.containsKey(identifier)) {
            return identifier;
        }
        String encodedString = Utils.encodeFunctionIdentifier((String)identifier);
        encodedVsInitialIds.putIfAbsent(encodedString, identifier);
        return encodedString;
    }

    private static String encodeNonFunctionIdentifier(String identifier, HashMap<String, String> encodedVsInitialIds) {
        if (encodedVsInitialIds.containsKey(identifier)) {
            return identifier;
        }
        String encodedString = Utils.encodeNonFunctionIdentifier((String)identifier);
        encodedVsInitialIds.putIfAbsent(encodedString, identifier);
        return encodedString;
    }

    private static Name getInitialIdString(Name encodedIdString, HashMap<String, String> encodedVsInitialIds) {
        String initialString = encodedVsInitialIds.get(encodedIdString.value);
        if (initialString != null) {
            return Names.fromString(initialString);
        }
        return encodedIdString;
    }
}

