/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.identifier.Utils;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.PredefinedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JIMethodCall;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodCallInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

class JvmObservabilityGen {
    private static final String ENTRY_POINT_MAIN_METHOD_NAME = "main";
    private static final String NEW_BB_PREFIX = "observabilityDesugaredBB";
    private static final String INVOCATION_INSTRUMENTATION_TYPE = "invocation";
    private static final String FUNC_BODY_INSTRUMENTATION_TYPE = "funcBody";
    private static final String FILE_NAME_STRING = "fileName";
    private static final String START_LINE_STRING = "startLine";
    private static final String START_COLUMN_STRING = "startCol";
    private static final Location COMPILE_TIME_CONST_POS = new BLangDiagnosticLocation(null, -1, -1, -1, -1, 0, 0);
    private final PackageCache packageCache;
    private final SymbolTable symbolTable;
    private int lambdaIndex;
    private int desugaredBBIndex;
    private int localVarIndex;
    private int constantIndex;
    private int defaultServiceIndex;
    private final Map<Object, BIROperand> compileTimeConstants = new HashMap<Object, BIROperand>();
    private final Map<Name, String> svcAttachPoints = new HashMap<Name, String>();
    private final Map<String, BIROperand> tempLocalVarsMap = new HashMap<String, BIROperand>();
    private final Map<BIRNode.BIRBasicBlock, List<BIRNode.BIRBasicBlock>> predecessorMap = new HashMap<BIRNode.BIRBasicBlock, List<BIRNode.BIRBasicBlock>>();

    JvmObservabilityGen(PackageCache packageCache, SymbolTable symbolTable) {
        this.packageCache = packageCache;
        this.symbolTable = symbolTable;
        this.lambdaIndex = 0;
        this.desugaredBBIndex = 0;
        this.constantIndex = 0;
        this.localVarIndex = 0;
        this.defaultServiceIndex = 0;
    }

    public void instrumentPackage(BIRNode.BIRPackage pkg) {
        this.initializeTempLocalVariables();
        for (int i = 0; i < pkg.functions.size(); ++i) {
            this.localVarIndex = 0;
            BIRNode.BIRFunction func = pkg.functions.get(i);
            if (ENTRY_POINT_MAIN_METHOD_NAME.equals(func.name.getValue())) {
                this.rewriteControlFlowInvocation(func, pkg);
            }
            this.rewriteAsyncInvocations(func, null, pkg);
            this.rewriteObservableFunctionInvocations(func, pkg);
            if (ENTRY_POINT_MAIN_METHOD_NAME.equals(func.name.getValue())) {
                this.rewriteObservableFunctionBody(func, pkg, null, func.name.getValue(), null, false, false, true, false);
                continue;
            }
            if ((func.flags & 0x800000L) != 0x800000L) continue;
            this.rewriteObservableFunctionBody(func, pkg, null, func.workerName.getValue(), null, false, false, false, true);
        }
        for (BIRNode.BIRServiceDeclaration serviceDecl : pkg.serviceDecls) {
            List<String> attachPoint = serviceDecl.attachPoint;
            String attachPointLiteral = serviceDecl.attachPointLiteral;
            if (attachPoint != null) {
                this.svcAttachPoints.put(serviceDecl.associatedClassName, "/" + String.join((CharSequence)"/", attachPoint));
                continue;
            }
            if (attachPointLiteral == null) continue;
            this.svcAttachPoints.put(serviceDecl.associatedClassName, attachPointLiteral);
        }
        for (BIRNode.BIRTypeDefinition typeDef : pkg.typeDefs) {
            BType bType = JvmCodeGenUtil.getImpliedType(typeDef.type);
            if ((typeDef.flags & 0x10000000L) != 0x10000000L && bType.tag == 34) continue;
            boolean isService = (bType.getFlags() & 0x40000L) == 262144L;
            String serviceName = null;
            if (isService) {
                for (BIRNode.BIRAnnotationAttachment annotationAttachment : typeDef.annotAttachments) {
                    if (!"display".equals(annotationAttachment.annotTagRef.getValue())) continue;
                    BIRNode.ConstValue annotValue = ((BIRNode.BIRConstAnnotationAttachment)annotationAttachment).annotValue;
                    Map annotationMap = (Map)annotValue.value;
                    serviceName = ((BIRNode.ConstValue)annotationMap.get((Object)"label")).value.toString();
                    break;
                }
                if (serviceName == null) {
                    String basePath = this.svcAttachPoints.get(typeDef.name);
                    serviceName = basePath == null ? pkg.packageID.orgName.getValue() + "_" + pkg.packageID.name.getValue() + "_svc_" + this.defaultServiceIndex++ : Utils.unescapeBallerina((String)basePath);
                }
            }
            for (int i = 0; i < typeDef.attachedFuncs.size(); ++i) {
                BIRNode.BIRFunction func = typeDef.attachedFuncs.get(i);
                this.localVarIndex = 0;
                if (isService && ((func.flags & 0x20000L) == 131072L || (func.flags & 0x8000L) == 32768L)) {
                    this.rewriteControlFlowInvocation(func, pkg);
                }
                this.rewriteAsyncInvocations(func, typeDef, pkg);
                this.rewriteObservableFunctionInvocations(func, pkg);
                if (!isService) continue;
                if ((func.flags & 0x20000L) == 131072L) {
                    this.rewriteObservableFunctionBody(func, pkg, typeDef, func.name.getValue(), serviceName, true, false, false, false);
                    continue;
                }
                if ((func.flags & 0x8000L) != 32768L) continue;
                this.rewriteObservableFunctionBody(func, pkg, typeDef, func.name.getValue(), serviceName, false, true, false, false);
            }
        }
        BIRNode.BIRFunction initFunc = pkg.functions.getFirst();
        BIRNode.BIRBasicBlock constInitBB = initFunc.basicBlocks.getFirst();
        for (Map.Entry<Object, BIROperand> entry : this.compileTimeConstants.entrySet()) {
            BIROperand operand = entry.getValue();
            BIRNonTerminator.ConstantLoad constLoadIns = new BIRNonTerminator.ConstantLoad(COMPILE_TIME_CONST_POS, entry.getKey(), operand.variableDcl.type, operand);
            constInitBB.instructions.add(constLoadIns);
        }
    }

    private void rewriteControlFlowInvocation(BIRNode.BIRFunction func, BIRNode.BIRPackage pkg) {
        this.populatePredecessorMap(func.basicBlocks);
        for (Map.Entry<BIRNode.BIRBasicBlock, List<BIRNode.BIRBasicBlock>> entry : this.predecessorMap.entrySet()) {
            BIRNode.BIRBasicBlock currentBB = entry.getKey();
            Location desugaredPos = this.getDesugaredPosition(currentBB);
            if (desugaredPos == null || desugaredPos.lineRange().startLine().line() < 0) continue;
            List<BIRNode.BIRBasicBlock> predecessors = entry.getValue();
            int callInsOffset = 0;
            if (!this.desugaredPosAlreadyLoaded(desugaredPos, predecessors)) {
                this.updatePositionArgsConstLoadIns(desugaredPos, currentBB);
                callInsOffset = 2;
            }
            this.injectCheckpointCall(currentBB, pkg, callInsOffset);
        }
    }

    private boolean desugaredPosAlreadyLoaded(Location desugaredPos, List<BIRNode.BIRBasicBlock> predecessors) {
        for (BIRNode.BIRBasicBlock bb : predecessors) {
            Location predecessorDesugaredPos = this.getDesugaredPosition(bb);
            if (predecessorDesugaredPos == null || !predecessorDesugaredPos.equals((Object)desugaredPos)) continue;
            return true;
        }
        return false;
    }

    private void injectCheckpointCall(BIRNode.BIRBasicBlock currentBB, BIRNode.BIRPackage pkg, int offset) {
        BIROperand pkgOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, this.generatePackageId(pkg.packageID));
        BIROperand fileNameOperand = this.tempLocalVarsMap.get(FILE_NAME_STRING);
        BIROperand startLineOperand = this.tempLocalVarsMap.get(START_LINE_STRING);
        BIROperand startColOperand = this.tempLocalVarsMap.get(START_COLUMN_STRING);
        JMethodCallInstruction recordCheckPointCallIns = new JMethodCallInstruction(null);
        recordCheckPointCallIns.invocationType = 184;
        recordCheckPointCallIns.jClassName = "io/ballerina/runtime/observability/ObserveUtils";
        recordCheckPointCallIns.jMethodVMSig = "(Lio/ballerina/runtime/api/Environment;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;JJ)V";
        recordCheckPointCallIns.name = "recordCheckpoint";
        recordCheckPointCallIns.args = new ArrayList<BIROperand>(Arrays.asList(pkgOperand, fileNameOperand, startLineOperand, startColOperand));
        currentBB.instructions.add(offset, recordCheckPointCallIns);
    }

    private Location getDesugaredPosition(BIRNode.BIRBasicBlock basicBlock) {
        for (BIRNonTerminator instruction : basicBlock.instructions) {
            if (instruction.pos == null) continue;
            return instruction.pos;
        }
        return basicBlock.terminator.pos;
    }

    private void populatePredecessorMap(List<BIRNode.BIRBasicBlock> basicBlocks) {
        this.predecessorMap.clear();
        for (BIRNode.BIRBasicBlock basicBlock : basicBlocks) {
            this.predecessorMap.computeIfAbsent(basicBlock, k -> new ArrayList());
            for (BIRNode.BIRBasicBlock bb : basicBlock.terminator.getNextBasicBlocks()) {
                this.predecessorMap.computeIfAbsent(bb, k -> new ArrayList()).add(basicBlock);
            }
        }
    }

    private void rewriteAsyncInvocations(BIRNode.BIRFunction func, BIRNode.BIRTypeDefinition attachedTypeDef, BIRNode.BIRPackage pkg) {
        List<BIRNode.BIRFunction> scopeFunctionsList;
        BTypeSymbol functionOwner;
        PackageID packageID = pkg.packageID;
        Name org = new Name(Utils.decodeIdentifier((String)packageID.orgName.getValue()));
        Name module = new Name(Utils.decodeIdentifier((String)packageID.name.getValue()));
        PackageID currentPkgId = new PackageID(org, module, module, packageID.version, packageID.sourceFileName, packageID.sourceRoot, packageID.isTestPkg, packageID.skipTests);
        if (attachedTypeDef == null) {
            functionOwner = this.packageCache.getSymbol(currentPkgId);
            scopeFunctionsList = pkg.functions;
        } else {
            functionOwner = attachedTypeDef.type.tsymbol;
            scopeFunctionsList = attachedTypeDef.attachedFuncs;
        }
        for (BIRNode.BIRBasicBlock currentBB : func.basicBlocks) {
            if (currentBB.terminator.kind != InstructionKind.ASYNC_CALL || !this.isObservable((BIRTerminator.AsyncCall)currentBB.terminator)) continue;
            BIRTerminator.AsyncCall asyncCallIns = (BIRTerminator.AsyncCall)currentBB.terminator;
            BType returnType = ((BFutureType)asyncCallIns.lhsOp.variableDcl.type).constraint;
            ArrayList<BType> argTypes = new ArrayList<BType>();
            for (BIROperand arg : asyncCallIns.args) {
                BType type = arg.variableDcl.type;
                argTypes.add(type);
            }
            Name lambdaName = new Name("$lambda$observability" + this.lambdaIndex++ + "$" + asyncCallIns.name.getValue().replace(".", "_"));
            BInvokableType bInvokableType = new BInvokableType(this.symbolTable.typeEnv(), argTypes, null, returnType, null);
            BIRNode.BIRFunction desugaredFunc = new BIRNode.BIRFunction(asyncCallIns.pos, lambdaName, 0L, bInvokableType, func.workerName, 0, SymbolOrigin.VIRTUAL);
            desugaredFunc.receiver = func.receiver;
            scopeFunctionsList.add(desugaredFunc);
            BIRNode.BIRVariableDcl funcReturnVariableDcl = new BIRNode.BIRVariableDcl(returnType, new Name("$" + lambdaName.getValue() + "$retVal"), VarScope.FUNCTION, VarKind.RETURN);
            BIROperand funcReturnOperand = new BIROperand(funcReturnVariableDcl);
            desugaredFunc.localVars.add(funcReturnVariableDcl);
            desugaredFunc.returnVariable = funcReturnVariableDcl;
            BInvokableSymbol invokableSymbol = new BInvokableSymbol(820L, 0L, lambdaName, currentPkgId, (BType)bInvokableType, (BSymbol)functionOwner, desugaredFunc.pos, SymbolOrigin.VIRTUAL);
            invokableSymbol.retType = funcReturnVariableDcl.type;
            invokableSymbol.kind = SymbolKind.FUNCTION;
            ArrayList<BVarSymbol> list = new ArrayList<BVarSymbol>();
            for (BIROperand arg : asyncCallIns.args) {
                BVarSymbol bVarSymbol = new BVarSymbol(0L, arg.variableDcl.name, currentPkgId, arg.variableDcl.type, invokableSymbol, arg.pos, SymbolOrigin.VIRTUAL);
                list.add(bVarSymbol);
            }
            invokableSymbol.params = list;
            invokableSymbol.scope = new Scope(invokableSymbol);
            invokableSymbol.params.forEach(param -> invokableSymbol.scope.define(param.name, (BSymbol)param));
            if (attachedTypeDef == null) {
                functionOwner.scope.define(lambdaName, invokableSymbol);
            }
            ArrayList<BIROperand> funcParamOperands = new ArrayList<BIROperand>();
            Name selfArgName = new Name("%self");
            for (int i = 0; i < asyncCallIns.args.size(); ++i) {
                BIRNode.BIRFunctionParameter funcParam;
                BIROperand arg = (BIROperand)asyncCallIns.args.get(i);
                if (arg.variableDcl.kind == VarKind.SELF) {
                    funcParam = new BIRNode.BIRFunctionParameter(asyncCallIns.pos, arg.variableDcl.type, selfArgName, VarScope.FUNCTION, VarKind.SELF, selfArgName.getValue(), false, false);
                } else {
                    Name argName = new Name("$funcParam%d" + i);
                    funcParam = new BIRNode.BIRFunctionParameter(asyncCallIns.pos, arg.variableDcl.type, argName, VarScope.FUNCTION, VarKind.ARG, argName.getValue(), false, false);
                    desugaredFunc.localVars.add(funcParam);
                    desugaredFunc.parameters.add(funcParam);
                    desugaredFunc.requiredParams.add(new BIRNode.BIRParameter(asyncCallIns.pos, argName, 0L));
                    ++desugaredFunc.argsCount;
                }
                funcParamOperands.add(new BIROperand(funcParam));
            }
            BIRNode.BIRBasicBlock callInsBB = this.insertBasicBlock(desugaredFunc, 0);
            BIRNode.BIRBasicBlock returnInsBB = this.insertBasicBlock(desugaredFunc, 1);
            callInsBB.terminator = new BIRTerminator.Call(asyncCallIns.pos, InstructionKind.CALL, asyncCallIns.isVirtual, asyncCallIns.calleePkg, asyncCallIns.name, funcParamOperands, funcReturnOperand, returnInsBB, asyncCallIns.calleeAnnotAttachments, asyncCallIns.calleeFlags);
            returnInsBB.terminator = new BIRTerminator.Return(asyncCallIns.pos);
            asyncCallIns.name = lambdaName;
            asyncCallIns.calleePkg = currentPkgId;
            boolean bl = asyncCallIns.isVirtual = attachedTypeDef != null;
            if (attachedTypeDef == null) continue;
            asyncCallIns.args.addFirst(new BIROperand(new BIRNode.BIRVariableDcl(attachedTypeDef.type, selfArgName, VarScope.FUNCTION, VarKind.SELF)));
        }
    }

    private void rewriteObservableFunctionBody(BIRNode.BIRFunction func, BIRNode.BIRPackage pkg, BIRNode.BIRTypeDefinition attachedTypeDef, String functionName, String serviceName, boolean isResource, boolean isRemote, boolean isMainEntryPoint, boolean isWorker) {
        BIRNode.BIRBasicBlock startBB = func.basicBlocks.getFirst();
        BIRNode.BIRBasicBlock newStartBB = this.insertBasicBlock(func, 1);
        this.swapBasicBlockContent(func, startBB, newStartBB);
        if (isResource || isRemote) {
            String resourcePathOrFunction = functionName;
            String resourceAccessor = null;
            if (isResource) {
                for (BAttachedFunction attachedFunc : ((BClassSymbol)attachedTypeDef.type.tsymbol).attachedFuncs) {
                    if (!Objects.equals(attachedFunc.funcName.getValue(), functionName)) continue;
                    BResourceFunction resourceFunction = (BResourceFunction)attachedFunc;
                    StringBuilder resourcePathOrFunctionBuilder = new StringBuilder();
                    for (BResourcePathSegmentSymbol pathSegmentSym : resourceFunction.pathSegmentSymbols) {
                        resourcePathOrFunctionBuilder.append("/").append(Utils.unescapeBallerina((String)pathSegmentSym.name.getValue()));
                    }
                    resourcePathOrFunction = resourcePathOrFunctionBuilder.toString();
                    resourceAccessor = resourceFunction.accessor.getValue();
                    break;
                }
            }
            this.injectStartResourceObservationCall(func, startBB, serviceName, resourcePathOrFunction, resourceAccessor, isResource, isRemote, pkg, func.pos);
        } else {
            BIROperand objectTypeOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.nilType, null);
            this.injectStartCallableObservationCall(func, startBB, null, false, isMainEntryPoint, isWorker, objectTypeOperand, functionName, pkg, func.pos);
        }
        startBB.terminator.thenBB = newStartBB;
        boolean isErrorCheckRequired = this.isErrorAssignable(func.returnVariable);
        BIROperand returnValOperand = new BIROperand(func.returnVariable);
        for (int i = 1; i < func.basicBlocks.size(); ++i) {
            BIRNode.BIRBasicBlock currentBB = func.basicBlocks.get(i);
            if (currentBB.terminator.kind == InstructionKind.RETURN) {
                if (isErrorCheckRequired) {
                    BIRNode.BIRBasicBlock errorReportBB = this.insertBasicBlock(func, i + 1);
                    BIRNode.BIRBasicBlock observeEndBB = this.insertBasicBlock(func, i + 2);
                    BIRNode.BIRBasicBlock newCurrentBB = this.insertBasicBlock(func, i + 3);
                    this.swapBasicBlockTerminator(func, currentBB, newCurrentBB);
                    this.injectCheckErrorCalls(func, currentBB, errorReportBB, observeEndBB, null, returnValOperand, FUNC_BODY_INSTRUMENTATION_TYPE);
                    this.injectReportErrorCall(func, errorReportBB, null, returnValOperand, FUNC_BODY_INSTRUMENTATION_TYPE);
                    this.injectStopObservationCall(observeEndBB, null);
                    observeEndBB.terminator.thenBB = newCurrentBB;
                    errorReportBB.terminator.thenBB = observeEndBB;
                    i += 3;
                    continue;
                }
                BIRNode.BIRBasicBlock newCurrentBB = this.insertBasicBlock(func, i + 1);
                this.swapBasicBlockTerminator(func, currentBB, newCurrentBB);
                this.injectStopObservationCall(currentBB, null);
                currentBB.terminator.thenBB = newCurrentBB;
                ++i;
                continue;
            }
            if (currentBB.terminator.kind != InstructionKind.PANIC) continue;
            BIRTerminator.Panic panicCall = (BIRTerminator.Panic)currentBB.terminator;
            BIRNode.BIRBasicBlock newCurrentBB = this.insertBasicBlock(func, i + 1);
            this.swapBasicBlockTerminator(func, currentBB, newCurrentBB);
            this.injectStopObservationWithErrorCall(func, currentBB, newCurrentBB.terminator.pos, panicCall.errorOp, FUNC_BODY_INSTRUMENTATION_TYPE);
            currentBB.terminator.thenBB = newCurrentBB;
            ++i;
        }
        int initialBBCount = func.basicBlocks.size();
        BIRNode.BIRBasicBlock startBB2 = func.basicBlocks.getFirst();
        BIRNode.BIRBasicBlock endBB = func.basicBlocks.get(initialBBCount - 1);
        BIRNode.BIRBasicBlock observeEndBB = this.insertBasicBlock(func, initialBBCount);
        BIRNode.BIRBasicBlock rePanicBB = this.insertBasicBlock(func, initialBBCount + 1);
        BIROperand trappedErrorOperand = this.generateTempLocalVariable(func, "functionTrappedError", this.symbolTable.errorOrNilType);
        this.injectStopObservationWithErrorCall(func, observeEndBB, null, trappedErrorOperand, FUNC_BODY_INSTRUMENTATION_TYPE);
        rePanicBB.terminator = new BIRTerminator.Panic(null, trappedErrorOperand);
        BIRNode.BIRErrorEntry errorEntry = new BIRNode.BIRErrorEntry(startBB2, endBB, trappedErrorOperand, observeEndBB);
        func.errorTable.add(errorEntry);
        observeEndBB.terminator.thenBB = rePanicBB;
    }

    private void rewriteObservableFunctionInvocations(BIRNode.BIRFunction func, BIRNode.BIRPackage pkg) {
        for (int i = 0; i < func.basicBlocks.size(); ++i) {
            BIRNode.BIRBasicBlock observeEndBB;
            Object action;
            BIROperand objectTypeOperand;
            BIRNode.BIRBasicBlock currentBB = func.basicBlocks.get(i);
            if (currentBB.terminator.kind != InstructionKind.CALL || !this.isObservable((BIRTerminator.Call)currentBB.terminator)) continue;
            BIRTerminator.Call callIns = (BIRTerminator.Call)currentBB.terminator;
            Location desugaredInsPosition = callIns.pos;
            BIRNode.BIRBasicBlock observeStartBB = this.insertBasicBlock(func, i + 1);
            int newCurrentIndex = i + 2;
            BIRNode.BIRBasicBlock newCurrentBB = this.insertBasicBlock(func, newCurrentIndex);
            this.swapBasicBlockTerminator(func, currentBB, newCurrentBB);
            if (callIns.isVirtual) {
                objectTypeOperand = callIns.args.getFirst();
                if (callIns.name.getValue().contains(".")) {
                    String[] split = callIns.name.getValue().split("\\.");
                    action = split[1];
                } else {
                    action = callIns.name.getValue();
                }
            } else {
                objectTypeOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.nilType, null);
                action = callIns.name.getValue();
            }
            currentBB.terminator = new BIRTerminator.GOTO(desugaredInsPosition, observeStartBB);
            boolean isRemote = callIns.calleeFlags.contains((Object)Flag.REMOTE);
            Location originalInsPos = callIns.pos;
            if (this.isErrorAssignable(callIns.lhsOp.variableDcl)) {
                BIRNode.BIRBasicBlock errorCheckBB = this.insertBasicBlock(func, i + 3);
                BIRNode.BIRBasicBlock errorReportBB = this.insertBasicBlock(func, i + 4);
                observeEndBB = this.insertBasicBlock(func, i + 5);
                this.injectStartCallableObservationCall(func, observeStartBB, desugaredInsPosition, isRemote, false, false, objectTypeOperand, (String)action, pkg, originalInsPos);
                this.injectCheckErrorCalls(func, errorCheckBB, errorReportBB, observeEndBB, desugaredInsPosition, callIns.lhsOp, INVOCATION_INSTRUMENTATION_TYPE);
                this.injectReportErrorCall(func, errorReportBB, desugaredInsPosition, callIns.lhsOp, INVOCATION_INSTRUMENTATION_TYPE);
                this.injectStopObservationCall(observeEndBB, desugaredInsPosition);
                observeEndBB.terminator.thenBB = newCurrentBB.terminator.thenBB;
                errorReportBB.terminator.thenBB = observeEndBB;
                newCurrentBB.terminator.thenBB = errorCheckBB;
                observeStartBB.terminator.thenBB = newCurrentBB;
                i += 5;
            } else {
                observeEndBB = this.insertBasicBlock(func, i + 3);
                this.injectStartCallableObservationCall(func, observeStartBB, desugaredInsPosition, isRemote, false, false, objectTypeOperand, (String)action, pkg, originalInsPos);
                this.injectStopObservationCall(observeEndBB, desugaredInsPosition);
                observeEndBB.terminator.thenBB = newCurrentBB.terminator.thenBB;
                newCurrentBB.terminator.thenBB = observeEndBB;
                observeStartBB.terminator.thenBB = newCurrentBB;
                i += 3;
            }
            this.fixErrorTable(func, currentBB, observeEndBB);
            Optional<Object> existingEE = Optional.empty();
            for (BIRNode.BIRErrorEntry birErrorEntry : func.errorTable) {
                if (!this.isBBCoveredInErrorEntry(birErrorEntry, func.basicBlocks, newCurrentBB)) continue;
                existingEE = Optional.of(birErrorEntry);
                break;
            }
            Location desugaredInsPos = callIns.pos;
            if (existingEE.isPresent()) {
                BIRNode.BIRErrorEntry errorEntry = (BIRNode.BIRErrorEntry)existingEE.get();
                int eeTargetIndex = func.basicBlocks.indexOf(errorEntry.targetBB);
                if (eeTargetIndex == -1) {
                    throw new BLangCompilerException("Invalid Error Entry pointing to non-existent target Basic Block " + String.valueOf(errorEntry.targetBB.id));
                }
                BIRNode.BIRBasicBlock observeEndBB2 = this.insertBasicBlock(func, eeTargetIndex + 1);
                BIRNode.BIRBasicBlock newTargetBB = this.insertBasicBlock(func, eeTargetIndex + 2);
                this.swapBasicBlockContent(func, errorEntry.targetBB, newTargetBB);
                this.injectCheckErrorCalls(func, errorEntry.targetBB, observeEndBB2, newTargetBB, desugaredInsPos, errorEntry.errorOp, INVOCATION_INSTRUMENTATION_TYPE);
                this.injectStopObservationWithErrorCall(func, observeEndBB2, desugaredInsPos, errorEntry.errorOp, INVOCATION_INSTRUMENTATION_TYPE);
                observeEndBB2.terminator.thenBB = newTargetBB;
                this.fixErrorTable(func, errorEntry.targetBB, newTargetBB);
                continue;
            }
            BIRNode.BIRBasicBlock errorCheckBB = this.insertBasicBlock(func, newCurrentIndex + 1);
            BIRNode.BIRBasicBlock observeEndBB3 = this.insertBasicBlock(func, newCurrentIndex + 2);
            BIRNode.BIRBasicBlock rePanicBB = this.insertBasicBlock(func, newCurrentIndex + 3);
            BIROperand trappedErrorOperand = this.generateTempLocalVariable(func, "trappedError", this.symbolTable.errorOrNilType);
            this.injectCheckErrorCalls(func, errorCheckBB, observeEndBB3, newCurrentBB.terminator.thenBB, newCurrentBB.terminator.pos, trappedErrorOperand, INVOCATION_INSTRUMENTATION_TYPE);
            this.injectStopObservationWithErrorCall(func, observeEndBB3, newCurrentBB.terminator.pos, trappedErrorOperand, INVOCATION_INSTRUMENTATION_TYPE);
            rePanicBB.terminator = new BIRTerminator.Panic(newCurrentBB.terminator.pos, trappedErrorOperand);
            BIRNode.BIRErrorEntry errorEntry = new BIRNode.BIRErrorEntry(newCurrentBB, newCurrentBB, trappedErrorOperand, errorCheckBB);
            func.errorTable.add(errorEntry);
            newCurrentBB.terminator.thenBB = errorCheckBB;
            observeEndBB3.terminator.thenBB = rePanicBB;
            i += 3;
        }
    }

    private void injectStartResourceObservationCall(BIRNode.BIRFunction func, BIRNode.BIRBasicBlock observeStartBB, String serviceName, String resourcePathOrFunction, String resourceAccessor, boolean isResource, boolean isRemote, BIRNode.BIRPackage pkg, Location originalInsPosition) {
        BIROperand serviceNameOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, serviceName);
        BIROperand resourcePathOrFunctionOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, resourcePathOrFunction);
        BIROperand resourceAccessorOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, resourceAccessor);
        BIROperand isResourceOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.booleanType, isResource);
        BIROperand isRemoteOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.booleanType, isRemote);
        JIMethodCall observeStartCallTerminator = new JIMethodCall(null);
        observeStartCallTerminator.invocationType = 184;
        observeStartCallTerminator.jClassName = "io/ballerina/runtime/observability/ObserveUtils";
        observeStartCallTerminator.jMethodVMSig = "(Lio/ballerina/runtime/api/Environment;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;JJLio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;ZZ)V";
        observeStartCallTerminator.name = "startResourceObservation";
        List<BIROperand> positionOperands = this.generatePositionArgs(pkg, func, observeStartBB, originalInsPosition);
        List<BIROperand> otherOperands = Arrays.asList(serviceNameOperand, resourcePathOrFunctionOperand, resourceAccessorOperand, isResourceOperand, isRemoteOperand);
        positionOperands.addAll(otherOperands);
        observeStartCallTerminator.args = positionOperands;
        observeStartBB.terminator = observeStartCallTerminator;
    }

    private void injectStartCallableObservationCall(BIRNode.BIRFunction func, BIRNode.BIRBasicBlock observeStartBB, Location desugaredInsLocation, boolean isRemote, boolean isMainEntryPoint, boolean isWorker, BIROperand objectOperand, String action, BIRNode.BIRPackage pkg, Location originalInsPosition) {
        BIROperand actionOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, action);
        BIROperand isMainEntryPointOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.booleanType, isMainEntryPoint);
        BIROperand isRemoteOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.booleanType, isRemote);
        BIROperand isWorkerOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.booleanType, isWorker);
        JIMethodCall observeStartCallTerminator = new JIMethodCall(desugaredInsLocation);
        observeStartCallTerminator.invocationType = 184;
        observeStartCallTerminator.jClassName = "io/ballerina/runtime/observability/ObserveUtils";
        observeStartCallTerminator.jMethodVMSig = "(Lio/ballerina/runtime/api/Environment;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;JJLio/ballerina/runtime/api/values/BObject;Lio/ballerina/runtime/api/values/BString;ZZZ)V";
        observeStartCallTerminator.name = "startCallableObservation";
        List<BIROperand> positionOperands = this.generatePositionArgs(pkg, func, observeStartBB, originalInsPosition);
        List<BIROperand> otherOperands = Arrays.asList(objectOperand, actionOperand, isMainEntryPointOperand, isRemoteOperand, isWorkerOperand);
        positionOperands.addAll(otherOperands);
        observeStartCallTerminator.args = positionOperands;
        observeStartBB.terminator = observeStartCallTerminator;
    }

    private void injectCheckErrorCalls(BIRNode.BIRFunction func, BIRNode.BIRBasicBlock errorCheckBB, BIRNode.BIRBasicBlock isErrorBB, BIRNode.BIRBasicBlock noErrorBB, Location pos, BIROperand valueOperand, String uniqueId) {
        BIROperand isErrorOperand = this.tempLocalVarsMap.get(uniqueId + "$isError");
        this.addLocalVarIfAbsent(func, isErrorOperand.variableDcl);
        BIRNonTerminator.TypeTest errorTypeTestInstruction = new BIRNonTerminator.TypeTest(pos, this.symbolTable.errorType, isErrorOperand, valueOperand);
        errorCheckBB.instructions.add(errorTypeTestInstruction);
        errorCheckBB.terminator = new BIRTerminator.Branch(pos, isErrorOperand, isErrorBB, noErrorBB);
    }

    private void injectReportErrorCall(BIRNode.BIRFunction func, BIRNode.BIRBasicBlock errorReportBB, Location pos, BIROperand errorOperand, String uniqueId) {
        BIROperand castedErrorOperand = this.tempLocalVarsMap.get(uniqueId + "$castedError");
        this.addLocalVarIfAbsent(func, castedErrorOperand.variableDcl);
        BIRNonTerminator.TypeCast errorCastInstruction = new BIRNonTerminator.TypeCast(pos, castedErrorOperand, errorOperand, this.symbolTable.errorType, false);
        errorReportBB.instructions.add(errorCastInstruction);
        JIMethodCall reportErrorCallTerminator = new JIMethodCall(pos);
        reportErrorCallTerminator.invocationType = 184;
        reportErrorCallTerminator.jClassName = "io/ballerina/runtime/observability/ObserveUtils";
        reportErrorCallTerminator.jMethodVMSig = "(Lio/ballerina/runtime/api/Environment;Lio/ballerina/runtime/internal/values/ErrorValue;)V";
        reportErrorCallTerminator.name = "reportError";
        reportErrorCallTerminator.args = Collections.singletonList(castedErrorOperand);
        errorReportBB.terminator = reportErrorCallTerminator;
    }

    private void injectStopObservationCall(BIRNode.BIRBasicBlock observeEndBB, Location pos) {
        JIMethodCall observeEndCallTerminator = new JIMethodCall(pos);
        observeEndCallTerminator.invocationType = 184;
        observeEndCallTerminator.jClassName = "io/ballerina/runtime/observability/ObserveUtils";
        observeEndCallTerminator.jMethodVMSig = "(Lio/ballerina/runtime/api/Environment;)V";
        observeEndCallTerminator.name = "stopObservation";
        observeEndCallTerminator.args = Collections.emptyList();
        observeEndBB.terminator = observeEndCallTerminator;
    }

    private void injectStopObservationWithErrorCall(BIRNode.BIRFunction func, BIRNode.BIRBasicBlock observeEndBB, Location pos, BIROperand errorOperand, String uniqueId) {
        BIROperand castedErrorOperand = this.tempLocalVarsMap.get(uniqueId + "$castedError");
        this.addLocalVarIfAbsent(func, castedErrorOperand.variableDcl);
        BIRNonTerminator.TypeCast errorCastInstruction = new BIRNonTerminator.TypeCast(pos, castedErrorOperand, errorOperand, this.symbolTable.errorType, false);
        observeEndBB.instructions.add(errorCastInstruction);
        JIMethodCall observeEndBBCallTerminator = new JIMethodCall(pos);
        observeEndBBCallTerminator.invocationType = 184;
        observeEndBBCallTerminator.jClassName = "io/ballerina/runtime/observability/ObserveUtils";
        observeEndBBCallTerminator.jMethodVMSig = "(Lio/ballerina/runtime/api/Environment;Lio/ballerina/runtime/internal/values/ErrorValue;)V";
        observeEndBBCallTerminator.name = "stopObservationWithError";
        observeEndBBCallTerminator.args = Collections.singletonList(castedErrorOperand);
        observeEndBB.terminator = observeEndBBCallTerminator;
    }

    private BIROperand generateGlobalConstantOperand(BIRNode.BIRPackage pkg, BType constantType, Object constantValue) {
        return this.compileTimeConstants.computeIfAbsent(constantValue, k -> {
            PackageID pkgId = pkg.packageID;
            Name name = new Name("$observabilityConst" + this.constantIndex++);
            BIRNode.BIRGlobalVariableDcl constLoadVariableDcl = new BIRNode.BIRGlobalVariableDcl(COMPILE_TIME_CONST_POS, 0L, constantType, pkgId, name, name, VarScope.GLOBAL, VarKind.CONSTANT, "", SymbolOrigin.VIRTUAL);
            pkg.globalVars.add(constLoadVariableDcl);
            return new BIROperand(constLoadVariableDcl);
        });
    }

    private BIRNode.BIRBasicBlock insertBasicBlock(BIRNode.BIRFunction func, int insertIndex) {
        BIRNode.BIRBasicBlock newBB = new BIRNode.BIRBasicBlock(NEW_BB_PREFIX, this.desugaredBBIndex++);
        func.basicBlocks.add(insertIndex, newBB);
        return newBB;
    }

    private void swapBasicBlockContent(BIRNode.BIRFunction func, BIRNode.BIRBasicBlock firstBB, BIRNode.BIRBasicBlock secondBB) {
        List<BIRNonTerminator> firstBBInstructions = firstBB.instructions;
        firstBB.instructions = secondBB.instructions;
        secondBB.instructions = firstBBInstructions;
        this.resetEndBasicBlock(func, firstBB, secondBB);
        this.swapBasicBlockTerminator(func, firstBB, secondBB);
    }

    private void swapBasicBlockTerminator(BIRNode.BIRFunction func, BIRNode.BIRBasicBlock firstBB, BIRNode.BIRBasicBlock secondBB) {
        BIRTerminator firstBBTerminator = firstBB.terminator;
        firstBB.terminator = secondBB.terminator;
        secondBB.terminator = firstBBTerminator;
        this.resetEndBasicBlock(func, firstBB, secondBB);
    }

    private void resetEndBasicBlock(BIRNode.BIRFunction func, BIRNode.BIRBasicBlock firstBB, BIRNode.BIRBasicBlock secondBB) {
        for (BIRNode.BIRVariableDcl localVar : func.localVars) {
            if (localVar.endBB != firstBB) continue;
            localVar.endBB = secondBB;
        }
    }

    private void fixErrorTable(BIRNode.BIRFunction func, BIRNode.BIRBasicBlock oldBB, BIRNode.BIRBasicBlock newBB) {
        for (BIRNode.BIRErrorEntry errorEntry : func.errorTable) {
            if (errorEntry.endBB != oldBB) continue;
            errorEntry.endBB = newBB;
        }
    }

    private boolean isObservable(BIRTerminator.Call callIns) {
        boolean isRemote = callIns.calleeFlags.contains((Object)Flag.REMOTE);
        boolean isObservableAnnotationPresent = false;
        for (BIRNode.BIRAnnotationAttachment annot : callIns.calleeAnnotAttachments) {
            if (!"ballerina/observe/Observable".equals(JvmCodeGenUtil.getPackageName(new PackageID(annot.annotPkgId.orgName, annot.annotPkgId.name, Names.EMPTY)) + annot.annotTagRef.getValue())) continue;
            isObservableAnnotationPresent = true;
            break;
        }
        return isRemote || isObservableAnnotationPresent;
    }

    private boolean isErrorAssignable(BIRNode.BIRVariableDcl variableDcl) {
        return SemTypeHelper.containsBasicType(variableDcl.type, PredefinedType.ERROR);
    }

    private boolean isBBCoveredInErrorEntry(BIRNode.BIRErrorEntry errorEntry, List<BIRNode.BIRBasicBlock> basicBlocksList, BIRNode.BIRBasicBlock basicBlock) {
        boolean isCovered;
        boolean bl = isCovered = Objects.equals(basicBlock, errorEntry.trapBB) || Objects.equals(basicBlock, errorEntry.endBB);
        if (!isCovered) {
            BIRNode.BIRBasicBlock currentBB;
            int i;
            for (i = 0; i < basicBlocksList.size() && (currentBB = basicBlocksList.get(i)) != errorEntry.trapBB; ++i) {
            }
            while (i < basicBlocksList.size()) {
                currentBB = basicBlocksList.get(i);
                if (currentBB == basicBlock) {
                    isCovered = true;
                    break;
                }
                if (currentBB == errorEntry.endBB) break;
                ++i;
            }
        }
        return isCovered;
    }

    private String generatePackageId(PackageID pkg) {
        return pkg.orgName.getValue() + "/" + pkg.name.getValue() + ":" + pkg.version.getValue();
    }

    private List<BIROperand> generatePositionArgs(BIRNode.BIRPackage pkg, BIRNode.BIRFunction func, BIRNode.BIRBasicBlock observeStartBB, Location pos) {
        BIROperand pkgOperand = this.generateGlobalConstantOperand(pkg, this.symbolTable.stringType, this.generatePackageId(pkg.packageID));
        BIROperand fileNameOperand = this.getTempLocalVariable(FILE_NAME_STRING, pos, pos.lineRange().fileName(), this.symbolTable.stringType, observeStartBB);
        this.addLocalVarIfAbsent(func, fileNameOperand.variableDcl);
        BIROperand startLineOperand = this.getTempLocalVariable(START_LINE_STRING, pos, pos.lineRange().startLine().line() + 1, this.symbolTable.intType, observeStartBB);
        this.addLocalVarIfAbsent(func, startLineOperand.variableDcl);
        BIROperand startColOperand = this.getTempLocalVariable(START_COLUMN_STRING, pos, pos.lineRange().startLine().offset() + 1, this.symbolTable.intType, observeStartBB);
        this.addLocalVarIfAbsent(func, startColOperand.variableDcl);
        return new ArrayList<BIROperand>(Arrays.asList(pkgOperand, fileNameOperand, startLineOperand, startColOperand));
    }

    private BIROperand getTempLocalVariable(String name, Location pos, Object value, BType variableType, BIRNode.BIRBasicBlock currentBB) {
        BIROperand birOperand = this.tempLocalVarsMap.get(name);
        this.addConstantLoadIns(pos, value, variableType, birOperand, currentBB);
        return birOperand;
    }

    private void updatePositionArgsConstLoadIns(Location pos, BIRNode.BIRBasicBlock currentBB) {
        this.addConstantLoadIns(pos, pos.lineRange().startLine().line() + 1, this.symbolTable.intType, this.tempLocalVarsMap.get(START_LINE_STRING), currentBB, 0);
        this.addConstantLoadIns(pos, pos.lineRange().startLine().offset() + 1, this.symbolTable.intType, this.tempLocalVarsMap.get(START_COLUMN_STRING), currentBB, 1);
    }

    private void addConstantLoadIns(Location pos, Object value, BType variableType, BIROperand birOperand, BIRNode.BIRBasicBlock currentBB) {
        BIRNonTerminator.ConstantLoad constantLoad = new BIRNonTerminator.ConstantLoad(pos, value, variableType, birOperand);
        currentBB.instructions.add(constantLoad);
    }

    private void addConstantLoadIns(Location pos, Object value, BType variableType, BIROperand birOperand, BIRNode.BIRBasicBlock currentBB, int index) {
        BIRNonTerminator.ConstantLoad constantLoad = new BIRNonTerminator.ConstantLoad(pos, value, variableType, birOperand);
        currentBB.instructions.add(index, constantLoad);
    }

    private void addLocalVarIfAbsent(BIRNode.BIRFunction func, BIRNode.BIRVariableDcl variableDcl) {
        if (!func.localVars.contains(variableDcl)) {
            func.localVars.add(variableDcl);
        }
    }

    private void initializeTempLocalVariables() {
        this.generateTempLocalVariable(FILE_NAME_STRING, this.symbolTable.stringType);
        this.generateTempLocalVariable(START_LINE_STRING, this.symbolTable.intType);
        this.generateTempLocalVariable(START_COLUMN_STRING, this.symbolTable.intType);
        this.generateTempLocalVariable("funcBody$castedError", this.symbolTable.errorType);
        this.generateTempLocalVariable("invocation$castedError", this.symbolTable.errorType);
        this.generateTempLocalVariable("funcBody$isError", this.symbolTable.booleanType);
        this.generateTempLocalVariable("invocation$isError", this.symbolTable.booleanType);
    }

    private void generateTempLocalVariable(String name, BType variableType) {
        BIRNode.BIRVariableDcl variableDcl = new BIRNode.BIRVariableDcl(variableType, new Name("$observability$" + name), VarScope.FUNCTION, VarKind.TEMP);
        BIROperand birOperand = new BIROperand(variableDcl);
        this.tempLocalVarsMap.put(name, birOperand);
    }

    private BIROperand generateTempLocalVariable(BIRNode.BIRFunction func, String name, BType variableType) {
        Name variableName = new Name("$observability$" + name + "$" + this.localVarIndex++);
        BIRNode.BIRVariableDcl variableDcl = new BIRNode.BIRVariableDcl(variableType, variableName, VarScope.FUNCTION, VarKind.TEMP);
        func.localVars.add(variableDcl);
        return new BIROperand(variableDcl);
    }
}

