/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import io.ballerina.identifier.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JavaClass;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.model.BIRFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JIMethodCLICall;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.Name;

public class InitMethodGen {
    private final SymbolTable symbolTable;
    private final BUnionType errorOrNilType;
    private int nextId = 0;
    private int nextVarId = 0;

    public InitMethodGen(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.errorOrNilType = BUnionType.create(symbolTable.typeEnv(), null, symbolTable.errorType, symbolTable.nilType);
    }

    public void generateLambdaForPackageInit(ClassWriter cw, BIRNode.BIRPackage pkg, String initClass) {
        if (!MethodGenUtils.hasInitFunction(pkg)) {
            return;
        }
        String funcName = MethodGenUtils.calculateLambdaStopFuncName(pkg.packageID);
        MethodVisitor mv = this.visitFunction(cw, funcName);
        this.invokeStopFunction(initClass, mv, funcName);
    }

    public void generateLambdaForModuleExecuteFunction(ClassWriter cw, String initClass, JvmCastGen jvmCastGen, BIRNode.BIRFunction mainFunc, BIRNode.BIRFunction testExecuteFunc) {
        String methodDesc;
        String lambdaFuncName = "$lambda$$moduleExecute$";
        MethodVisitor mv = this.visitFunction(cw, lambdaFuncName);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/Strand");
        if (mainFunc == null && testExecuteFunc == null) {
            methodDesc = "(Lio/ballerina/runtime/internal/scheduling/Strand;)Ljava/lang/Object;";
        } else {
            BType returnType;
            List<BType> paramTypes;
            if (mainFunc != null) {
                paramTypes = Collections.singletonList(this.symbolTable.anyType);
                returnType = mainFunc.type.retType;
            } else {
                paramTypes = testExecuteFunc.type.paramTypes;
                returnType = testExecuteFunc.type.retType;
            }
            int paramIndex = 1;
            for (BType paramType : paramTypes) {
                mv.visitVarInsn(25, 0);
                mv.visitIntInsn(16, paramIndex);
                mv.visitInsn(50);
                jvmCastGen.addUnboxInsn(mv, paramType);
                ++paramIndex;
            }
            methodDesc = JvmCodeGenUtil.getMethodDesc(this.symbolTable.typeEnv(), paramTypes, returnType);
        }
        mv.visitMethodInsn(184, initClass, "$moduleExecute", methodDesc, false);
        jvmCastGen.addBoxInsn(mv, this.errorOrNilType);
        MethodGenUtils.visitReturn(mv, lambdaFuncName, initClass);
    }

    private MethodVisitor visitFunction(ClassWriter cw, String funcName) {
        MethodVisitor mv = cw.visitMethod(9, funcName, "([Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        return mv;
    }

    private void invokeStopFunction(String initClass, MethodVisitor mv, String methodName) {
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/Strand");
        String stopFuncName = MethodGenUtils.encodeModuleSpecialFuncName(".<stop>");
        mv.visitMethodInsn(184, initClass, stopFuncName, "(Lio/ballerina/runtime/internal/scheduling/Strand;)Ljava/lang/Object;", false);
        MethodGenUtils.visitReturn(mv, methodName, initClass);
    }

    public void generateModuleInitializer(ClassWriter cw, BIRNode.BIRPackage module, String typeOwnerClass, String moduleInitClass) {
        MethodVisitor mv = cw.visitMethod(9, "$currentModuleInit", "(Lio/ballerina/runtime/internal/BalRuntime;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, moduleInitClass, "$createTypes", "()V", false);
        mv.visitTypeInsn(187, typeOwnerClass);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, typeOwnerClass, "<init>", "(Lio/ballerina/runtime/internal/BalRuntime;)V", false);
        mv.visitVarInsn(58, 1);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)module.packageID.orgName.getValue()));
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)module.packageID.name.getValue()));
        mv.visitLdcInsn((Object)CompilerUtils.getMajorVersion(module.packageID.version.getValue()));
        if (module.packageID.isTestPkg) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/ValueCreator", "addValueCreator", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLio/ballerina/runtime/internal/values/ValueCreator;)V", false);
        mv.visitInsn(1);
        MethodGenUtils.visitReturn(mv, "$currentModuleInit", typeOwnerClass);
    }

    public void generateModuleStop(ClassWriter cw, String moduleInitClass, AsyncDataCollector asyncDataCollector, JvmConstantsGen jvmConstantsGen) {
        MethodVisitor mv = cw.visitMethod(9, "$currentModuleStop", "(Lio/ballerina/runtime/internal/BalRuntime;)V", null, null);
        mv.visitCode();
        InitMethodGen.generateGetSchedulerVar(mv);
        String lambdaName = this.generateStopDynamicLambdaBody(cw, moduleInitClass);
        this.generateCallStopDynamicLambda(mv, lambdaName, moduleInitClass);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, moduleInitClass, "$moduleStop", "(Lio/ballerina/runtime/internal/scheduling/Scheduler;Lio/ballerina/runtime/internal/values/FutureValue;)V", false);
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "$currentModuleStop", moduleInitClass);
        mv.visitEnd();
    }

    private static void generateGetSchedulerVar(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/BalRuntime", "scheduler", "Lio/ballerina/runtime/internal/scheduling/Scheduler;");
        mv.visitVarInsn(58, 1);
    }

    private String generateStopDynamicLambdaBody(ClassWriter cw, String initClass) {
        String lambdaName = "$lambda$stopdynamic";
        MethodVisitor mv = cw.visitMethod(9, lambdaName, "([Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        this.generateCallSchedulerStopDynamicListeners(mv, lambdaName, initClass);
        return lambdaName;
    }

    private void generateCallSchedulerStopDynamicListeners(MethodVisitor mv, String lambdaName, String initClass) {
        mv.visitVarInsn(25, 0);
        mv.visitInsn(4);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/RuntimeRegistry");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/Strand");
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/RuntimeRegistry", "gracefulStop", "(Lio/ballerina/runtime/internal/scheduling/Strand;)V", false);
        mv.visitInsn(1);
        MethodGenUtils.visitReturn(mv, lambdaName, initClass);
    }

    private void generateCallStopDynamicLambda(MethodVisitor mv, String lambdaName, String moduleInitClass) {
        this.addRuntimeRegistryAsParameter(mv);
        this.generateMethodBody(mv, moduleInitClass, lambdaName);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/RuntimeUtils", "handleFuture", "(Lio/ballerina/runtime/internal/values/FutureValue;)V", false);
    }

    private void addRuntimeRegistryAsParameter(MethodVisitor mv) {
        mv.visitIntInsn(16, 2);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(4);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/BalRuntime", "runtimeRegistry", "Lio/ballerina/runtime/internal/scheduling/RuntimeRegistry;");
        mv.visitInsn(83);
    }

    private void generateMethodBody(MethodVisitor mv, String initClass, String stopFuncName) {
        mv.visitVarInsn(25, 1);
        JvmCodeGenUtil.createFunctionPointer(mv, initClass, stopFuncName);
        mv.visitInsn(1);
        mv.visitFieldInsn(178, "io/ballerina/runtime/api/types/PredefinedTypes", "TYPE_NULL", "Lio/ballerina/runtime/api/types/NullType;");
        mv.visitLdcInsn((Object)"stop");
        mv.visitInsn(1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "startIsolatedWorker", "(Lio/ballerina/runtime/internal/values/FPValue;Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/api/types/Type;Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;[Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/FutureValue;", false);
        mv.visitVarInsn(58, 3);
    }

    public void enrichPkgWithInitializers(Map<String, BIRFunctionWrapper> birFunctionMap, Map<String, JavaClass> jvmClassMap, String typeOwnerClass, BIRNode.BIRPackage pkg, Set<PackageID> moduleImports, BIRNode.BIRFunction mainFunc, BIRNode.BIRFunction testExecuteFunc) {
        JavaClass javaClass = jvmClassMap.get(typeOwnerClass);
        BIRNode.BIRFunction initFunc = this.generateDefaultFunction(moduleImports, pkg, "$moduleInit", ".<init>");
        javaClass.functions.add(initFunc);
        pkg.functions.add(initFunc);
        birFunctionMap.put(JvmCodeGenUtil.getPackageName(pkg.packageID) + "$moduleInit", JvmPackageGen.getFunctionWrapper(this.symbolTable.typeEnv(), initFunc, pkg.packageID, typeOwnerClass));
        BIRNode.BIRFunction startFunc = this.generateDefaultFunction(moduleImports, pkg, "$moduleStart", ".<start>");
        javaClass.functions.add(startFunc);
        pkg.functions.add(startFunc);
        birFunctionMap.put(JvmCodeGenUtil.getPackageName(pkg.packageID) + "$moduleStart", JvmPackageGen.getFunctionWrapper(this.symbolTable.typeEnv(), startFunc, pkg.packageID, typeOwnerClass));
        BIRNode.BIRFunction execFunc = this.generateExecuteFunction(pkg, mainFunc, testExecuteFunc);
        javaClass.functions.add(execFunc);
        pkg.functions.add(execFunc);
        birFunctionMap.put(JvmCodeGenUtil.getPackageName(pkg.packageID) + "$moduleExecute", JvmPackageGen.getFunctionWrapper(this.symbolTable.typeEnv(), execFunc, pkg.packageID, typeOwnerClass));
    }

    private BIRNode.BIRFunction generateExecuteFunction(BIRNode.BIRPackage pkg, BIRNode.BIRFunction mainFunc, BIRNode.BIRFunction testExecuteFunc) {
        BIRNode.BIRVariableDcl retVar = new BIRNode.BIRVariableDcl(null, this.errorOrNilType, new Name("%ret"), VarScope.FUNCTION, VarKind.RETURN, null);
        BIROperand retVarRef = new BIROperand(retVar);
        ArrayList<BIROperand> functionArgs = new ArrayList<BIROperand>();
        BInvokableType funcType = new BInvokableType(this.symbolTable.typeEnv(), Collections.emptyList(), null, this.errorOrNilType, null);
        BIRNode.BIRFunction modExecFunc = new BIRNode.BIRFunction(null, new Name("$moduleExecute"), 0L, funcType, null, 0, SymbolOrigin.VIRTUAL);
        List<BType> paramTypes = new ArrayList<BType>();
        List<BIRNode.BIRFunctionParameter> parameters = new ArrayList<BIRNode.BIRFunctionParameter>();
        List<BIRNode.BIRParameter> requiredParameters = new ArrayList<BIRNode.BIRParameter>();
        int argsCount = 0;
        int defaultParamCount = 0;
        ArrayList<BIROperand> defaultableArgRefs = new ArrayList<BIROperand>();
        if (mainFunc != null) {
            List<BIRNode.BIRFunctionParameter> mainParameters = mainFunc.parameters;
            Name argName = new Name("%_cli");
            BIRNode.BIRFunctionParameter cliArgVar = new BIRNode.BIRFunctionParameter(null, this.symbolTable.anyType, argName, VarScope.FUNCTION, VarKind.ARG, null, false, false);
            paramTypes.add(this.symbolTable.anyType);
            parameters.add(cliArgVar);
            requiredParameters.add(new BIRNode.BIRParameter(null, argName, 0L));
            modExecFunc.localVars.add(cliArgVar);
            ++argsCount;
            Iterator iterator = mainParameters.iterator();
            while (iterator.hasNext()) {
                BIRNode.BIRFunctionParameter param = (BIRNode.BIRFunctionParameter)iterator.next();
                BIRNode.BIRVariableDcl paramVar = new BIRNode.BIRVariableDcl(null, param.type, new Name("%param" + param.jvmVarName), VarScope.FUNCTION, VarKind.LOCAL, null);
                BIROperand varRef = new BIROperand(paramVar);
                modExecFunc.localVars.add(paramVar);
                functionArgs.add(varRef);
                if (!param.hasDefaultExpr) continue;
                BIRNode.BIRVariableDcl tempParamVar = new BIRNode.BIRVariableDcl(null, this.symbolTable.anyType, new Name("%tempVar" + param.jvmVarName), VarScope.FUNCTION, VarKind.TEMP, null);
                BIROperand tempVarRef = new BIROperand(tempParamVar);
                modExecFunc.localVars.add(tempParamVar);
                defaultableArgRefs.add(tempVarRef);
                ++defaultParamCount;
            }
        }
        if (testExecuteFunc != null) {
            paramTypes = testExecuteFunc.type.paramTypes;
            parameters = testExecuteFunc.parameters;
            requiredParameters = testExecuteFunc.requiredParams;
            argsCount += modExecFunc.parameters.size();
            for (BIRNode.BIRFunctionParameter param : parameters) {
                BIRNode.BIRVariableDcl paramVar = new BIRNode.BIRVariableDcl(null, param.type, new Name("%param" + param.jvmVarName), VarScope.FUNCTION, VarKind.ARG, null);
                BIROperand varRef = new BIROperand(paramVar);
                modExecFunc.localVars.add(paramVar);
                functionArgs.add(varRef);
            }
        }
        funcType.paramTypes = paramTypes;
        modExecFunc.parameters = parameters;
        modExecFunc.requiredParams = requiredParameters;
        modExecFunc.argsCount = argsCount;
        modExecFunc.localVars.add(retVar);
        this.addAndGetNextBasicBlock(modExecFunc);
        BIRNode.BIRVariableDcl boolVal = this.addAndGetNextVar(modExecFunc, this.symbolTable.booleanType);
        BIROperand boolRef = new BIROperand(boolVal);
        this.addCheckedInvocation(modExecFunc, pkg.packageID, "$moduleInit", retVarRef, boolRef);
        if (mainFunc != null) {
            this.injectCLIArgInvocation(modExecFunc, functionArgs, defaultableArgRefs);
            this.injectDefaultArgs(functionArgs, mainFunc, modExecFunc, boolRef, pkg.globalVars, defaultableArgRefs, defaultParamCount);
            this.addCheckedInvocationWithArgs(modExecFunc, pkg.packageID, "main", retVarRef, boolRef, functionArgs, mainFunc.annotAttachments);
        }
        BIRNode.BIRBasicBlock lastBB = this.addCheckedInvocation(modExecFunc, pkg.packageID, "$moduleStart", retVarRef, boolRef);
        if (testExecuteFunc != null) {
            lastBB = this.addTestExecuteInvocationWithGracefulExitCall(modExecFunc, pkg.packageID, retVarRef, functionArgs, Collections.emptyList());
        }
        lastBB.terminator = new BIRTerminator.Return(null);
        return modExecFunc;
    }

    private void injectCLIArgInvocation(BIRNode.BIRFunction modExecFunc, List<BIROperand> functionArgs, List<BIROperand> tempFuncArgs) {
        BIRNode.BIRBasicBlock lastBB = modExecFunc.basicBlocks.getLast();
        JIMethodCLICall jiMethodCall = new JIMethodCLICall(null);
        jiMethodCall.lhsArgs = functionArgs;
        jiMethodCall.jClassName = "io/ballerina/runtime/internal/cli/CliSpec";
        jiMethodCall.jMethodVMSig = "()[Ljava/lang/Object;";
        jiMethodCall.name = "getMainArgs";
        jiMethodCall.thenBB = this.addAndGetNextBasicBlock(modExecFunc);
        jiMethodCall.defaultFunctionArgs = tempFuncArgs;
        lastBB.terminator = jiMethodCall;
    }

    private void injectDefaultArgs(List<BIROperand> mainArgs, BIRNode.BIRFunction mainFunc, BIRNode.BIRFunction modExecFunc, BIROperand boolRef, List<BIRNode.BIRGlobalVariableDcl> globalVars, List<BIROperand> tempFuncArgs, int defaultParamCount) {
        for (int i = 0; i < tempFuncArgs.size(); ++i) {
            int mainFuncParamIndex = mainFunc.parameters.size() - defaultParamCount + i;
            BIRNode.BIRFunctionParameter parameter = mainFunc.parameters.get(mainFuncParamIndex);
            BIRNode.BIRBasicBlock lastBB = modExecFunc.basicBlocks.getLast();
            BIROperand argOperand = mainArgs.get(mainFuncParamIndex);
            BIROperand tempArgOperand = tempFuncArgs.get(i);
            BIRNonTerminator.TypeTest typeTest = new BIRNonTerminator.TypeTest(null, this.symbolTable.nilType, boolRef, tempArgOperand);
            lastBB.instructions.add(typeTest);
            BIRNode.BIRBasicBlock trueBB = this.addAndGetNextBasicBlock(modExecFunc);
            BIRNode.BIRBasicBlock falseBB = this.addAndGetNextBasicBlock(modExecFunc);
            BIRNode.BIRBasicBlock nextBB = this.addAndGetNextBasicBlock(modExecFunc);
            lastBB.terminator = new BIRTerminator.Branch(null, boolRef, trueBB, falseBB);
            BIRNonTerminator.TypeCast typeCast = new BIRNonTerminator.TypeCast(null, argOperand, tempArgOperand, argOperand.variableDcl.type, false);
            BInvokableSymbol defaultFunc = ((BInvokableTypeSymbol)mainFunc.type.tsymbol).defaultValues.get(parameter.metaVarName);
            trueBB.terminator = this.getFPCallForDefaultParameter(defaultFunc, argOperand, nextBB, globalVars, mainArgs.subList(0, mainFuncParamIndex));
            falseBB.instructions.add(typeCast);
            falseBB.terminator = new BIRTerminator.GOTO(null, nextBB);
        }
    }

    private BIRTerminator.FPCall getFPCallForDefaultParameter(BInvokableSymbol defaultFunc, BIROperand argOperand, BIRNode.BIRBasicBlock thenBB, List<BIRNode.BIRGlobalVariableDcl> globalVars, List<BIROperand> args) {
        BIRNode.BIRGlobalVariableDcl defaultFuncVar = this.getDefaultFuncFPGlobalVar(defaultFunc.name, globalVars);
        BIROperand defaultFP = new BIROperand(defaultFuncVar);
        return new BIRTerminator.FPCall(null, InstructionKind.FP_CALL, defaultFP, args, argOperand, false, thenBB, null, new ArrayList<BIRNode.BIRAnnotationAttachment>());
    }

    private BIRNode.BIRGlobalVariableDcl getDefaultFuncFPGlobalVar(Name name, List<BIRNode.BIRGlobalVariableDcl> globalVars) {
        for (BIRNode.BIRGlobalVariableDcl globalVar : globalVars) {
            if (!globalVar.name.value.equals(name.value)) continue;
            return globalVar;
        }
        return null;
    }

    private BIRNode.BIRFunction generateDefaultFunction(Set<PackageID> imprtMods, BIRNode.BIRPackage pkg, String funcName, String initName) {
        this.nextId = 0;
        this.nextVarId = 0;
        BIRNode.BIRVariableDcl retVar = new BIRNode.BIRVariableDcl(null, this.errorOrNilType, new Name("%ret"), VarScope.FUNCTION, VarKind.RETURN, null);
        BIROperand retVarRef = new BIROperand(retVar);
        BInvokableType funcType = new BInvokableType(this.symbolTable.typeEnv(), Collections.emptyList(), null, this.errorOrNilType, null);
        BIRNode.BIRFunction modInitFunc = new BIRNode.BIRFunction(this.symbolTable.builtinPos, new Name(funcName), 0L, funcType, null, 0, SymbolOrigin.VIRTUAL);
        modInitFunc.localVars.add(retVar);
        this.addAndGetNextBasicBlock(modInitFunc);
        BIRNode.BIRVariableDcl boolVal = this.addAndGetNextVar(modInitFunc, this.symbolTable.booleanType);
        BIROperand boolRef = new BIROperand(boolVal);
        String initFuncName = MethodGenUtils.encodeModuleSpecialFuncName(funcName);
        for (PackageID id : imprtMods) {
            this.addCheckedInvocation(modInitFunc, id, initFuncName, retVarRef, boolRef);
        }
        String currentInitFuncName = MethodGenUtils.encodeModuleSpecialFuncName(initName);
        BIRNode.BIRBasicBlock lastBB = this.addCheckedInvocation(modInitFunc, pkg.packageID, currentInitFuncName, retVarRef, boolRef);
        lastBB.terminator = new BIRTerminator.Return(null);
        return modInitFunc;
    }

    private BIRNode.BIRVariableDcl addAndGetNextVar(BIRNode.BIRFunction func, BType typeVal) {
        BIRNode.BIRVariableDcl nextLocalVar = new BIRNode.BIRVariableDcl(typeVal, this.getNextVarId(), VarScope.FUNCTION, VarKind.LOCAL);
        func.localVars.add(nextLocalVar);
        return nextLocalVar;
    }

    private Name getNextVarId() {
        String varIdPrefix = "%";
        ++this.nextVarId;
        return new Name(varIdPrefix + this.nextVarId);
    }

    private BIRNode.BIRBasicBlock addTestExecuteInvocationWithGracefulExitCall(BIRNode.BIRFunction func, PackageID modId, BIROperand retVar, List<BIROperand> args, List<BIRNode.BIRAnnotationAttachment> calleeAnnotAttachments) {
        BIRNode.BIRBasicBlock lastBB = func.basicBlocks.getLast();
        BIRNode.BIRBasicBlock nextBB = this.addAndGetNextBasicBlock(func);
        if (JvmCodeGenUtil.isBuiltInPackage(modId)) {
            lastBB.terminator = new BIRTerminator.Call(null, InstructionKind.CALL, false, modId, new Name("__execute__"), args, null, nextBB, calleeAnnotAttachments, Collections.emptySet());
            return nextBB;
        }
        lastBB.terminator = new BIRTerminator.Call(null, InstructionKind.CALL, false, modId, new Name("__execute__"), args, retVar, nextBB, calleeAnnotAttachments, Collections.emptySet());
        return nextBB;
    }

    private BIRNode.BIRBasicBlock addCheckedInvocationWithArgs(BIRNode.BIRFunction func, PackageID modId, String initFuncName, BIROperand retVar, BIROperand boolRef, List<BIROperand> args, List<BIRNode.BIRAnnotationAttachment> calleeAnnotAttachments) {
        BIRNode.BIRBasicBlock lastBB = func.basicBlocks.getLast();
        BIRNode.BIRBasicBlock nextBB = this.addAndGetNextBasicBlock(func);
        if (JvmCodeGenUtil.isBuiltInPackage(modId)) {
            lastBB.terminator = new BIRTerminator.Call(null, InstructionKind.CALL, false, modId, new Name(initFuncName), args, null, nextBB, calleeAnnotAttachments, Collections.emptySet());
            return nextBB;
        }
        lastBB.terminator = new BIRTerminator.Call(null, InstructionKind.CALL, false, modId, new Name(initFuncName), args, retVar, nextBB, calleeAnnotAttachments, Collections.emptySet());
        BIRNonTerminator.TypeTest typeTest = new BIRNonTerminator.TypeTest(null, this.symbolTable.errorType, boolRef, retVar);
        nextBB.instructions.add(typeTest);
        BIRNode.BIRBasicBlock trueBB = this.addAndGetNextBasicBlock(func);
        BIRNode.BIRBasicBlock retBB = this.addAndGetNextBasicBlock(func);
        retBB.terminator = new BIRTerminator.Return(null);
        trueBB.terminator = new BIRTerminator.GOTO(null, retBB);
        BIRNode.BIRBasicBlock falseBB = this.addAndGetNextBasicBlock(func);
        nextBB.terminator = new BIRTerminator.Branch(null, boolRef, trueBB, falseBB);
        return falseBB;
    }

    private BIRNode.BIRBasicBlock addCheckedInvocation(BIRNode.BIRFunction func, PackageID modId, String initFuncName, BIROperand retVar, BIROperand boolRef) {
        return this.addCheckedInvocationWithArgs(func, modId, initFuncName, retVar, boolRef, Collections.emptyList(), Collections.emptyList());
    }

    private BIRNode.BIRBasicBlock addAndGetNextBasicBlock(BIRNode.BIRFunction func) {
        BIRNode.BIRBasicBlock nextbb = new BIRNode.BIRBasicBlock("genBB", this.incrementAndGetNextId());
        func.basicBlocks.add(nextbb);
        return nextbb;
    }

    public void resetIds() {
        this.nextId = 0;
        this.nextVarId = 0;
    }

    public int incrementAndGetNextId() {
        return this.nextId++;
    }

    public void generateGetTestExecutionState(ClassWriter cw, String className) {
        MethodVisitor mv = cw.visitMethod(9, "$getTestExecutionState", "()J", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, className, "__gH7W16nQmp0TestExecState__", "J");
        mv.visitInsn(173);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "$getTestExecutionState", className);
        mv.visitEnd();
    }
}

