/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split;

import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmArrayTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmBStringConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmBallerinaConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmErrorTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmFunctionTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmModuleConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmRefTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmTupleTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmUnionTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeHashVisitor;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

public class JvmConstantsGen {
    private final JvmBallerinaConstantsGen jvmBallerinaConstantsGen;
    private final JvmUnionTypeConstantsGen unionTypeConstantsGen;
    private final JvmErrorTypeConstantsGen errorTypeConstantsGen;
    private final JvmBStringConstantsGen stringConstantsGen;
    private final JvmModuleConstantsGen moduleConstantsGen;
    private final JvmTupleTypeConstantsGen tupleTypeConstantsGen;
    private final JvmArrayTypeConstantsGen arrayTypeConstantsGen;
    private final JvmRefTypeConstantsGen refTypeConstantsGen;
    private final JvmFunctionTypeConstantsGen functionTypeConstantsGen;
    public final BTypeHashComparator bTypeHashComparator;

    public JvmConstantsGen(BIRNode.BIRPackage module, String moduleInitClass, Types types, TypeHashVisitor typeHashVisitor) {
        this.bTypeHashComparator = new BTypeHashComparator(typeHashVisitor);
        this.stringConstantsGen = new JvmBStringConstantsGen(module.packageID);
        this.moduleConstantsGen = new JvmModuleConstantsGen(module);
        this.functionTypeConstantsGen = new JvmFunctionTypeConstantsGen(module.packageID, module.functions);
        this.jvmBallerinaConstantsGen = new JvmBallerinaConstantsGen(module, moduleInitClass, this);
        this.unionTypeConstantsGen = new JvmUnionTypeConstantsGen(module.packageID, this.bTypeHashComparator);
        this.errorTypeConstantsGen = new JvmErrorTypeConstantsGen(module.packageID, this.bTypeHashComparator);
        this.tupleTypeConstantsGen = new JvmTupleTypeConstantsGen(module.packageID, this.bTypeHashComparator);
        this.arrayTypeConstantsGen = new JvmArrayTypeConstantsGen(module.packageID, this.bTypeHashComparator, types);
        this.refTypeConstantsGen = new JvmRefTypeConstantsGen(module.packageID, this.bTypeHashComparator);
    }

    public int getBStringConstantVarIndex(String value) {
        return this.stringConstantsGen.addBStringConstantVarIndex(value);
    }

    public String getModuleConstantVar(PackageID packageID) {
        return this.moduleConstantsGen.addModule(packageID);
    }

    public void setJvmCreateTypeGen(JvmCreateTypeGen jvmCreateTypeGen) {
        this.unionTypeConstantsGen.setJvmUnionTypeGen(jvmCreateTypeGen.getJvmUnionTypeGen());
        this.errorTypeConstantsGen.setJvmErrorTypeGen(jvmCreateTypeGen.getJvmErrorTypeGen());
        this.tupleTypeConstantsGen.setJvmTupleTypeGen(jvmCreateTypeGen.getJvmTupleTypeGen());
        this.arrayTypeConstantsGen.setJvmArrayTypeGen(jvmCreateTypeGen.getJvmArrayTypeGen());
        this.refTypeConstantsGen.setJvmRefTypeGen(jvmCreateTypeGen.getJvmRefTypeGen());
        this.functionTypeConstantsGen.setJvmTypeGen(jvmCreateTypeGen.getJvmTypeGen());
    }

    public void generateConstants(JarEntries jarEntries) {
        this.functionTypeConstantsGen.generateClass(jarEntries);
        this.jvmBallerinaConstantsGen.generateConstantInit(jarEntries);
        this.unionTypeConstantsGen.generateClass(jarEntries);
        this.errorTypeConstantsGen.generateClass(jarEntries);
        this.moduleConstantsGen.generateConstantInit(jarEntries);
        this.stringConstantsGen.generateConstantInit(jarEntries);
        this.tupleTypeConstantsGen.generateClass(jarEntries);
        this.arrayTypeConstantsGen.generateClass(jarEntries);
        this.refTypeConstantsGen.generateClass(jarEntries);
    }

    public void generateGetBErrorType(MethodVisitor mv, String varName) {
        this.errorTypeConstantsGen.generateGetBErrorType(mv, varName);
    }

    public void generateGetBUnionType(MethodVisitor mv, String varName) {
        this.unionTypeConstantsGen.generateGetBUnionType(mv, varName);
    }

    public void generateGetBTupleType(MethodVisitor mv, String varName) {
        this.tupleTypeConstantsGen.generateGetBTupleType(mv, varName);
    }

    public String getTypeConstantsVar(BType type, SymbolTable symbolTable) {
        return switch (type.tag) {
            case 29 -> this.errorTypeConstantsGen.add((BErrorType)type);
            case 20 -> this.arrayTypeConstantsGen.add((BArrayType)type);
            case 31 -> this.tupleTypeConstantsGen.add((BTupleType)type, symbolTable);
            case 14 -> this.refTypeConstantsGen.add((BTypeReferenceType)type);
            default -> this.unionTypeConstantsGen.add((BUnionType)type, symbolTable);
        };
    }

    public String getStringConstantsClass() {
        return this.stringConstantsGen.getStringConstantsClass();
    }

    public String getModuleConstantClass() {
        return this.moduleConstantsGen.getModuleConstantClass();
    }

    public String getRefTypeConstantsClass() {
        return this.refTypeConstantsGen.getRefTypeConstantsClass();
    }

    public String getArrayTypeConstantClass() {
        return this.arrayTypeConstantsGen.getArrayTypeConstantClass();
    }

    public String getTupleTypeConstantsClass() {
        return this.tupleTypeConstantsGen.getTupleTypeConstantsClass();
    }

    public String getUnionTypeConstantClass() {
        return this.unionTypeConstantsGen.getUnionTypeConstantClass();
    }

    public String getErrorTypeConstantClass() {
        return this.errorTypeConstantsGen.getErrorTypeConstantClass();
    }

    public String getConstantClass() {
        return this.jvmBallerinaConstantsGen.getConstantClass();
    }

    public String getFunctionTypeConstantClass() {
        return this.functionTypeConstantsGen.getFunctionTypeConstantClass();
    }

    public String getFunctionTypeVar(String functionName) {
        return this.functionTypeConstantsGen.getFunctionTypeVar(functionName);
    }

    public void generateGetBArrayType(MethodVisitor mv, String varName) {
        this.arrayTypeConstantsGen.generateGetBArrayType(mv, varName);
    }
}

