/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split;

import io.ballerina.identifier.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.TypeDefHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmArrayTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmErrorTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmObjectTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmRecordTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmRefTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmTupleTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmUnionTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeHashVisitor;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.NamedNode;

public class JvmCreateTypeGen {
    private final JvmTypeGen jvmTypeGen;
    private final JvmConstantsGen jvmConstantsGen;
    private final JvmRecordTypeGen jvmRecordTypeGen;
    private final JvmObjectTypeGen jvmObjectTypeGen;
    private final JvmErrorTypeGen jvmErrorTypeGen;
    private final JvmUnionTypeGen jvmUnionTypeGen;
    private final JvmTupleTypeGen jvmTupleTypeGen;
    private final JvmArrayTypeGen jvmArrayTypeGen;
    private final JvmRefTypeGen jvmRefTypeGen;
    private final TypeHashVisitor typeHashVisitor;
    public final TypeDefHashComparator typeDefHashComparator;
    private final String typesClass;
    private final String anonTypesClass;
    private final String functionTypesClass;
    private final ClassWriter typesCw;

    public JvmCreateTypeGen(JvmTypeGen jvmTypeGen, JvmConstantsGen jvmConstantsGen, PackageID packageID, TypeHashVisitor typeHashVisitor) {
        this.jvmTypeGen = jvmTypeGen;
        this.jvmConstantsGen = jvmConstantsGen;
        this.typesClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "types/$_types");
        this.anonTypesClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "types/$_anon_types");
        this.functionTypesClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "types/$_function_types");
        this.jvmRecordTypeGen = new JvmRecordTypeGen(this, jvmTypeGen, jvmConstantsGen, packageID);
        this.jvmObjectTypeGen = new JvmObjectTypeGen(this, this.typesClass, jvmTypeGen, jvmConstantsGen, packageID);
        this.jvmErrorTypeGen = new JvmErrorTypeGen(this, jvmTypeGen, jvmConstantsGen, packageID);
        this.jvmUnionTypeGen = new JvmUnionTypeGen(this, jvmTypeGen, jvmConstantsGen, packageID);
        this.jvmTupleTypeGen = new JvmTupleTypeGen(this, jvmTypeGen, jvmConstantsGen, packageID);
        this.jvmArrayTypeGen = new JvmArrayTypeGen(jvmTypeGen);
        this.jvmRefTypeGen = new JvmRefTypeGen(jvmTypeGen, jvmConstantsGen);
        this.typesCw = new BallerinaClassWriter(2);
        this.typeHashVisitor = typeHashVisitor;
        this.typeDefHashComparator = new TypeDefHashComparator(typeHashVisitor);
        this.typesCw.visit(65, 33, this.typesClass, null, "java/lang/Object", null);
    }

    public void generateTypeClass(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries, String moduleInitClass, SymbolTable symbolTable) {
        this.generateCreateTypesMethod(this.typesCw, module.typeDefs, moduleInitClass, symbolTable);
        this.typesCw.visitEnd();
        this.jvmRecordTypeGen.visitEnd(jvmPackageGen, module, jarEntries);
        this.jvmObjectTypeGen.visitEnd(jvmPackageGen, module, jarEntries);
        this.jvmErrorTypeGen.visitEnd(jvmPackageGen, module, jarEntries);
        this.jvmUnionTypeGen.visitEnd(jvmPackageGen, module, jarEntries);
        this.jvmTupleTypeGen.visitEnd(jvmPackageGen, module, jarEntries);
        jarEntries.put(this.typesClass + ".class", jvmPackageGen.getBytes(this.typesCw, module));
    }

    void createTypeConstants(ClassWriter cw, String moduleInitClass) {
        MethodVisitor mv = cw.visitMethod(9, "$createTypeConstants", "()V", null, null);
        mv.visitCode();
        String refTypeConstantsClass = this.jvmConstantsGen.getRefTypeConstantsClass();
        String arrayTypeConstantClass = this.jvmConstantsGen.getArrayTypeConstantClass();
        String tupleTypeConstantsClass = this.jvmConstantsGen.getTupleTypeConstantsClass();
        String unionTypeConstantClass = this.jvmConstantsGen.getUnionTypeConstantClass();
        String errorTypeConstantClass = this.jvmConstantsGen.getErrorTypeConstantClass();
        mv.visitMethodInsn(184, refTypeConstantsClass, "$typeref_type_init", "()V", false);
        mv.visitMethodInsn(184, arrayTypeConstantClass, "$array_type_init", "()V", false);
        mv.visitMethodInsn(184, tupleTypeConstantsClass, "$tuple_type_init", "()V", false);
        mv.visitMethodInsn(184, unionTypeConstantClass, "$union_type_init", "()V", false);
        mv.visitMethodInsn(184, errorTypeConstantClass, "$error_type_init", "()V", false);
        mv.visitMethodInsn(184, refTypeConstantsClass, "$populate_typeref_types", "()V", false);
        mv.visitMethodInsn(184, arrayTypeConstantClass, "$populate_array_types", "()V", false);
        mv.visitMethodInsn(184, tupleTypeConstantsClass, "$populate_tuple_types", "()V", false);
        mv.visitMethodInsn(184, unionTypeConstantClass, "$populate_union_types", "()V", false);
        mv.visitMethodInsn(184, errorTypeConstantClass, "$populate_error_typeS", "()V", false);
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "$createTypeConstants", moduleInitClass);
        mv.visitEnd();
    }

    void generateCreateTypesMethod(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs, String moduleInitClass, SymbolTable symbolTable) {
        this.createTypeConstants(cw, moduleInitClass);
        this.createTypesInstance(cw, typeDefs, moduleInitClass);
        Map<String, String> populateTypeFuncNames = this.populateTypes(cw, typeDefs, moduleInitClass, symbolTable);
        MethodVisitor mv = cw.visitMethod(9, "$createTypes", "()V", null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, this.typesClass, "$createTypeInstances", "()V", false);
        mv.visitMethodInsn(184, this.typesClass, "$createTypeConstants", "()V", false);
        for (Map.Entry<String, String> entry : populateTypeFuncNames.entrySet()) {
            String funcName = entry.getKey();
            String typeClassName = entry.getValue();
            mv.visitMethodInsn(184, typeClassName, funcName, "()V", false);
        }
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "$createTypes", moduleInitClass);
        mv.visitEnd();
    }

    private void createTypesInstance(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs, String moduleInitClass) {
        int instanceSplits = this.createTypesInstanceSplits(cw, typeDefs, moduleInitClass);
        MethodVisitor mv = cw.visitMethod(9, "$createTypeInstances", "()V", null, null);
        mv.visitCode();
        for (int i = 0; i < instanceSplits; ++i) {
            mv.visitMethodInsn(184, this.typesClass, "$createTypeInstances" + i, "()V", false);
        }
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "$createTypeInstances", moduleInitClass);
        mv.visitEnd();
    }

    private int createTypesInstanceSplits(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs, String typeOwnerClass) {
        if (typeDefs.isEmpty()) {
            return 0;
        }
        MethodVisitor mv = null;
        int bTypesCount = 0;
        int methodCount = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            String name = optionalTypeDef.internalName.value;
            BType bType = optionalTypeDef.type;
            int bTypeTag = bType.tag;
            if (JvmCodeGenUtil.needNoTypeGeneration(bTypeTag)) continue;
            if (bTypesCount % 100 == 0) {
                mv = cw.visitMethod(9, "$createTypeInstances" + methodCount++, "()V", null, null);
                mv.visitCode();
            }
            switch (bTypeTag) {
                case 12: {
                    this.jvmRecordTypeGen.createRecordType(mv, (BRecordType)bType, typeOwnerClass, name);
                    break;
                }
                case 34: {
                    this.jvmObjectTypeGen.createObjectType(mv, (BObjectType)bType);
                    break;
                }
                case 29: {
                    this.jvmErrorTypeGen.createErrorType(mv, (BErrorType)bType, bType.tsymbol.name.value);
                    break;
                }
                case 31: {
                    this.jvmTupleTypeGen.createTupleType(mv, (BTupleType)bType);
                    break;
                }
                default: {
                    this.jvmUnionTypeGen.createUnionType(mv, (BUnionType)bType);
                }
            }
            mv.visitFieldInsn(179, typeOwnerClass, JvmTypeGen.getTypeFieldName(name), "Lio/ballerina/runtime/api/types/Type;");
            if (++bTypesCount % 100 != 0) continue;
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, "$createTypeInstances", typeOwnerClass);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 100 != 0) {
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, "$createTypeInstances", typeOwnerClass);
            mv.visitEnd();
        }
        return methodCount;
    }

    private Map<String, String> populateTypes(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs, String typeOwnerClass, SymbolTable symbolTable) {
        HashMap<String, String> funcTypeClassMap = new HashMap<String, String>();
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            MethodVisitor mv;
            BType bType = optionalTypeDef.type;
            int bTypeTag = bType.tag;
            if (JvmCodeGenUtil.needNoTypeGeneration(bTypeTag)) continue;
            String fieldName = JvmTypeGen.getTypeFieldName(optionalTypeDef.internalName.value);
            String methodName = "$populate" + fieldName;
            switch (bTypeTag) {
                case 12: {
                    funcTypeClassMap.put(methodName, this.jvmRecordTypeGen.recordTypesClass);
                    mv = this.createPopulateTypeMethod(this.jvmRecordTypeGen.recordTypesCw, methodName, typeOwnerClass, fieldName);
                    this.jvmRecordTypeGen.populateRecord(mv, methodName, (BRecordType)bType, symbolTable);
                    break;
                }
                case 34: {
                    funcTypeClassMap.put(methodName, this.jvmObjectTypeGen.objectTypesClass);
                    mv = this.createPopulateTypeMethod(this.jvmObjectTypeGen.objectTypesCw, methodName, typeOwnerClass, fieldName);
                    this.jvmObjectTypeGen.populateObject(cw, mv, methodName, symbolTable, fieldName, (BObjectType)bType, new BIRVarToJVMIndexMap());
                    break;
                }
                case 29: {
                    funcTypeClassMap.put(methodName, this.jvmErrorTypeGen.errorTypesClass);
                    mv = this.createPopulateTypeMethod(this.jvmErrorTypeGen.errorTypesCw, methodName, typeOwnerClass, fieldName);
                    this.jvmErrorTypeGen.populateError(mv, (BErrorType)bType);
                    break;
                }
                case 31: {
                    funcTypeClassMap.put(methodName, this.jvmTupleTypeGen.tupleTypesClass);
                    mv = this.createPopulateTypeMethod(this.jvmTupleTypeGen.tupleTypesCw, methodName, typeOwnerClass, fieldName);
                    this.jvmTupleTypeGen.populateTuple(mv, (BTupleType)bType, symbolTable);
                    break;
                }
                default: {
                    funcTypeClassMap.put(methodName, this.jvmUnionTypeGen.unionTypesClass);
                    mv = this.createPopulateTypeMethod(this.jvmUnionTypeGen.unionTypesCw, methodName, typeOwnerClass, fieldName);
                    this.jvmUnionTypeGen.populateUnion(cw, mv, (BUnionType)bType, this.typesClass, fieldName, symbolTable);
                }
            }
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, methodName, typeOwnerClass);
            mv.visitEnd();
        }
        return funcTypeClassMap;
    }

    private MethodVisitor createPopulateTypeMethod(ClassWriter cw, String methodName, String typeOwnerClass, String fieldName) {
        MethodVisitor mv = cw.visitMethod(9, methodName, "()V", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, typeOwnerClass, fieldName, "Lio/ballerina/runtime/api/types/Type;");
        return mv;
    }

    public void addImmutableType(MethodVisitor mv, BType type, SymbolTable symbolTable) {
        if (type.tsymbol == null) {
            return;
        }
        Optional<BIntersectionType> immutableType = Types.getImmutableType(symbolTable, type.tsymbol.pkgID, (SelectivelyImmutableReferenceType)((Object)type));
        if (immutableType.isEmpty()) {
            return;
        }
        mv.visitInsn(89);
        this.jvmTypeGen.loadType(mv, immutableType.get());
        mv.visitMethodInsn(185, "io/ballerina/runtime/api/types/Type", "setImmutableType", "(Lio/ballerina/runtime/api/types/IntersectionType;)V", true);
    }

    public void loadTypeIdSet(MethodVisitor mv, BTypeIdSet typeIdSet) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BTypeIdSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTypeIdSet", "<init>", "()V", false);
        for (BTypeIdSet.BTypeId typeId : typeIdSet.getPrimary()) {
            this.addTypeId(mv, typeId, true);
        }
        for (BTypeIdSet.BTypeId typeId : typeIdSet.getSecondary()) {
            this.addTypeId(mv, typeId, false);
        }
    }

    private void addTypeId(MethodVisitor mv, BTypeIdSet.BTypeId typeId, boolean isPrimaryTypeId) {
        mv.visitInsn(89);
        String varName = this.jvmConstantsGen.getModuleConstantVar(typeId.packageID);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(), varName, "Lio/ballerina/runtime/api/Module;");
        mv.visitLdcInsn((Object)typeId.name);
        mv.visitInsn(isPrimaryTypeId ? 4 : 3);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BTypeIdSet", "add", "(Lio/ballerina/runtime/api/Module;Ljava/lang/String;Z)V", false);
    }

    public static List<Label> createLabelsForSwitch(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, int start, int length, Label defaultCaseLabel) {
        return JvmCreateTypeGen.createLabelsForSwitch(mv, nameRegIndex, nodes, start, length, defaultCaseLabel, true);
    }

    public static List<Label> createLabelsForSwitch(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, int start, int length, Label defaultCaseLabel, boolean decodeCase) {
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitMethodInsn(182, "java/lang/String", "hashCode", "()I", false);
        int i = 0;
        ArrayList<Label> labels = new ArrayList<Label>();
        int[] hashCodes = new int[length];
        for (int j = start; j < start + length; ++j) {
            NamedNode node = nodes.get(j);
            if (node == null) continue;
            labels.add(i, new Label());
            String name = decodeCase ? Utils.decodeIdentifier((String)node.getName().value) : node.getName().value;
            hashCodes[i] = name.hashCode();
            ++i;
        }
        mv.visitLookupSwitchInsn(defaultCaseLabel, hashCodes, labels.toArray(new Label[0]));
        return labels;
    }

    public static List<Label> createLabelsForEqualCheck(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, int start, int length, List<Label> labels, Label defaultCaseLabel) {
        return JvmCreateTypeGen.createLabelsForEqualCheck(mv, nameRegIndex, nodes, start, length, labels, defaultCaseLabel, true);
    }

    public static List<Label> createLabelsForEqualCheck(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, int start, int length, List<Label> labels, Label defaultCaseLabel, boolean decodeCase) {
        ArrayList<Label> targetLabels = new ArrayList<Label>();
        int i = 0;
        for (int j = start; j < start + length; ++j) {
            NamedNode node = nodes.get(j);
            if (node == null) continue;
            mv.visitLabel(labels.get(i));
            mv.visitVarInsn(25, nameRegIndex);
            if (decodeCase) {
                mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)node.getName().value));
            } else {
                mv.visitLdcInsn((Object)node.getName().value);
            }
            mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
            Label targetLabel = new Label();
            mv.visitJumpInsn(154, targetLabel);
            mv.visitJumpInsn(167, defaultCaseLabel);
            targetLabels.add(i, targetLabel);
            ++i;
        }
        return targetLabels;
    }

    public void generateAnonTypeClass(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, String moduleInitClass, JarEntries jarEntries) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(65, 33, this.anonTypesClass, null, "java/lang/Object", null);
        this.generateGetAnonTypeMainMethod(cw, module.typeDefs, moduleInitClass);
        cw.visitEnd();
        byte[] bytes = jvmPackageGen.getBytes(cw, module);
        jarEntries.put(this.anonTypesClass + ".class", bytes);
    }

    private void generateGetAnonTypeMainMethod(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefinitions, String moduleInitClass) {
        MethodVisitor mv = cw.visitMethod(9, "getAnonType", "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", null, null);
        mv.visitCode();
        TreeSet<BIRNode.BIRTypeDefinition> typeDefSet = new TreeSet<BIRNode.BIRTypeDefinition>(this.typeDefHashComparator);
        for (BIRNode.BIRTypeDefinition t : typeDefinitions) {
            if (!Symbols.isFlagOn(t.type.getFlags(), 2048L)) continue;
            typeDefSet.add(t);
        }
        AnonTypeHashInfo anonTypeHashSwitch = this.createLabelsForAnonTypeHashSwitch(typeDefSet);
        if (anonTypeHashSwitch.labelFieldMapping.isEmpty()) {
            Label defaultCaseLabel = new Label();
            JvmCodeGenUtil.createDefaultCase(mv, defaultCaseLabel, 1, "No such type: ");
        } else {
            mv.visitVarInsn(21, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, this.anonTypesClass, "getAnonType0", "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", false);
            mv.visitInsn(176);
            this.generateGetAnonTypeSplitMethods(cw, anonTypeHashSwitch, moduleInitClass);
        }
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "getAnonType", this.anonTypesClass);
        mv.visitEnd();
    }

    void generateGetAnonTypeSplitMethods(ClassWriter cw, AnonTypeHashInfo anonTypeHashSwitch, String typeOwnerClass) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        int hashParamRegIndex = 0;
        int shapeParamRegIndex = 1;
        Label defaultCaseLabel = new Label();
        Map<String, Label> labelFieldMapping = anonTypeHashSwitch.labelFieldMapping;
        int i = 0;
        for (Map.Entry<String, Label> labelEntry : labelFieldMapping.entrySet()) {
            if (bTypesCount % 100 == 0) {
                mv = cw.visitMethod(10, "getAnonType" + methodCount++, "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                mv.visitVarInsn(21, hashParamRegIndex);
                int remainingCases = labelFieldMapping.size() - bTypesCount;
                if (remainingCases > 100) {
                    remainingCases = 100;
                }
                int[] hashes = Arrays.copyOfRange(anonTypeHashSwitch.hashes, bTypesCount, bTypesCount + remainingCases);
                Label[] labels = Arrays.copyOfRange(anonTypeHashSwitch.labels, bTypesCount, bTypesCount + remainingCases);
                mv.visitLookupSwitchInsn(defaultCaseLabel, hashes, labels);
            }
            mv.visitVarInsn(21, hashParamRegIndex);
            String fieldName = labelEntry.getKey();
            Label targetLabel = labelEntry.getValue();
            mv.visitLabel(targetLabel);
            mv.visitFieldInsn(178, typeOwnerClass, fieldName, "Lio/ballerina/runtime/api/types/Type;");
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 100 != 0) continue;
            if (bTypesCount == labelFieldMapping.size()) {
                JvmCodeGenUtil.createDefaultCase(mv, defaultCaseLabel, shapeParamRegIndex, "No such type: ");
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(21, hashParamRegIndex);
                mv.visitVarInsn(25, shapeParamRegIndex);
                mv.visitMethodInsn(184, this.anonTypesClass, "getAnonType" + methodCount, "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", false);
                mv.visitInsn(176);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 100 != 0) {
            JvmCodeGenUtil.createDefaultCase(mv, defaultCaseLabel, shapeParamRegIndex, "No such type: ");
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }

    private AnonTypeHashInfo createLabelsForAnonTypeHashSwitch(Set<BIRNode.BIRTypeDefinition> nodes) {
        LinkedHashMap<String, Label> labelFieldMapping = new LinkedHashMap<String, Label>();
        LinkedHashMap<Integer, Label> labelHashMapping = new LinkedHashMap<Integer, Label>();
        for (BIRNode.BIRTypeDefinition node : nodes) {
            if (node == null) continue;
            BType type = node.type;
            String fieldName = JvmTypeGen.getTypeFieldName(node.internalName.value);
            Integer typeHash = this.typeHashVisitor.visit(type);
            boolean fieldExists = labelFieldMapping.containsKey(fieldName);
            boolean hashExists = labelHashMapping.containsKey(typeHash);
            if (!fieldExists && !hashExists) {
                Label label = new Label();
                labelFieldMapping.put(fieldName, label);
                labelHashMapping.put(typeHash, label);
            } else assert (fieldExists && hashExists);
            this.typeHashVisitor.reset();
        }
        int[] hashes = new int[10];
        int count = 0;
        for (Integer integer : labelHashMapping.keySet()) {
            int intValue = integer;
            if (hashes.length == count) {
                hashes = Arrays.copyOf(hashes, count * 2);
            }
            hashes[count++] = intValue;
        }
        hashes = Arrays.copyOfRange(hashes, 0, count);
        Label[] labels = labelHashMapping.values().toArray(new Label[0]);
        return new AnonTypeHashInfo(hashes, labels, labelFieldMapping);
    }

    public void generateRefTypeConstants(List<BIRNode.BIRTypeDefinition> typeDefs, SymbolTable symbolTable) {
        for (BIRNode.BIRTypeDefinition typeDef : typeDefs) {
            if (typeDef.referenceType == null) continue;
            this.jvmConstantsGen.getTypeConstantsVar(typeDef.referenceType, symbolTable);
        }
    }

    public void generateFunctionTypeClass(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries, List<BIRNode.BIRFunction> sortedFunctions) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(65, 33, this.functionTypesClass, null, "java/lang/Object", null);
        this.generateGetFunctionTypeMainMethod(cw, sortedFunctions);
        cw.visitEnd();
        byte[] bytes = jvmPackageGen.getBytes(cw, module);
        jarEntries.put(this.functionTypesClass + ".class", bytes);
    }

    private void generateGetFunctionTypeMainMethod(ClassWriter cw, List<BIRNode.BIRFunction> functions) {
        MethodVisitor mv = cw.visitMethod(9, "getFunctionType", "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/FunctionType;", null, null);
        mv.visitCode();
        if (functions.isEmpty()) {
            Label defaultCaseLabel = new Label();
            JvmCodeGenUtil.createDefaultCase(mv, defaultCaseLabel, 1, "No such function type: ");
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, this.functionTypesClass, "getFunctionType0", "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/FunctionType;", false);
            mv.visitInsn(176);
            this.generateGetFunctionTypeSplitMethods(cw, functions);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    void generateGetFunctionTypeSplitMethods(ClassWriter cw, List<BIRNode.BIRFunction> functions) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        int funcNameRegIndex = 0;
        Label defaultCaseLabel = new Label();
        int i = 0;
        List<Object> targetLabels = new ArrayList();
        List<BIRNode.BIRFunction> filteredFunctions = JvmCreateTypeGen.removeRecordDefaultValueFunctions(functions);
        for (BIRNode.BIRFunction func : filteredFunctions) {
            if (bTypesCount % 100 == 0) {
                mv = cw.visitMethod(10, "getFunctionType" + methodCount++, "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/FunctionType;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = filteredFunctions.size() - bTypesCount;
                if (remainingCases > 100) {
                    remainingCases = 100;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, funcNameRegIndex, filteredFunctions, bTypesCount, remainingCases, defaultCaseLabel, false);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, funcNameRegIndex, filteredFunctions, bTypesCount, remainingCases, labels, defaultCaseLabel, false);
                i = 0;
            }
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            mv.visitFieldInsn(178, this.jvmConstantsGen.getFunctionTypeConstantClass(), this.jvmConstantsGen.getFunctionTypeVar(func.name.value), "Lio/ballerina/runtime/api/types/FunctionType;");
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 100 != 0) continue;
            if (bTypesCount == filteredFunctions.size()) {
                JvmCodeGenUtil.createDefaultCase(mv, defaultCaseLabel, funcNameRegIndex, "No such function type: ");
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(184, this.functionTypesClass, "getFunctionType" + methodCount, "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/FunctionType;", false);
                mv.visitInsn(176);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 100 != 0) {
            JvmCodeGenUtil.createDefaultCase(mv, defaultCaseLabel, funcNameRegIndex, "No such function type: ");
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }

    private static List<BIRNode.BIRFunction> removeRecordDefaultValueFunctions(List<BIRNode.BIRFunction> functions) {
        ArrayList<BIRNode.BIRFunction> filteredFunctions = new ArrayList<BIRNode.BIRFunction>();
        for (BIRNode.BIRFunction func : functions) {
            String funcName = func.name.value;
            if (funcName.contains("$rec$")) continue;
            filteredFunctions.add(func);
        }
        return filteredFunctions;
    }

    public void splitAddFields(ClassWriter cw, String typeClassName, String methodName, Map<String, BField> fields) {
        int fieldMapIndex = 0;
        MethodVisitor mv = null;
        int methodCount = 0;
        int fieldsCount = 0;
        String addFieldMethod = methodName + "$addField$";
        for (BField optionalField : fields.values()) {
            if (fieldsCount % 500 == 0) {
                mv = cw.visitMethod(10, addFieldMethod, "(Ljava/util/LinkedHashMap;)V", null, null);
                mv.visitCode();
                addFieldMethod = methodName + "$addField$" + ++methodCount;
            }
            mv.visitVarInsn(25, fieldMapIndex);
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)optionalField.name.value));
            this.createField(mv, optionalField);
            mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitInsn(87);
            if (++fieldsCount % 500 != 0) continue;
            if (fieldsCount != fields.size()) {
                mv.visitVarInsn(25, fieldMapIndex);
                mv.visitMethodInsn(184, typeClassName, addFieldMethod, "(Ljava/util/LinkedHashMap;)V", false);
            }
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, methodName, typeClassName);
            mv.visitEnd();
        }
        if (methodCount != 0 && fieldsCount % 500 != 0) {
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, methodName, typeClassName);
            mv.visitEnd();
        }
    }

    private void createField(MethodVisitor mv, BField field) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BField");
        mv.visitInsn(89);
        this.jvmTypeGen.loadType(mv, field.symbol.type);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)field.name.value));
        mv.visitLdcInsn((Object)field.symbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BField", "<init>", "(Lio/ballerina/runtime/api/types/Type;Ljava/lang/String;J)V", false);
    }

    public JvmUnionTypeGen getJvmUnionTypeGen() {
        return this.jvmUnionTypeGen;
    }

    public JvmErrorTypeGen getJvmErrorTypeGen() {
        return this.jvmErrorTypeGen;
    }

    public JvmTupleTypeGen getJvmTupleTypeGen() {
        return this.jvmTupleTypeGen;
    }

    public JvmArrayTypeGen getJvmArrayTypeGen() {
        return this.jvmArrayTypeGen;
    }

    public JvmRefTypeGen getJvmRefTypeGen() {
        return this.jvmRefTypeGen;
    }

    public JvmTypeGen getJvmTypeGen() {
        return this.jvmTypeGen;
    }

    static class AnonTypeHashInfo {
        int[] hashes;
        Label[] labels;
        Map<String, Label> labelFieldMapping;

        public AnonTypeHashInfo(int[] hashes, Label[] labels, Map<String, Label> labelFieldMapping) {
            this.hashes = hashes;
            this.labels = labels;
            this.labelFieldMapping = labelFieldMapping;
        }
    }
}

