/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split;

import java.util.List;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmAnnotationsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmValueCreatorGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeHashVisitor;

public class JvmMethodsSplitter {
    private final JvmPackageGen jvmPackageGen;
    private final JvmCreateTypeGen jvmCreateTypeGen;
    private final JvmValueCreatorGen jvmValueCreatorGen;
    private final JvmAnnotationsGen jvmAnnotationsGen;
    private final BIRNode.BIRPackage module;
    private final String moduleInitClass;

    public JvmMethodsSplitter(JvmPackageGen jvmPackageGen, JvmConstantsGen jvmConstantsGen, BIRNode.BIRPackage module, String moduleInitClass, TypeHashVisitor typeHashVisitor, JvmTypeGen jvmTypeGen) {
        this.module = module;
        this.jvmPackageGen = jvmPackageGen;
        this.moduleInitClass = moduleInitClass;
        this.jvmCreateTypeGen = new JvmCreateTypeGen(jvmTypeGen, jvmConstantsGen, module.packageID, typeHashVisitor);
        this.jvmAnnotationsGen = new JvmAnnotationsGen(module, jvmPackageGen, jvmTypeGen);
        this.jvmValueCreatorGen = new JvmValueCreatorGen(module.packageID, jvmTypeGen);
        jvmConstantsGen.setJvmCreateTypeGen(this.jvmCreateTypeGen);
    }

    public void generateMethods(JarEntries jarEntries, JvmCastGen jvmCastGen, List<BIRNode.BIRFunction> sortedFunctions) {
        this.jvmCreateTypeGen.generateRefTypeConstants(this.module.typeDefs, this.jvmPackageGen.symbolTable);
        this.jvmCreateTypeGen.generateTypeClass(this.jvmPackageGen, this.module, jarEntries, this.moduleInitClass, this.jvmPackageGen.symbolTable);
        this.jvmValueCreatorGen.generateValueCreatorClasses(this.jvmPackageGen, this.module, this.moduleInitClass, jarEntries, this.jvmPackageGen.symbolTable, jvmCastGen, sortedFunctions);
        this.jvmCreateTypeGen.generateAnonTypeClass(this.jvmPackageGen, this.module, this.moduleInitClass, jarEntries);
        this.jvmCreateTypeGen.generateFunctionTypeClass(this.jvmPackageGen, this.module, jarEntries, sortedFunctions);
        this.jvmAnnotationsGen.generateAnnotationsClass(jarEntries);
    }
}

