/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;

public class JvmFunctionTypeConstantsGen {
    private final String functionTypeConstantClass;
    private final List<BIRNode.BIRFunction> functions;
    private JvmTypeGen jvmTypeGen;

    public JvmFunctionTypeConstantsGen(PackageID module, List<BIRNode.BIRFunction> functions) {
        this.functionTypeConstantClass = JvmCodeGenUtil.getModuleLevelClassName(module, "constants/$_function_type_constants");
        this.functions = functions;
    }

    public void generateClass(JarEntries jarEntries) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(52, 33, this.functionTypeConstantClass, null, "java/lang/Object", null);
        MethodVisitor mv = cw.visitMethod(2, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        this.functions.forEach(func -> this.visitFunctionTypeFields(cw, func.name.value));
        this.generateFunctionTypeInits(cw);
        this.generateStaticInitializer(cw);
        cw.visitEnd();
        jarEntries.put(this.functionTypeConstantClass + ".class", cw.toByteArray());
    }

    private void visitFunctionTypeFields(ClassWriter cw, String functionName) {
        FieldVisitor fv = cw.visitField(25, this.getFunctionTypeVar(functionName), "Lio/ballerina/runtime/api/types/FunctionType;", null, null);
        fv.visitEnd();
    }

    private void generateFunctionTypeInits(ClassWriter cw) {
        MethodVisitor mv = null;
        int functionTypeCount = 0;
        int methodCount = 0;
        for (BIRNode.BIRFunction function : this.functions) {
            if (functionTypeCount % 140 == 0) {
                mv = cw.visitMethod(8, "$function_type_init" + methodCount++, "()V", null, null);
            }
            this.jvmTypeGen.loadInvokableType(mv, function.type);
            mv.visitFieldInsn(179, this.functionTypeConstantClass, this.getFunctionTypeVar(function.name.value), "Lio/ballerina/runtime/api/types/FunctionType;");
            if (++functionTypeCount % 140 != 0) continue;
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        if (functionTypeCount % 140 != 0) {
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void generateStaticInitializer(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        int methodIndex = (this.functions.size() - 1) / 140;
        for (int i = 0; i <= methodIndex; ++i) {
            mv.visitMethodInsn(184, this.functionTypeConstantClass, "$function_type_init" + i, "()V", false);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public String getFunctionTypeVar(String functionName) {
        return functionName + "$functionType";
    }

    public void setJvmTypeGen(JvmTypeGen jvmTypeGen) {
        this.jvmTypeGen = jvmTypeGen;
    }

    public String getFunctionTypeConstantClass() {
        return this.functionTypeConstantClass;
    }
}

